package Alien::wxWidgets::Config::gtk2_gcc;

use strict;

our %VALUES;

{
    no strict 'vars';
    %VALUES = %{
$VAR1 = {
          'alien_package' => 'Alien::wxWidgets::Config::gtk2_gcc',
          'config' => {
                        'unicode' => 0,
                        'mslu' => 0,
                        'compiler_kind' => 'gcc',
                        'compiler_version' => '3.4',
                        'toolkit' => 'gtk2',
                        'build' => 'multi',
                        'debug' => 0
                      },
          'link_flags' => '',
          'c_flags' => '-pthread ',
          'linker' => 'c++ -shared -fPIC  ',
          'link_libraries' => ' -L/usr/local/lib -pthread -L/usr/local/lib -L/usr/X11R6/lib',
          'include_path' => '-I/usr/local/lib/wx/include/gtk2-unicode-release-2.8 -I/usr/local/include ',
          'version' => '2.008012',
          'alien_base' => 'gtk2_gcc',
          '_libraries' => {
                            'core' => {
                                        'link' => '-lwx_gtk2_core',
                                        'dll' => 'libwx_gtk2_core.so.3.0'
                                      },
                            'fl' => {
                                      'dll' => 'libwx_gtk2_fl.so.3.0',
                                      'link' => '-lwx_gtk2_fl'
                                    },
                            'gizmos' => {
                                          'link' => '-lwx_gtk2_gizmos',
                                          'dll' => 'libwx_gtk2_gizmos.so.3.0'
                                        },
                            'xrc' => {
                                       'dll' => 'libwx_gtk2_xrc.so.3.0',
                                       'link' => '-lwx_gtk2_xrc'
                                     },
                            'xml' => {
                                       'dll' => 'libwx_base_xml.so.3.0',
                                       'link' => '-lwx_base_xml'
                                     },
                            'html' => {
                                        'dll' => 'libwx_gtk2_html.so.3.0',
                                        'link' => '-lwx_gtk2_html'
                                      },
                            'richtext' => {
                                            'dll' => 'libwx_gtk2_richtext.so.3.0',
                                            'link' => '-lwx_gtk2_richtext'
                                          },
                            'qa' => {
                                      'link' => '-lwx_gtk2_qa',
                                      'dll' => 'libwx_gtk2_qa.so.3.0'
                                    },
                            'net' => {
                                       'link' => '-lwx_base_net',
                                       'dll' => 'libwx_base_net.so.3.0'
                                     },
                            'adv' => {
                                       'link' => '-lwx_gtk2_adv',
                                       'dll' => 'libwx_gtk2_adv.so.3.0'
                                     },
                            'gl' => {
                                      'link' => '-lwx_gtk2_gl',
                                      'dll' => 'libwx_gtk2_gl.so.3.0'
                                    },
                            'base' => {
                                        'dll' => 'libwx_base.so.3.0',
                                        'link' => '-lwx_base'
                                      },
                            'aui' => {
                                       'link' => '-lwx_gtk2_aui',
                                       'dll' => 'libwx_gtk2_aui.so.3.0'
                                     },
                            'stc' => {
                                       'dll' => 'libwx_gtk2_stc.so.3.0',
                                       'link' => '-lwx_gtk2_stc'
                                     }
                          },
          'compiler' => 'c++',
          'prefix' => '/usr/local',
          'defines' => '-D_FILE_OFFSET_BITS=64 -D_LARGE_FILES -D_IODBC_ -D__WXGTK__ '
        };
    };
}

my $key = substr __PACKAGE__, 1 + rindex __PACKAGE__, ':';

sub values { %VALUES, key => $key }

sub config {
   +{ %{$VALUES{config}},
      package       => __PACKAGE__,
      key           => $key,
      version       => $VALUES{version},
      }
}

1;
