/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */

package org.netbeans.microedition.databinding.pim;

import javax.microedition.pim.PIM;
import javax.microedition.pim.ToDo;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;


/**
 *
 * @author Michal Skvor
 */
public final class ToDoDataSet implements DataSet {

    public static final String NOTE             = "note";
    public static final String SUMMARY          = "summary";
    public static final String UID              = "uid";
    public static final String CLASS            = "class";
    public static final String PRIORITY         = "priority";
    public static final String COMPLETION_DATE  = "completion_date";
    public static final String DUE              = "due";
    public static final String REVISION         = "revision";
    public static final String COMPLETED        = "completed";        

    private int todoIndex;

    private ItemDataSet note, summary, uid, clazz, priority, completion_date;
    private ItemDataSet due, revision, completed;

    public ToDoDataSet( int todoIndex ) {
        this.todoIndex = todoIndex;
    }

    public Class getType( String dataItemName ) throws DataBindingException {
        return DataSet.class;
    }

    public Object getValue( String dataItemName ) throws DataBindingException {
        if( NOTE.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.NOTE )) {
                if( note == null ) 
                    note = new ItemDataSet( PIM.TODO_LIST, todoIndex, ToDo.NOTE, Query.STRING_TYPE );
                return note;
            }                
        } else if( SUMMARY.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.SUMMARY )) {
                if( summary == null ) summary = new ItemDataSet( PIM.TODO_LIST, todoIndex, ToDo.SUMMARY, Query.STRING_TYPE );
                return summary;
            }
        } else if( UID.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.UID )) {
                if( uid == null ) uid = new ItemDataSet( PIM.TODO_LIST, todoIndex, ToDo.UID, Query.STRING_TYPE );
                return uid;
            }
        } else if( CLASS.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.CLASS )) {
                if( clazz == null ) clazz = new ItemDataSet( PIM.TODO_LIST, todoIndex, ToDo.CLASS, Query.INTEGER_TYPE );
                return clazz;
            }
        } else if( PRIORITY.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.PRIORITY )) {
                if( priority == null ) priority = new ItemDataSet( PIM.TODO_LIST, todoIndex, ToDo.PRIORITY, Query.INTEGER_TYPE );
                return priority;
            }
        } else if( COMPLETION_DATE.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.COMPLETION_DATE )) {
            }
        } else if( DUE.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.DUE )) {
                return Query.getField( PIM.TODO_LIST, todoIndex, ToDo.DUE, 0, Query.DATE_TYPE );
            }
        } else if( REVISION.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.REVISION )) {
            }
        } else if( COMPLETED.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.TODO_LIST, ToDo.COMPLETED )) {
                if( completed == null ) completed = new ItemDataSet( PIM.TODO_LIST, todoIndex, ToDo.COMPLETED, Query.BOOLEAN_TYPE );
                return completed;
            }
        }
        throw new DataBindingException( "Unsupported data item : " + dataItemName );
    }

    public void setValue( String dataItemName, Object value ) throws DataBindingException {
        throw new DataBindingException( "Not implemented yet." );
    }

    public void setAsString( String dataItemName, String value ) throws DataBindingException {
        throw new DataBindingException( "Not implemented yet." );
    }

    public boolean isReadOnly( String dataItemName ) throws DataBindingException {
        return false;
    }
}
