/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexFactory;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Parameters;

public final class QuerySupport {
    private static final Logger LOG = Logger.getLogger(QuerySupport.class.getName());
    private final IndexerQuery indexerQuery;
    private final List<URL> roots;

    public static Collection<FileObject> findRoots(FileObject f, Collection<String> sourcePathIds, Collection<String> libraryPathIds, Collection<String> binaryLibraryPathIds) {
        HashSet<FileObject> roots = new HashSet<FileObject>();
        if (sourcePathIds == null) {
            sourcePathIds = PathRecognizerRegistry.getDefault().getSourceIds();
        }
        if (libraryPathIds == null) {
            libraryPathIds = PathRecognizerRegistry.getDefault().getLibraryIds();
        }
        if (binaryLibraryPathIds == null) {
            binaryLibraryPathIds = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
        }
        QuerySupport.collectClasspathRoots(f, sourcePathIds, false, roots);
        QuerySupport.collectClasspathRoots(f, libraryPathIds, false, roots);
        QuerySupport.collectClasspathRoots(f, binaryLibraryPathIds, true, roots);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Roots for file " + f + ", sourcePathIds=" + sourcePathIds + ", libraryPathIds=" + libraryPathIds + ", binaryPathIds=" + binaryLibraryPathIds + ": ");
            for (FileObject root : roots) {
                try {
                    LOG.fine("  " + root.getURL());
                }
                catch (FileStateInvalidException ex) {}
            }
            LOG.fine("----");
        }
        return roots != null ? roots : Collections.emptySet();
    }

    public static Collection<FileObject> findRoots(Project project, Collection<String> sourcePathIds, Collection<String> libraryPathIds, Collection<String> binaryLibraryPathIds) {
        HashSet<Object> roots = new HashSet<FileObject>();
        if (sourcePathIds == null) {
            sourcePathIds = PathRecognizerRegistry.getDefault().getSourceIds();
        }
        if (libraryPathIds == null) {
            libraryPathIds = PathRecognizerRegistry.getDefault().getLibraryIds();
        }
        if (binaryLibraryPathIds == null) {
            binaryLibraryPathIds = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
        }
        QuerySupport.collectClasspathRoots(null, sourcePathIds, false, roots);
        QuerySupport.collectClasspathRoots(null, libraryPathIds, false, roots);
        QuerySupport.collectClasspathRoots(null, binaryLibraryPathIds, true, roots);
        if (project != null) {
            HashSet<FileObject> rootsInProject = new HashSet<FileObject>();
            for (FileObject fileObject : roots) {
                if (FileOwnerQuery.getOwner((FileObject)fileObject) != project) continue;
                rootsInProject.add(fileObject);
            }
            roots = rootsInProject;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Roots for project " + project + ", sourcePathIds=" + sourcePathIds + ", libraryPathIds=" + libraryPathIds + ", binaryPathIds=" + binaryLibraryPathIds + ": ");
            for (FileObject fileObject : roots) {
                try {
                    LOG.fine("  " + fileObject.getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {}
            }
            LOG.fine("----");
        }
        return roots;
    }

    public static QuerySupport forRoots(String indexerName, int indexerVersion, URL ... roots) throws IOException {
        Parameters.notNull((CharSequence)"indexerName", (Object)indexerName);
        Parameters.notNull((CharSequence)"roots", (Object)roots);
        return new QuerySupport(indexerName, indexerVersion, roots);
    }

    public static QuerySupport forRoots(String indexerName, int indexerVersion, FileObject ... roots) throws IOException {
        Parameters.notNull((CharSequence)"indexerName", (Object)indexerName);
        Parameters.notNull((CharSequence)"roots", (Object)roots);
        ArrayList<URL> rootsURL = new ArrayList<URL>(roots.length);
        for (FileObject root : roots) {
            rootsURL.add(root.getURL());
        }
        return new QuerySupport(indexerName, indexerVersion, rootsURL.toArray(new URL[rootsURL.size()]));
    }

    public Collection<? extends IndexResult> query(final String fieldName, final String fieldValue, final Kind kind, final String ... fieldsToLoad) throws IOException {
        Parameters.notNull((CharSequence)"fieldName", (Object)fieldName);
        Parameters.notNull((CharSequence)"fieldValue", (Object)fieldValue);
        Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
        try {
            return Utilities.runPriorityIO(new Callable<Collection<? extends IndexResult>>(){

                @Override
                public Collection<? extends IndexResult> call() throws Exception {
                    URL root;
                    Iterable<? extends Pair<URL, IndexImpl>> indices = QuerySupport.this.indexerQuery.getIndices(QuerySupport.this.roots);
                    for (Pair<URL, IndexImpl> pair : indices) {
                        IndexImpl indexImpl = (IndexImpl)pair.second;
                        Collection<? extends String> staleFiles = indexImpl.getStaleFiles();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Index: " + indexImpl + ", staleFiles: " + staleFiles);
                        }
                        if (staleFiles == null || staleFiles.size() <= 0) continue;
                        root = (URL)pair.first;
                        LinkedList<URL> list = new LinkedList<URL>();
                        for (String string : staleFiles) {
                            try {
                                list.add(Util.resolveUrl(root, string));
                            }
                            catch (MalformedURLException ex) {
                                LOG.log(Level.WARNING, null, ex);
                            }
                        }
                        IndexingManager.getDefault().refreshIndexAndWait(root, list);
                    }
                    LinkedList<IndexResult> result = new LinkedList<IndexResult>();
                    for (Pair<URL, IndexImpl> pair : indices) {
                        IndexImpl index = (IndexImpl)pair.second;
                        root = (URL)pair.first;
                        Collection<? extends IndexDocumentImpl> pr = index.query(fieldName, fieldValue, kind, fieldsToLoad);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("query(\"" + fieldName + "\", \"" + fieldValue + "\", " + (Object)((Object)kind) + ", " + QuerySupport.printFiledToLoad(fieldsToLoad) + ") invoked at " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[indexer=" + QuerySupport.this.indexerQuery.getIndexerId() + "]:");
                            for (IndexDocumentImpl indexDocumentImpl : pr) {
                                LOG.fine(" " + indexDocumentImpl);
                            }
                            LOG.fine("----");
                        }
                        for (IndexDocumentImpl indexDocumentImpl : pr) {
                            result.add(new IndexResult(indexDocumentImpl, root));
                        }
                    }
                    return result;
                }
            });
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private QuerySupport(String indexerName, int indexerVersion, URL ... roots) throws IOException {
        this.indexerQuery = IndexerQuery.forIndexer(indexerName, indexerVersion);
        this.roots = new LinkedList<URL>(Arrays.asList(roots));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[indexer=" + this.indexerQuery.getIndexerId() + "]:");
            for (Pair<URL, IndexImpl> pair : this.indexerQuery.getIndices(this.roots)) {
                LOG.fine(" " + pair.first + " -> index: " + pair.second);
            }
            LOG.fine("----");
        }
    }

    private static void collectClasspathRoots(FileObject file, Collection<String> pathIds, boolean binaryPaths, Collection<FileObject> roots) {
        for (String id : pathIds) {
            Collection<FileObject> classpathRoots = QuerySupport.getClasspathRoots(file, id);
            if (binaryPaths) {
                for (FileObject binRoot : classpathRoots) {
                    URL binRootUrl;
                    try {
                        binRootUrl = binRoot.getURL();
                    }
                    catch (FileStateInvalidException fsie) {
                        continue;
                    }
                    URL[] srcRoots = PathRegistry.getDefault().sourceForBinaryQuery(binRootUrl, null, false);
                    if (srcRoots != null) {
                        LOG.log(Level.FINE, "Translating {0} -> {1}", new Object[]{binRootUrl, srcRoots});
                        for (URL srcRootUrl : srcRoots) {
                            FileObject srcRoot = RepositoryUpdater.URLCache.getInstance().findFileObject(srcRootUrl);
                            if (srcRoot == null) continue;
                            roots.add(srcRoot);
                        }
                        continue;
                    }
                    LOG.log(Level.FINE, "No sources for {0}, adding bin root", binRootUrl);
                    roots.add(binRoot);
                }
                continue;
            }
            roots.addAll(classpathRoots);
        }
    }

    private static Collection<FileObject> getClasspathRoots(FileObject file, String classpathId) {
        Collection<FileObject> roots = Collections.emptySet();
        if (file != null) {
            ClassPath classpath = ClassPath.getClassPath((FileObject)file, (String)classpathId);
            if (classpath != null) {
                roots = Arrays.asList(classpath.getRoots());
            }
        } else {
            roots = new HashSet();
            Set<URL> urls = PathRegistry.getDefault().getRootsMarkedAs(classpathId);
            for (URL url : urls) {
                FileObject f = RepositoryUpdater.URLCache.getInstance().findFileObject(url);
                if (f == null) continue;
                roots.add(f);
            }
        }
        return roots;
    }

    private static String printFiledToLoad(String ... fieldsToLoad) {
        if (fieldsToLoad == null || fieldsToLoad.length == 0) {
            return "<all-fields>";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldsToLoad.length; ++i) {
            sb.append("\"").append(fieldsToLoad[i]).append("\"");
            if (i + 1 >= fieldsToLoad.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    static final class IndexerQuery {
        private static final Map<String, IndexerQuery> queries = new HashMap<String, IndexerQuery>();
        static IndexFactoryImpl indexFactory = new LuceneIndexFactory();
        private final String indexerId;
        private final Map<URL, Reference<IndexImpl>> root2index = new HashMap<URL, Reference<IndexImpl>>();

        public static synchronized IndexerQuery forIndexer(String indexerName, int indexerVersion) {
            String indexerId = SPIAccessor.getInstance().getIndexerPath(indexerName, indexerVersion);
            IndexerQuery q = queries.get(indexerId);
            if (q == null) {
                q = new IndexerQuery(indexerId);
                queries.put(indexerId, q);
            }
            return q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<? extends Pair<URL, IndexImpl>> getIndices(List<? extends URL> roots) {
            Map<URL, Reference<IndexImpl>> map = this.root2index;
            synchronized (map) {
                LinkedList<Pair<URL, IndexImpl>> indices = new LinkedList<Pair<URL, IndexImpl>>();
                for (URL uRL : roots) {
                    IndexImpl index;
                    Reference<IndexImpl> indexRef = this.root2index.get(uRL);
                    IndexImpl indexImpl = index = indexRef != null ? indexRef.get() : null;
                    if (index == null) {
                        index = this.findIndex(uRL);
                        if (index != null) {
                            this.root2index.put(uRL, new SoftReference<IndexImpl>(index));
                        } else {
                            this.root2index.remove(uRL);
                        }
                    }
                    if (index == null) continue;
                    indices.add(Pair.of(uRL, index));
                }
                return indices;
            }
        }

        public String getIndexerId() {
            return this.indexerId;
        }

        private IndexerQuery(String indexerId) {
            this.indexerId = indexerId;
        }

        private IndexImpl findIndex(URL root) {
            try {
                FileObject cacheFolder = CacheFolder.getDataFolder(root);
                assert (cacheFolder != null);
                FileObject indexFolder = cacheFolder.getFileObject(this.indexerId);
                if (indexFolder != null) {
                    return indexFactory.getIndex(indexFolder);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.INFO, "Can't create index for " + this.indexerId + " and " + root, ioe);
            }
            return null;
        }
    }

    public static enum Kind {
        EXACT,
        PREFIX,
        CASE_INSENSITIVE_PREFIX,
        CAMEL_CASE,
        REGEXP,
        CASE_INSENSITIVE_REGEXP,
        CASE_INSENSITIVE_CAMEL_CASE;

    }
}

