/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class AddElifBlockAction
extends PreprocessorEditorContextAction {
    public static final String NAME = "add-elif-block-action";
    private WeakReference<JTextComponent> textComponent;
    private ArrayList<PPLine> preprocessorLineList;

    public AddElifBlockAction() {
        super(NAME);
    }

    @Override
    public boolean isEnabled(ProjectConfigurationsHelper cfgProvider, ArrayList<PPLine> preprocessorLineList, JTextComponent target) {
        if (cfgProvider != null && preprocessorLineList != null && target != null) {
            this.textComponent = new WeakReference<JTextComponent>(target);
            this.preprocessorLineList = preprocessorLineList;
        } else {
            this.textComponent = null;
        }
        return cfgProvider != null && cfgProvider.isPreprocessorOn() && cfgProvider.getConfigurations().size() > 1 && this.isInsideIfChain(target, preprocessorLineList) && !this.overlapsBlockBorders(target, preprocessorLineList) && !this.overlapsGuardedBlocks(target);
    }

    public String getPopupMenuText(ProjectConfigurationsHelper cfgProvider, ArrayList preprocessorLineList, JTextComponent target) {
        return NbBundle.getMessage(AddElifBlockAction.class, (String)"LBL_Add_Elif_Block");
    }

    private boolean isInsideIfChain(JTextComponent target, ArrayList<PPLine> preprocessorLineList) {
        int x = this.getSelectionStartLine(target);
        if (x >= preprocessorLineList.size()) {
            return false;
        }
        PPBlockInfo b = this.getBlock(target, preprocessorLineList);
        return b != null && (b.getType() == 0 || b.getType() == 2 || b.getType() == 3 || b.getType() == 5 || b.getType() == 6 || b.getType() == 7 || b.getType() == 4);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent txt) {
        if (txt != null && this.textComponent != null && txt.equals(this.textComponent.get())) {
            try {
                final PPBlockInfo b = this.getBlock(txt, this.preprocessorLineList);
                if (b != null) {
                    int e;
                    int s;
                    final BaseDocument doc = (BaseDocument)txt.getDocument();
                    if (txt.getSelectionStart() == txt.getSelectionEnd()) {
                        s = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)b.getStartLine());
                        e = Utilities.getRowEnd((JTextComponent)txt, (int)Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(b.getEndLine() - (b.hasFooter() ? 2 : 1))));
                    } else {
                        s = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(this.getSelectionStartLine(txt) - 1));
                        e = Utilities.getRowEnd((JTextComponent)txt, (int)Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(this.getSelectionEndLine(txt) - 1)));
                    }
                    final String text = txt.getText(s, e - s);
                    NbDocument.runAtomic((StyledDocument)((StyledDocument)txt.getDocument()), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (b.getType() == 4) {
                                    int offs = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(b.getStartLine() - 1));
                                    doc.insertString(offs, "//#elif \n" + text + "\n", null);
                                    txt.setSelectionStart(offs + 8);
                                    txt.setSelectionEnd(offs + 8);
                                } else {
                                    int offs = Utilities.getRowEnd((JTextComponent)txt, (int)Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(b.getEndLine() - (b.hasFooter() ? 2 : 1))));
                                    doc.insertString(offs, "\n//#elif \n" + text, null);
                                    txt.setSelectionStart(offs + 9);
                                    txt.setSelectionEnd(offs + 9);
                                }
                            }
                            catch (BadLocationException ble) {
                                ErrorManager.getDefault().notify((Throwable)ble);
                            }
                            RecommentAction.actionPerformed(txt);
                        }
                    });
                    Completion.get().showCompletion();
                }
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
        }
    }
}

