/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.api;

import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.terminalemulator.Term;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public abstract class IOTerm {
    private static IOTerm find(InputOutput io) {
        if (io instanceof Lookup.Provider) {
            Lookup.Provider p = (Lookup.Provider)io;
            return (IOTerm)p.getLookup().lookup(IOTerm.class);
        }
        return null;
    }

    public static boolean isSupported(InputOutput io) {
        return IOTerm.find(io) != null;
    }

    public static Term term(InputOutput io) {
        IOTerm iot = IOTerm.find(io);
        if (iot != null) {
            return iot.term();
        }
        return null;
    }

    public static void connect(InputOutput io, OutputStream pin, InputStream pout, InputStream perr) {
        IOTerm iot = IOTerm.find(io);
        if (iot == null) {
            return;
        }
        iot.connect(pin, pout, perr);
    }

    public static void disconnect(InputOutput io, Runnable continuation) {
        IOTerm iot = IOTerm.find(io);
        if (iot == null) {
            return;
        }
        iot.disconnect(continuation);
    }

    protected abstract Term term();

    protected abstract void connect(OutputStream var1, InputStream var2, InputStream var3);

    protected abstract void disconnect(Runnable var1);
}

