/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.elements;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ElementSupport {
    private static final InfoPresenter.Resolver LIST_ELEMENT_RESOLVER = new ElementResolver("string", "org/netbeans/modules/vmd/midp/resources/components/element_16.png");
    private static final InfoPresenter.Resolver CHOICE_ELEMENT_RESOLVER = new ElementResolver("string", "org/netbeans/modules/vmd/midp/resources/components/element_16.png");

    public static InfoPresenter.Resolver createListElementInfoResolver() {
        return LIST_ELEMENT_RESOLVER;
    }

    static InfoPresenter.Resolver createChoiceElementInfoResolver() {
        return CHOICE_ELEMENT_RESOLVER;
    }

    private static class ElementResolver
    implements InfoPresenter.Resolver {
        private String propertyName;
        private Image icon;

        private ElementResolver(String propertyName, String iconResource) {
            this.propertyName = propertyName;
            this.icon = ImageUtilities.loadImage((String)iconResource);
        }

        public DesignEventFilter getEventFilter(DesignComponent component) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(component, false);
        }

        public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return this.resolveName(component);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(ElementSupport.class, (String)"TYPE_Element");
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private String resolveName(DesignComponent component) {
            return MidpValueSupport.getHumanReadableString(component.readProperty(this.propertyName));
        }

        public boolean isEditable(DesignComponent component) {
            return true;
        }

        public String getEditableName(DesignComponent component) {
            PropertyValue value = component.readProperty(this.propertyName);
            if (value.getKind() == PropertyValue.Kind.VALUE) {
                return MidpTypes.getString(value);
            }
            return "";
        }

        public void setEditableName(DesignComponent component, String enteredName) {
            assert (enteredName != null);
            component.writeProperty(this.propertyName, MidpTypes.createStringValue(enteredName));
        }

        public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
            return iconType == InfoPresenter.IconType.COLOR_16x16 ? this.icon : null;
        }
    }
}

