/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private String viewType;
    private JComponent view;
    private JComponent buttonsPane;
    private List models = new ArrayList(11);
    private List hyperModels;
    private List<? extends SessionProvider> sessionProviders;
    private Session currentSession;
    private List treeModels;
    private List treeModelFilters;
    private List treeExpansionModels;
    private List treeExpansionModelFilters;
    private List nodeModels;
    private List nodeModelFilters;
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private List asynchModelFilters;
    private List<AbstractButton> buttons;
    private JTabbedPane tabbedPane;
    private Image viewIcon;
    private ObjectVariable variable;
    private SessionProvider providerToDisplay;
    private List<ViewModelListener> subListeners = new ArrayList<ViewModelListener>();
    private String propertiesHelpID = null;

    ViewModelListener(String viewType, JComponent view, JComponent buttonsPane, String propertiesHelpID, Image viewIcon, ObjectVariable variable) {
        this.viewType = viewType;
        this.view = view;
        this.buttonsPane = buttonsPane;
        this.propertiesHelpID = propertiesHelpID;
        this.viewIcon = viewIcon;
        this.variable = variable;
        this.setUp();
    }

    void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.updateModel();
    }

    synchronized void destroy() {
        JComponent tree;
        boolean haveModels;
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        boolean bl = haveModels = this.treeModels != null && this.treeModels.size() > 0 || this.nodeModels != null && this.nodeModels.size() > 0 || this.tableModels != null && this.tableModels.size() > 0;
        if (haveModels && this.view.getComponentCount() > 0 && !((tree = (JComponent)this.view.getComponent(0)) instanceof JTabbedPane)) {
            Models.setModelsToView((JComponent)tree, null);
        }
        this.models.clear();
        this.treeModels = null;
        this.treeModelFilters = null;
        this.treeExpansionModels = null;
        this.treeExpansionModelFilters = null;
        this.nodeModels = null;
        this.nodeModelFilters = null;
        this.tableModels = null;
        this.tableModelFilters = null;
        this.nodeActionsProviders = null;
        this.nodeActionsProviderFilters = null;
        this.columnModels = null;
        this.mm = null;
        this.asynchModelFilters = null;
        this.sessionProviders = null;
        this.currentSession = null;
        this.providerToDisplay = null;
        this.buttonsPane.removeAll();
        this.buttons = null;
        this.view.removeAll();
        for (ViewModelListener l : this.subListeners) {
            l.destroy();
        }
        this.subListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getNewValue() != null) {
            ViewModelListener viewModelListener = this;
            synchronized (viewModelListener) {
                this.providerToDisplay = null;
            }
        }
        this.updateModel();
    }

    private synchronized void updateModel() {
        String viewPath;
        DebuggerManager cp;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        DebuggerEngine e = dm.getCurrentEngine();
        this.sessionProviders = e == null ? dm.lookup(this.viewType, SessionProvider.class) : DebuggerManager.join((ContextProvider)e, (ContextProvider)dm).lookup(this.viewType, SessionProvider.class);
        if (!this.sessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (e == null && this.providerToDisplay == null && this.sessionProviders.size() > 0) {
            this.providerToDisplay = this.sessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            e = null;
            cp = dm;
            viewPath = this.viewType + "/" + this.providerToDisplay.getTypeID();
        } else {
            cp = e != null ? DebuggerManager.join((ContextProvider)e, (ContextProvider)dm) : dm;
            viewPath = this.viewType;
        }
        this.currentSession = dm.getCurrentSession();
        this.treeModels = cp.lookup(viewPath, TreeModel.class);
        this.treeModelFilters = cp.lookup(viewPath, TreeModelFilter.class);
        this.treeExpansionModels = cp.lookup(viewPath, TreeExpansionModel.class);
        this.treeExpansionModelFilters = cp.lookup(this.viewType, TreeExpansionModelFilter.class);
        this.nodeModels = cp.lookup(viewPath, NodeModel.class);
        this.nodeModelFilters = cp.lookup(viewPath, NodeModelFilter.class);
        this.tableModels = cp.lookup(viewPath, TableModel.class);
        this.tableModelFilters = cp.lookup(viewPath, TableModelFilter.class);
        this.nodeActionsProviders = cp.lookup(viewPath, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = cp.lookup(viewPath, NodeActionsProviderFilter.class);
        this.columnModels = cp.lookup(viewPath, ColumnModel.class);
        this.mm = cp.lookup(viewPath, Model.class);
        this.asynchModelFilters = cp.lookup(viewPath, AsynchronousModelFilter.class);
        String searchPath = viewPath;
        while (this.asynchModelFilters.isEmpty() && searchPath != null) {
            int i = searchPath.lastIndexOf(47);
            searchPath = i > 0 ? searchPath.substring(0, i) : null;
            this.asynchModelFilters = cp.lookup(searchPath, AsynchronousModelFilter.class);
        }
        this.hyperModels = null;
        List bList = cp.lookup(viewPath, AbstractButton.class);
        this.buttons = new ArrayList<AbstractButton>();
        ArrayList<AbstractButton> tempList = new ArrayList<AbstractButton>();
        for (AbstractButton b : bList) {
            if (b instanceof JToggleButton) {
                this.buttons.add(b);
                continue;
            }
            tempList.add(b);
        }
        this.buttons.addAll(tempList);
        this.tabbedPane = (JTabbedPane)cp.lookupFirst(viewPath, JTabbedPane.class);
        this.refreshModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        boolean haveModels;
        JPanel buttonsSubPane;
        this.models.clear();
        if (this.treeModels == null) {
            return;
        }
        List list = this.treeModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeModels));
        }
        list = this.treeModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeModelFilters));
        }
        list = this.treeExpansionModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeExpansionModels));
        }
        list = this.nodeModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeModels));
        }
        list = this.nodeModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeModelFilters));
        }
        list = this.tableModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableModels));
        }
        list = this.tableModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.tableModelFilters));
        }
        list = this.nodeActionsProviders;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeActionsProviders));
        }
        list = this.nodeActionsProviderFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
        }
        list = this.columnModels;
        synchronized (list) {
            this.models.add(new ArrayList(this.columnModels));
        }
        list = this.mm;
        synchronized (list) {
            this.models.add(new ArrayList(this.mm));
        }
        list = this.treeExpansionModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.treeExpansionModelFilters));
        }
        list = this.asynchModelFilters;
        synchronized (list) {
            this.models.add(new ArrayList(this.asynchModelFilters));
        }
        List<AbstractButton> list2 = this.buttons;
        synchronized (list2) {
            this.buttonsPane.removeAll();
            if (this.buttons.size() == 0) {
                this.buttonsPane.setVisible(false);
                buttonsSubPane = null;
            } else {
                this.buttonsPane.setVisible(true);
                int i = 0;
                if (this.tabbedPane != null) {
                    buttonsSubPane = new JPanel();
                    buttonsSubPane.setLayout(new GridBagLayout());
                    GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 1.0, 11, 3, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)buttonsSubPane, c);
                    ++i;
                } else {
                    buttonsSubPane = null;
                    for (AbstractButton b : this.buttons) {
                        GridBagConstraints c = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                        this.buttonsPane.add((Component)b, c);
                        ++i;
                    }
                }
            }
        }
        boolean bl = haveModels = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0 || this.hyperModels != null;
        final Models.CompoundModel newModel = this.hyperModels != null ? Models.createCompoundModel((List)this.hyperModels, (String)this.propertiesHelpID) : (haveModels ? Models.createCompoundModel((List)this.models, (String)this.propertiesHelpID) : null);
        if (newModel != null) {
            newModel.nodeExpanded((Object)this.variable);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ViewModelListener.this.view.getComponentCount() > 0) {
                    if (ViewModelListener.this.tabbedPane == null && ViewModelListener.this.view.getComponent(0) instanceof JTabbedPane) {
                        ViewModelListener.this.view.removeAll();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        ViewModelListener.this.view.removeAll();
                    }
                }
                if (ViewModelListener.this.view.getComponentCount() == 0) {
                    if (haveModels) {
                        ViewModelListener.this.view.add(Models.createView((Models.CompoundModel)newModel));
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        int n = ViewModelListener.this.tabbedPane.getTabCount();
                        for (int i = 0; i < n; ++i) {
                            Component c = ViewModelListener.this.tabbedPane.getComponentAt(i);
                            if (c instanceof JPanel) {
                                c = (Component)((JPanel)c).getClientProperty(JLabel.class.getName());
                            }
                            if (!(c instanceof JLabel)) continue;
                            String id = ((JLabel)c).getText();
                            if (ViewModelListener.this.providerToDisplay != null) {
                                id = ViewModelListener.this.providerToDisplay.getTypeID() + "/" + id;
                            }
                            JPanel contentComponent = new JPanel(new BorderLayout());
                            ViewModelListener.this.subListeners.add(new ViewModelListener(ViewModelListener.this.viewType + "/" + id, contentComponent, buttonsSubPane, ViewModelListener.this.propertiesHelpID, ViewModelListener.this.viewIcon, ViewModelListener.this.variable));
                            ViewModelListener.this.tabbedPane.setComponentAt(i, contentComponent);
                            contentComponent.putClientProperty(JLabel.class.getName(), c);
                        }
                        ViewModelListener.this.view.add(ViewModelListener.this.tabbedPane);
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    }
                } else if (ViewModelListener.this.tabbedPane == null) {
                    if (!haveModels) {
                        ViewModelListener.this.view.removeAll();
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else {
                        JComponent tree = (JComponent)ViewModelListener.this.view.getComponent(0);
                        Models.setModelsToView((JComponent)tree, (Models.CompoundModel)newModel);
                    }
                }
            }
        });
    }
}

