/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;

public class ValidatorPresenter
extends DynamicPresenter {
    private boolean mustHaveDescriptor;
    private boolean referencesFromMainTreeOnly;
    private boolean allChildrenMustBeInProperties;
    private ArrayList<String> propertiesUsingChildrenOnly = new ArrayList();
    private List<String> propertiesUsingChildrenOnlyUm = Collections.unmodifiableList(this.propertiesUsingChildrenOnly);
    private ArrayList<TypeID> validChildrenTypeIDs = new ArrayList();
    private List<TypeID> validChildrenTypeIDsUm = Collections.unmodifiableList(this.validChildrenTypeIDs);

    public final boolean isMustHaveDescriptor() {
        return this.mustHaveDescriptor;
    }

    public final ValidatorPresenter setMustHaveDescriptor(boolean mustHaveDescriptor) {
        this.mustHaveDescriptor = mustHaveDescriptor;
        return this;
    }

    public final boolean hasReferencesFromMainTreeOnly() {
        return this.referencesFromMainTreeOnly;
    }

    public final ValidatorPresenter setReferencesFromMainTreeOnly(boolean referencesFromMainTreeOnly) {
        this.referencesFromMainTreeOnly = referencesFromMainTreeOnly;
        return this;
    }

    public final boolean hasAllChildrenMustBeInProperties() {
        return this.allChildrenMustBeInProperties;
    }

    public final ValidatorPresenter setAllChildrenMustBeInProperties(boolean allChildrenMustBeInProperties) {
        this.allChildrenMustBeInProperties = allChildrenMustBeInProperties;
        return this;
    }

    public final List<String> getPropertiesUsingChildrenOnly() {
        return this.propertiesUsingChildrenOnlyUm;
    }

    public final ValidatorPresenter addPropertiesUsingChildrenOnly(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.propertiesUsingChildrenOnly.add(propertyName);
        }
        return this;
    }

    public final List<TypeID> getValidChildrenTypeIDs() {
        return this.validChildrenTypeIDsUm;
    }

    public final ValidatorPresenter addValidChildrenTypeID(TypeID ... typeIDs) {
        for (TypeID typeID : typeIDs) {
            this.validChildrenTypeIDs.add(typeID);
        }
        return this;
    }

    public final void checkValidity() {
        assert (this.checkValidatyAssert());
        try {
            this.checkCustomValidity();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            Debug.error(th);
        }
    }

    private boolean checkValidatyAssert() {
        Collection<DesignComponent> children;
        DesignComponent component = this.getComponent();
        assert (component != null);
        if (this.mustHaveDescriptor) assert (component.getComponentDescriptor() != null);
        if (this.validChildrenTypeIDs.size() > 0) {
            DescriptorRegistry registry = component.getDocument().getDescriptorRegistry();
            children = component.getComponents();
            block0: for (DesignComponent child : children) {
                for (TypeID typeID : this.validChildrenTypeIDs) {
                    if (!registry.isInHierarchy(typeID, child.getType())) continue;
                    continue block0;
                }
                assert (false);
            }
        }
        HashSet<DesignComponent> references = new HashSet<DesignComponent>();
        if (this.hasReferencesFromMainTreeOnly() || this.hasAllChildrenMustBeInProperties()) {
            ComponentDescriptor descriptor = component.getComponentDescriptor();
            Collection<PropertyDescriptor> propertyDescriptors = descriptor.getPropertyDescriptors();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                PropertyValue value = component.readProperty(propertyDescriptor.getName());
                Debug.collectAllComponentReferences(value, references);
            }
        }
        if (this.hasReferencesFromMainTreeOnly()) {
            DesignComponent rootComponent = component.getDocument().getRootComponent();
            for (DesignComponent reference : references) {
                DesignComponent parentComponent;
                while ((parentComponent = reference.getParentComponent()) != null) {
                    reference = parentComponent;
                }
                assert (reference == rootComponent);
            }
        }
        if (this.hasAllChildrenMustBeInProperties()) {
            children = component.getComponents();
            for (DesignComponent child : children) {
                assert (references.contains(child));
            }
        }
        if (!this.propertiesUsingChildrenOnly.isEmpty()) {
            references = new HashSet();
            for (String propertyName : this.propertiesUsingChildrenOnly) {
                Debug.collectAllComponentReferences(component.readProperty(propertyName), references);
            }
            children = new HashSet<DesignComponent>(component.getComponents());
            for (DesignComponent reference : references) {
                assert (((HashSet)children).contains(reference));
            }
        }
        return true;
    }

    @Override
    public final void notifyAttached(DesignComponent component) {
    }

    @Override
    public final void notifyDetached(DesignComponent component) {
    }

    @Override
    public final DesignEventFilter getEventFilter() {
        return null;
    }

    @Override
    public void designChanged(DesignEvent event) {
    }

    @Override
    public void presenterChanged(PresenterEvent event) {
    }

    protected void checkCustomValidity() {
    }
}

