/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.modules.mobility.end2end.ui.wizard.ClientOptionsPanelGUI;
import org.netbeans.modules.mobility.end2end.ui.wizard.GenericServiceIterator;
import org.netbeans.modules.mobility.end2end.ui.wizard.WebApplicationPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClientOptionsPanel
implements WizardDescriptor.Panel,
ChangeListener {
    TemplateWizard templateWizard;
    private ClientOptionsPanelGUI gui;
    private final ArrayList<ChangeListener> listeners = new ArrayList();
    public static final HelpCtx HELP_CTX = new HelpCtx("me.wcb_clientoptions");
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String WPEM = "WizardPanel_errorMessage";

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new ClientOptionsPanelGUI();
            this.gui.setName(NbBundle.getMessage(WebApplicationPanel.class, (String)"TITLE_clientOptionsStep"));
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public void readSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        Configuration configuration = (Configuration)this.templateWizard.getProperty("e2e-configuration");
        String string = null;
        ClientConfiguration clientConfiguration = configuration.getClientConfiguration();
        if (clientConfiguration == null) {
            ServerConfiguration serverConfiguration = configuration.getServerConfigutation();
            ClassDescriptor classDescriptor = serverConfiguration.getClassDescriptor();
            String string2 = classDescriptor.getLeafClassName();
            int n = string2.indexOf("Servlet");
            if (n < 0) {
                n = 0;
            }
            string = string2.substring(0, n) + "Client";
        } else {
            string = Templates.getTargetName((WizardDescriptor)this.templateWizard);
        }
        if (this.getComponent() != null) {
            this.gui.setValues(Templates.getProject((WizardDescriptor)this.templateWizard), string, Templates.getTargetFolder((WizardDescriptor)this.templateWizard));
        }
    }

    public void storeSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        Configuration configuration = (Configuration)this.templateWizard.getProperty("e2e-configuration");
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProjectName(this.gui.getProjectName());
        String string = this.gui.getPackageFileName();
        string = !"".equals(string) ? string + "." + this.gui.getTargetName() : this.gui.getTargetName();
        FileObject fileObject = this.gui.getRootFolder();
        string = string.replace('/', '.');
        ClassDescriptor classDescriptor = new ClassDescriptor(string, this.gui.getSourceGroup().getName());
        Templates.setTargetName((WizardDescriptor)this.templateWizard, (String)this.gui.getTargetName());
        this.templateWizard.putProperty(GenericServiceIterator.PROP_CLIENT_ROOT, (Object)fileObject);
        this.templateWizard.putProperty(GenericServiceIterator.PROP_DATABINDING, (Object)new Boolean(this.gui.isDataBinded()));
        clientConfiguration.setClassDescriptor(classDescriptor);
        Properties properties = new Properties();
        if (this.gui.isGenerateStubs()) {
            properties.put("createStubs", TRUE);
        } else {
            properties.put("createStubs", FALSE);
        }
        if (this.gui.isFloatingPointUsed()) {
            properties.put("floatingPoint", TRUE);
        } else {
            properties.put("floatingPoint", FALSE);
        }
        if (this.gui.isDataBinded()) {
            properties.put("DataBinding", TRUE);
        } else {
            properties.put("DataBinding", FALSE);
        }
        clientConfiguration.setProperties(properties);
        configuration.setClientConfiguration(clientConfiguration);
    }

    public boolean isValid() {
        if (this.gui == null) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_NoGUI"));
            return false;
        }
        if (this.gui.getCreatedFile() != null && new File(this.gui.getCreatedFile()).exists()) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_AlreadyExists", (Object)(this.gui.getTargetName() + ".java")));
            return false;
        }
        if ("".equals(this.gui.getTargetName())) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_NoClassName"));
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.gui.getTargetName())) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_InvalidClassName"));
            return false;
        }
        if (!ClientOptionsPanel.isValidJavaFolderName(this.gui.getPackageFileName())) {
            this.templateWizard.putProperty(WPEM, (Object)NbBundle.getMessage(ClientOptionsPanel.class, (String)"ERR_File_InvalidPackageName"));
            return false;
        }
        this.templateWizard.putProperty(WPEM, (Object)" ");
        return true;
    }

    private static boolean isValidJavaFolderName(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.templateWizard != null) {
            this.templateWizard.setValid(this.isValid());
            this.fireChange();
        }
    }
}

