/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.classdata;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;

public class MethodData {
    private final String name;
    private final String parentClassName;
    private final ClassData returnType;
    private final List<MethodParameter> parameters;
    private int requestID;
    private boolean isValidReturnType;
    private List<MethodParameter> myInvalidParameters;
    private String myFQNReturnType;

    public MethodData(String parentClassName, String name, ClassData returnType, List<MethodParameter> parameters) {
        this.name = name;
        this.parentClassName = parentClassName;
        this.returnType = returnType;
        this.parameters = parameters;
        this.isValidReturnType = true;
    }

    public MethodData(String parentClassName, String name, String returnType, List<MethodParameter> parameters, boolean validReturnType, List<MethodParameter> invalidParameters) {
        this(parentClassName, name, null, parameters);
        this.isValidReturnType = validReturnType;
        this.myInvalidParameters = invalidParameters;
        this.myFQNReturnType = returnType;
    }

    public String getName() {
        return this.name;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public ClassData getReturnType() {
        return this.returnType;
    }

    public boolean isValidReturnType() {
        return this.isValidReturnType;
    }

    public List<MethodParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public List<MethodParameter> getInvalidParameters() {
        if (this.myInvalidParameters == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.myInvalidParameters);
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public String getReturnTypeAsText() {
        if (this.myFQNReturnType == null) {
            return this.getReturnType() == null ? null : this.getReturnType().getFullyQualifiedName();
        }
        return this.myFQNReturnType;
    }

    public boolean equalsFQN(MethodData method) {
        if (!method.getParentClassName().equals(this.parentClassName)) {
            return false;
        }
        if (!method.getName().equals(this.name)) {
            return false;
        }
        if (this.returnType == null || method.getReturnType() == null) {
            return this.getReturnTypeAsText().equals(method.getReturnTypeAsText());
        }
        if (!method.getReturnType().equals(this.returnType)) {
            return false;
        }
        if (method.getParameters().size() != this.parameters.size()) {
            return false;
        }
        int i = 0;
        for (MethodParameter parameter : this.parameters) {
            if (!method.getParameters().get(i).equalsFQN(parameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodData)) {
            return false;
        }
        MethodData md = (MethodData)o;
        if (!md.getParentClassName().equals(this.parentClassName)) {
            return false;
        }
        if (!md.getName().equals(this.name)) {
            return false;
        }
        if (!md.getReturnType().equals(this.returnType)) {
            return false;
        }
        if (md.getParameters().size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (md.getParameters().get(i).equals(this.parameters.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.returnType != null) {
            if (this.myFQNReturnType == null) {
                return this.parentClassName.hashCode() + 7 * this.name.hashCode() + 13 * this.returnType.hashCode() + 17 * this.paramsHashCode();
            }
            return this.parentClassName.hashCode() + 7 * this.name.hashCode() + 13 * this.returnType.hashCode() + 17 * this.paramsHashCode() + 31 * this.myFQNReturnType.hashCode();
        }
        return this.parentClassName.hashCode() + 7 * this.name.hashCode() + 13 * this.paramsHashCode();
    }

    private int paramsHashCode() {
        if (this.parameters == null) {
            return 0;
        }
        int result = 0;
        for (MethodParameter param : this.parameters) {
            result = 31 * result + param.hashCode();
        }
        return result;
    }
}

