/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.completion.HtmlCompletionQuery;
import org.netbeans.modules.html.editor.javadoc.HelpManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HtmlCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int dotPos;
        Document doc = component.getDocument();
        boolean openCC = HtmlCompletionProvider.checkOpenCompletion(doc, dotPos = component.getCaret().getDot(), typedText);
        return openCC ? 3 : 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        AsyncCompletionTask task = null;
        if ((queryType & 1 & 9) != 0) {
            task = new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        } else if (queryType == 2) {
            task = new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), component);
        }
        return task;
    }

    private static void checkHideCompletion(final BaseDocument doc, final int caretOffset) {
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(caretOffset == 0 ? 0 : caretOffset - 1);
                if (!tokenSequence.moveNext()) {
                    return;
                }
                Token tokenItem = tokenSequence.token();
                if (tokenItem.id() == HTMLTokenId.TEXT && !((Object)tokenItem.text()).toString().startsWith("<") && !((Object)tokenItem.text()).toString().startsWith("&")) {
                    HtmlCompletionProvider.hideCompletion();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkOpenCompletion(Document document, final int dotPos, String typedText) {
        final BaseDocument doc = (BaseDocument)document;
        switch (typedText.charAt(typedText.length() - 1)) {
            case '/': {
                if (dotPos < 2) break;
                try {
                    String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                    if (txtBeforeSpace.equals("</")) {
                        return true;
                    }
                }
                catch (BadLocationException e) {}
                break;
            }
            case ' ': {
                doc.readLock();
                try {
                    TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence((Document)doc, dotPos);
                    if (ts == null) {
                        boolean bl = false;
                        return bl;
                    }
                    int diff = ts.move(dotPos);
                    if (ts.moveNext() && ts.token().id() == HTMLTokenId.WS && diff == 1 && ts.movePrevious() && (ts.token().id() == HTMLTokenId.TAG_OPEN || ts.token().id() == HTMLTokenId.VALUE || ts.token().id() == HTMLTokenId.VALUE_CSS || ts.token().id() == HTMLTokenId.VALUE_JAVASCRIPT)) {
                        boolean bl = true;
                        return bl;
                    }
                    break;
                }
                finally {
                    doc.readUnlock();
                }
            }
            case '&': 
            case '<': {
                return true;
            }
            case '>': {
                final boolean[] ret = new boolean[1];
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence((Document)doc, dotPos);
                        if (ts == null) {
                            ret[0] = false;
                        } else {
                            ts.move(dotPos - 1);
                            if ((ts.moveNext() || ts.movePrevious()) && ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && !CharSequenceUtilities.equals((CharSequence)"/>", (Object)ts.token().text())) {
                                ret[0] = true;
                            }
                        }
                    }
                });
                return ret[0];
            }
        }
        return false;
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    private static class DocItem
    implements CompletionDocumentation {
        HtmlCompletionItem item;

        public DocItem(HtmlCompletionItem ri) {
            this.item = ri;
        }

        public String getText() {
            return this.item.getHelp();
        }

        public URL getURL() {
            return this.item.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            URL itemUrl = HelpManager.getDefault().getHelpURL(this.item.getHelpId());
            return itemUrl != null ? new LinkDocItem(HelpManager.getDefault().getRelativeURL(itemUrl, link)) : new NoDocItem();
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class NoDocItem
    implements CompletionDocumentation {
        private NoDocItem() {
        }

        public String getText() {
            return NbBundle.getMessage(HtmlCompletionProvider.class, (String)"MSG_No_Doc_For_Target");
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class LinkDocItem
    implements CompletionDocumentation {
        private URL url;

        public LinkDocItem(URL url) {
            this.url = url;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String link) {
            return new LinkDocItem(HelpManager.getDefault().getRelativeURL(this.url, link));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent component) {
            HtmlCompletionProvider.checkHideCompletion((BaseDocument)component.getDocument(), component.getCaretPosition());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                this.doQuery(resultSet, doc, caretOffset);
            }
            finally {
                resultSet.finish();
            }
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    public static class DocQuery
    extends AbstractQuery {
        private CompletionItem item;

        public DocQuery(HtmlCompletionItem item) {
            this.item = item;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            HtmlCompletionItem htmlItem;
            if (this.item == null) {
                try {
                    HtmlCompletionQuery.CompletionResult result = new HtmlCompletionQuery(doc, caretOffset).query();
                    if (result != null && result.getItems().size() > 0) {
                        this.item = result.getItems().iterator().next();
                    }
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((htmlItem = (HtmlCompletionItem)this.item) != null && htmlItem.getHelp() != null) {
                resultSet.setDocumentation((CompletionDocumentation)new DocItem(htmlItem));
            }
        }
    }

    private static class Query
    extends AbstractQuery {
        private int anchor;
        private volatile Collection<? extends CompletionItem> items = Collections.emptyList();
        private JTextComponent component;

        private Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                HtmlCompletionQuery.CompletionResult result = new HtmlCompletionQuery(doc, caretOffset).query();
                if (result != null) {
                    this.items = result.getItems();
                    this.anchor = result.getAnchor();
                } else {
                    this.items = Collections.emptyList();
                    this.anchor = 0;
                }
                resultSet.addAllItems(this.items);
                resultSet.setAnchorOffset(this.anchor);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        protected boolean canFilter(JTextComponent component) {
            try {
                Document doc = component.getDocument();
                int offset = component.getCaretPosition();
                if (offset < this.anchor) {
                    return false;
                }
                String prefix = doc.getText(this.anchor, offset - this.anchor);
                for (CompletionItem completionItem : this.items) {
                    if (!(completionItem instanceof HtmlCompletionItem) || !Query.startsWithIgnoreCase(((HtmlCompletionItem)completionItem).getItemText(), prefix)) continue;
                    return true;
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void filter(CompletionResultSet resultSet) {
            try {
                Document doc = this.component.getDocument();
                int offset = this.component.getCaretPosition();
                String prefix = doc.getText(this.anchor, offset - this.anchor);
                for (CompletionItem completionItem : this.items) {
                    if (!(completionItem instanceof HtmlCompletionItem) || !Query.startsWithIgnoreCase(((HtmlCompletionItem)completionItem).getItemText(), prefix)) continue;
                    resultSet.addItem(completionItem);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                resultSet.setAnchorOffset(this.anchor);
                resultSet.finish();
            }
        }

        private static boolean startsWithIgnoreCase(String text, String prefix) {
            return text.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
        }
    }
}

