/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultPanelTree;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class StatisticsPanel
extends JPanel
implements ItemListener {
    private final ResultPanelTree treePanel;
    private JToggleButton btnFilter;
    private JButton rerunButton;
    private JButton nextFailure;
    private JButton previousFailure;
    private String tooltipShowAll;
    private String tooltipShowFailures;
    private final ResultDisplayHandler displayHandler;
    private static boolean showFailuresOnly = false;

    public StatisticsPanel(ResultDisplayHandler displayHandler) {
        super(new BorderLayout(0, 0));
        this.displayHandler = displayHandler;
        JComponent toolbar = this.createToolbar();
        this.treePanel = new ResultPanelTree(displayHandler);
        this.treePanel.setFiltered(this.btnFilter.isSelected());
        this.add((Component)toolbar, "West");
        this.add((Component)this.treePanel, "Center");
    }

    private JComponent createToolbar() {
        this.createFilterButton();
        this.createRerunButton();
        this.createNextPrevFailureButtons();
        JToolBar toolbar = new JToolBar(1);
        toolbar.setLayout(new BoxLayout(toolbar, 1));
        toolbar.add(this.rerunButton);
        toolbar.add(this.btnFilter);
        toolbar.add(this.previousFailure);
        toolbar.add(this.nextFailure);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.setFocusable(false);
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        return toolbar;
    }

    private void createRerunButton() {
        this.rerunButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/rerun.png", (boolean)true));
        this.rerunButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_RerunButton"));
        final RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler != null) {
            this.rerunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    rerunHandler.rerun();
                }
            });
            rerunHandler.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StatisticsPanel.this.rerunButton.setEnabled(rerunHandler.enabled());
                }
            });
            this.rerunButton.setEnabled(rerunHandler.enabled());
        }
        this.rerunButton.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MultiviewPanel.rerunButton.tooltip"));
    }

    private void createFilterButton() {
        this.btnFilter = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/filter.png", (boolean)true));
        this.btnFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_FilterButton"));
        this.btnFilter.setSelected(showFailuresOnly);
        this.btnFilter.addItemListener(this);
        this.updateFilterButtonLabel();
    }

    private void updateFilterButtonLabel() {
        if (this.tooltipShowAll == null) {
            this.tooltipShowAll = NbBundle.getMessage(this.getClass(), (String)"MultiviewPanel.btnFilter.showAll.tooltip");
            this.tooltipShowFailures = NbBundle.getMessage(this.getClass(), (String)"MultiviewPanel.btnFilter.showFailures.tooltip");
        }
        this.btnFilter.setToolTipText(this.btnFilter.isSelected() ? this.tooltipShowAll : this.tooltipShowFailures);
    }

    private void createNextPrevFailureButtons() {
        this.nextFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/nextmatch.png", (boolean)true));
        this.nextFailure.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MSG_NextFailure"));
        this.nextFailure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsPanel.this.selectNextFailure();
            }
        });
        this.previousFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/prevmatch.png", (boolean)true));
        this.previousFailure.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MSG_PreviousFailure"));
        this.previousFailure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsPanel.this.selectPreviousFailure();
            }
        });
    }

    void selectPreviousFailure() {
        this.treePanel.selectPreviousFailure();
    }

    void selectNextFailure() {
        this.treePanel.selectNextFailure();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        showFailuresOnly = this.btnFilter.isSelected();
        this.treePanel.setFiltered(this.btnFilter.isSelected());
        this.updateFilterButtonLabel();
    }

    void displayReport(Report report) {
        this.treePanel.displayReport(report);
        this.btnFilter.setEnabled(this.treePanel.getSuccessDisplayedLevel() != 0);
    }

    void displayReports(List<Report> reports) {
        if (reports.isEmpty()) {
            return;
        }
        this.treePanel.displayReports(reports);
        this.btnFilter.setEnabled(this.treePanel.getSuccessDisplayedLevel() != 0);
    }

    void displaySuiteRunning(String suiteName) {
        this.treePanel.displaySuiteRunning(suiteName);
    }

    void displayMsg(String msg) {
        this.treePanel.displayMsg(msg);
    }
}

