/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.util.List;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumn;

public class ThreadSummaryColumnImpl
implements ThreadSummaryColumn {
    private List<ThreadSummaryData.StateDuration> state;

    ThreadSummaryColumnImpl(List<ThreadSummaryData.StateDuration> state) {
        this.state = state;
    }

    @Override
    public List<ThreadSummaryData.StateDuration> getSummary() {
        return this.state;
    }

    public int getRunning() {
        int all = 0;
        int running = 0;
        for (ThreadSummaryData.StateDuration duration : this.state) {
            all += ThreadStateColumnImpl.timeInervalToMilliSeconds(duration.getDuration());
            switch (duration.getState()) {
                case Running: 
                case RunningOther: 
                case RunningSystemCall: 
                case RunningUser: {
                    running += ThreadStateColumnImpl.timeInervalToMilliSeconds(duration.getDuration());
                }
            }
        }
        if (all != 0) {
            return 100 * running / all;
        }
        return 0;
    }
}

