/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.QueryAccessorImpl;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.Node;

public abstract class Query
implements Comparable<Query> {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String EVENT_QUERY_ISSUES_CHANGED = "bugtracking.query.issues_changed";
    public static final String EVENT_QUERY_SAVED = "bugtracking.query.saved";
    public static final String EVENT_QUERY_REMOVED = "bugtracking.query.removed";
    private List<QueryNotifyListener> notifyListeners;
    protected boolean saved;
    private long lastRefresh = -1L;
    private Node[] selection;

    public abstract String getDisplayName();

    public abstract String getTooltip();

    public abstract BugtrackingController getController();

    public abstract Repository getRepository();

    public static void openNew(Repository repository) {
        QueryAction.openQuery(null, repository);
    }

    protected void setSaved(boolean saved) {
        this.saved = saved;
        if (saved) {
            this.selection = null;
        }
        this.fireQuerySaved();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public abstract Issue[] getIssues(int var1);

    public Issue[] getIssues() {
        return this.getIssues(-1);
    }

    public abstract boolean contains(Issue var1);

    public Issue[] getIssues(String criteria) {
        return BugtrackingUtil.getByIdOrSummary(this.getIssues(), criteria);
    }

    @Override
    public int compareTo(Query q) {
        if (q == null) {
            return 1;
        }
        return this.getDisplayName().compareTo(q.getDisplayName());
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public abstract int getIssueStatus(Issue var1);

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    protected void fireQuerySaved() {
        this.support.firePropertyChange(EVENT_QUERY_SAVED, null, null);
    }

    protected void fireQueryRemoved() {
        this.support.firePropertyChange(EVENT_QUERY_REMOVED, null, null);
    }

    protected void fireQueryIssuesChanged() {
        this.support.firePropertyChange(EVENT_QUERY_ISSUES_CHANGED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotifyListener(QueryNotifyListener l) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotifyListener(QueryNotifyListener l) {
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            list.remove(l);
        }
    }

    protected void fireNotifyData(Issue issue) {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.notifyData(issue);
        }
    }

    protected void fireStarted() {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.started();
        }
    }

    protected void fireFinished() {
        QueryNotifyListener[] listeners;
        for (QueryNotifyListener l : listeners = this.getListeners()) {
            l.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(Runnable r) {
        this.fireStarted();
        try {
            r.run();
        }
        finally {
            this.fireFinished();
            this.fireQueryIssuesChanged();
            this.setLastRefresh(System.currentTimeMillis());
        }
    }

    protected void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryNotifyListener[] getListeners() {
        QueryNotifyListener[] listeners;
        List<QueryNotifyListener> list;
        List<QueryNotifyListener> list2 = list = this.getNotifyListeners();
        synchronized (list2) {
            listeners = list.toArray(new QueryNotifyListener[list.size()]);
        }
        return listeners;
    }

    private List<QueryNotifyListener> getNotifyListeners() {
        if (this.notifyListeners == null) {
            this.notifyListeners = new ArrayList<QueryNotifyListener>();
        }
        return this.notifyListeners;
    }

    void setSelection(Node[] nodes) {
        this.selection = nodes;
    }

    protected Node[] getSelection() {
        return this.selection;
    }

    static {
        QueryAccessorImpl.create();
    }
}

