/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.source.CacheClassPath;
import org.netbeans.modules.gsfret.source.usages.ClasspathInfoAccessor;
import org.netbeans.napi.gsfret.source.ClassIndex;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final ClassPath srcClassPath;
    private final ClassPath bootClassPath;
    private final ClassPath compileClassPath;
    private final ClassPath cachedBootClassPath;
    private final ClassPath cachedCompileClassPath;
    private ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean backgroundCompilation;
    private final boolean ignoreExcludes;
    private final Object filter;
    private EventListenerList listenerList = null;
    private List<ClassIndex> usagesQuery;

    private ClasspathInfo(ClassPath bootCp, ClassPath compileCp, ClassPath srcCp, Object filter, boolean backgroundCompilation, boolean ignoreExcludes) {
        assert (bootCp != null && compileCp != null);
        this.cpListener = new ClassPathListener();
        this.bootClassPath = bootCp;
        this.compileClassPath = compileCp;
        this.cachedBootClassPath = CacheClassPath.forBootPath(this.bootClassPath);
        this.cachedCompileClassPath = CacheClassPath.forClassPath(this.compileClassPath);
        this.cachedBootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedBootClassPath));
        this.cachedCompileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedCompileClassPath));
        if (srcCp != null) {
            this.srcClassPath = srcCp;
            this.outputClassPath = CacheClassPath.forSourcePath(this.srcClassPath);
            this.srcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.srcClassPath));
        } else {
            this.srcClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
            this.outputClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        this.backgroundCompilation = backgroundCompilation;
        this.ignoreExcludes = ignoreExcludes;
        this.filter = filter;
    }

    public String toString() {
        return "ClasspathInfo boot:[" + this.cachedBootClassPath + "],compile:[" + this.cachedCompileClassPath + "],src:[" + this.srcClassPath + "]";
    }

    public static ClasspathInfo create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return null;
        }
        return ClasspathInfo.create(fo);
    }

    private static ClasspathInfo create(FileObject fo, Object filter, boolean backgroundCompilation, boolean ignoreExcludes) {
        ClassPath srcPath;
        ClassPath compilePath;
        ClassPath bootPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        if (bootPath == null) {
            bootPath = EMPTY_PATH;
        }
        if ((compilePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")) == null) {
            compilePath = EMPTY_PATH;
        }
        if ((srcPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) == null) {
            srcPath = EMPTY_PATH;
        }
        return ClasspathInfo.create(bootPath, compilePath, srcPath, filter, backgroundCompilation, ignoreExcludes);
    }

    public static ClasspathInfo create(FileObject fo) {
        return ClasspathInfo.create(fo, null, false, false);
    }

    private static ClasspathInfo create(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath, Object filter, boolean backgroundCompilation, boolean ignoreExcludes) {
        return new ClasspathInfo(bootPath, classPath, sourcePath, filter, backgroundCompilation, ignoreExcludes);
    }

    public static ClasspathInfo create(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath) {
        return new ClasspathInfo(bootPath, classPath, sourcePath, null, false, false);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ClassPath getClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    ClassPath getCachedClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.cachedBootClassPath;
            }
            case COMPILE: {
                return this.cachedCompileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    public synchronized ClassIndex getClassIndex(String mimeType) {
        ClassIndex ci;
        if (this.usagesQuery == null) {
            this.usagesQuery = new ArrayList<ClassIndex>(8);
        } else {
            for (int i = 0; i < this.usagesQuery.size(); ++i) {
                ci = this.usagesQuery.get(i);
                if (!ci.getLanguage().getMimeType().equals(mimeType)) continue;
                return ci;
            }
        }
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
        assert (language != null) : mimeType;
        ci = new ClassIndex(language, this.bootClassPath, this.compileClassPath, this.srcClassPath);
        this.usagesQuery.add(ci);
        return ci;
    }

    private void fireChangeListenerStateChanged() {
        ChangeEvent e = null;
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    static {
        ClasspathInfoAccessor.setInstance(new ClasspathInfoAccessorImpl());
        try {
            Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        @Override
        public ClassPath getCachedClassPath(ClasspathInfo cpInfo, PathKind kind) {
            return cpInfo.getCachedClassPath(kind);
        }

        @Override
        public ClasspathInfo create(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath, Object filter, boolean backgroundCompilation, boolean ignoreExcludes) {
            return ClasspathInfo.create(bootPath, classPath, sourcePath, filter, backgroundCompilation, ignoreExcludes);
        }

        @Override
        public ClasspathInfo create(FileObject fo, Object filter, boolean backgroundCompilation, boolean ignoreExcludes) {
            return ClasspathInfo.create(fo, filter, backgroundCompilation, ignoreExcludes);
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("roots".equals(event.getPropertyName())) {
                ClassPathListener classPathListener = this;
                synchronized (classPathListener) {
                }
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE,
        OUTPUT;

    }
}

