/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.gsf.CssAstElement;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Exceptions;

public class CssStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult info) {
        SimpleNode root = ((CssParserResult)info).root();
        final Snapshot snapshot = info.getSnapshot();
        if (root == null) {
            return Collections.emptyList();
        }
        final ArrayList items = new ArrayList();
        NodeVisitor rulesSearch = new NodeVisitor(){

            @Override
            public void visit(SimpleNode node) {
                if (node.kind() == 20) {
                    SimpleNode ruleNode = (SimpleNode)node.jjtGetParent();
                    assert (ruleNode.kind() == 19);
                    int so = snapshot.getOriginalOffset(ruleNode.startOffset());
                    int eo = snapshot.getOriginalOffset(ruleNode.endOffset());
                    if (eo != so) {
                        StringBuffer selectorsListText = new StringBuffer();
                        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                            SimpleNode n = (SimpleNode)node.jjtGetChild(i);
                            if (n.kind() != 21) continue;
                            StringBuffer content = new StringBuffer();
                            for (int j = 0; j < n.jjtGetNumChildren(); ++j) {
                                SimpleNode n2 = (SimpleNode)n.jjtGetChild(j);
                                if (n2.kind() != 22 && n2.kind() != 16 || n2.image().trim().length() <= 0) continue;
                                try {
                                    CharSequence nodeText = snapshot.getSource().createSnapshot().getText().subSequence(snapshot.getOriginalOffset(n2.startOffset()), snapshot.getOriginalOffset(n2.endOffset()));
                                    content.append(nodeText);
                                    content.append(' ');
                                    continue;
                                }
                                catch (StringIndexOutOfBoundsException e) {
                                    // empty catch block
                                }
                            }
                            if (content.length() <= 0) continue;
                            selectorsListText.append(content.substring(0, content.length() - 1));
                            selectorsListText.append(", ");
                        }
                        if (selectorsListText.length() > 2) {
                            if (selectorsListText.charAt(selectorsListText.length() - 2) == ',') {
                                selectorsListText.deleteCharAt(selectorsListText.length() - 2);
                            }
                            items.add(new CssRuleStructureItem(selectorsListText.toString(), CssAstElement.createElement(ruleNode), snapshot));
                        }
                    }
                }
            }
        };
        root.visitChildren(rulesSearch);
        return items;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        final BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return Collections.emptyMap();
        }
        SimpleNode root = ((CssParserResult)info).root();
        final Snapshot snapshot = info.getSnapshot();
        if (root == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        final ArrayList foldRange = new ArrayList();
        NodeVisitor foldsSearch = new NodeVisitor(){

            @Override
            public void visit(SimpleNode node) {
                if (node.kind() == 19) {
                    int so = snapshot.getOriginalOffset(node.startOffset());
                    int eo = snapshot.getOriginalOffset(node.endOffset());
                    for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                        SimpleNode n = (SimpleNode)node.jjtGetChild(i);
                        if (n.kind() != 20) continue;
                        so = snapshot.getOriginalOffset(n.endOffset());
                        break;
                    }
                    try {
                        if (so >= 0 && eo >= 0 && eo < doc.getLength() && Utilities.getLineOffset((BaseDocument)doc, (int)so) < Utilities.getLineOffset((BaseDocument)doc, (int)eo)) {
                            foldRange.add(new OffsetRange(so, eo));
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        };
        root.visitChildren(foldsSearch);
        folds.put("codeblocks", foldRange);
        return folds;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, false);
    }

    private static class CssRuleStructureItem
    implements StructureItem {
        private String name;
        private CssAstElement element;
        private int from;
        private int to;

        private static String escape(String s) {
            s = s.replace("<", "&lt;");
            s = s.replace(">", "&gt;");
            return s;
        }

        private CssRuleStructureItem(String name, CssAstElement element, Snapshot source) {
            this.name = name;
            this.element = element;
            this.from = source.getOriginalOffset(element.node().startOffset());
            this.to = source.getOriginalOffset(element.node().endOffset());
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            return CssRuleStructureItem.escape(this.getName());
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.from;
        }

        public long getEndPosition() {
            return this.to;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

