/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.AccidentalAssignmentCustomizer;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.openide.util.NbBundle;

public class AccidentalAssignmentRule
extends PHPRule
implements PHPRuleWithPreferences {
    private static final String INCL_WHILE_PREFS_KEY = "php.verification.accidental.assignment.include.while";
    private static final String TOP_LEVEL_STMT_ONLY = "php.verification.accidental.assignment.top.lvl.stmt.only";
    private Preferences prefs = null;
    private boolean inclWhile = false;
    private boolean topLvlStmtsOnly = true;

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "accidental.assignment";
    }

    public String getDescription() {
        return NbBundle.getMessage(AccidentalAssignmentRule.class, (String)"AccidentalAssignmentDesc");
    }

    @Override
    public void visit(Program program) {
        this.inclWhile = AccidentalAssignmentRule.includeAssignementsInWhile(this.prefs);
        this.topLvlStmtsOnly = AccidentalAssignmentRule.topLevelStmtsOnly(this.prefs);
        super.visit(program);
    }

    @Override
    public void visit(IfStatement node) {
        this.check(node.getCondition());
        super.visit(node);
    }

    @Override
    public void visit(DoStatement node) {
        if (this.inclWhile) {
            this.check(node.getCondition());
        }
        super.visit(node);
    }

    @Override
    public void visit(ForStatement node) {
        for (Expression expr : node.getConditions()) {
            this.check(expr);
        }
        super.visit(node);
    }

    @Override
    public void visit(WhileStatement node) {
        if (this.inclWhile) {
            this.check(node.getCondition());
        }
        super.visit(node);
    }

    private void check(Expression expr) {
        if (this.topLvlStmtsOnly) {
            if (expr instanceof Assignment) {
                Assignment assignment = (Assignment)expr;
                this.createWarning(assignment);
            }
        } else {
            expr.accept(new ExpressionFinder());
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AccidentalAssignmentRule.class, (String)"AccidentalAssignmentDispName");
    }

    @Override
    public JComponent getCustomizer(Preferences node) {
        return new AccidentalAssignmentCustomizer(node);
    }

    public static final boolean includeAssignementsInWhile(Preferences prefs) {
        return prefs.getBoolean(INCL_WHILE_PREFS_KEY, false);
    }

    public static final void setIncludeAssignementsInWhile(Preferences prefs, boolean value) {
        prefs.putBoolean(INCL_WHILE_PREFS_KEY, value);
    }

    public static final boolean topLevelStmtsOnly(Preferences prefs) {
        return prefs.getBoolean(TOP_LEVEL_STMT_ONLY, true);
    }

    public static final void setTopLevelStmtsOnly(Preferences prefs, boolean value) {
        prefs.putBoolean(TOP_LEVEL_STMT_ONLY, value);
    }

    @Override
    public void setPreferences(Preferences prefs) {
        this.prefs = prefs;
    }

    private void createWarning(Assignment node) {
        OffsetRange range = new OffsetRange(node.getStartOffset(), node.getEndOffset());
        Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.parserResult.getSnapshot().getSource().getFileObject(), range, null, 500);
        this.addResult(hint);
        super.visit(node);
    }

    private class ExpressionFinder
    extends DefaultVisitor {
        private ExpressionFinder() {
        }

        @Override
        public void visit(Assignment node) {
            AccidentalAssignmentRule.this.createWarning(node);
        }
    }
}

