/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapper;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MarkingEngine {
    private static MarkingEngine instance;
    private final Object markGuard = new Object();
    private final MarkMapper mapper;
    private String[] labels;
    private MarkMapping[] marks;
    private Set observers = new HashSet();

    private MarkingEngine() {
        this.mapper = new MarkMapper();
    }

    public static synchronized MarkingEngine getDefault() {
        if (instance == null) {
            instance = new MarkingEngine();
        }
        return instance;
    }

    public synchronized void configure(MarkMapping[] mappings, Collection observers) {
        this.setMarks(mappings != null ? mappings : Marker.DEFAULT.getMappings());
        this.observers.clear();
        this.observers.addAll(observers);
    }

    public synchronized void deconfigure() {
        this.setMarks(Marker.DEFAULT.getMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getMarkerMethods() {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ClientUtils.SourceCodeSelection[] methods = new ClientUtils.SourceCodeSelection[this.marks.length];
            for (int i = 0; i < this.marks.length; ++i) {
                methods[i] = this.marks[i].markMask;
            }
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNMarks() {
        Object object = this.markGuard;
        synchronized (object) {
            return this.labels != null ? this.labels.length : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mark markMethod(int methodId, ProfilingSessionStatus status) {
        MarkMapper markMapper = this.mapper;
        synchronized (markMapper) {
            return this.mapper.getMark(methodId, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mark mark(int methodId, ProfilingSessionStatus status) {
        ClientUtils.SourceCodeSelection method = null;
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null || status == null) {
                return Mark.DEFAULT;
            }
            status.beginTrans(false);
            try {
                method = new ClientUtils.SourceCodeSelection(status.getInstrMethodClasses()[methodId], status.getInstrMethodNames()[methodId], status.getInstrMethodSignatures()[methodId]);
            }
            finally {
                status.endTrans();
            }
            String methodSig = method.toFlattened();
            for (int i = 0; i < this.marks.length; ++i) {
                if (!methodSig.startsWith(this.marks[i].markSig)) continue;
                return this.marks[i].mark;
            }
            return Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarks(MarkMapping[] marks) {
        boolean stateChange = false;
        Object object = this.markGuard;
        synchronized (object) {
            stateChange = !Arrays.equals(this.marks, marks);
            this.marks = marks;
        }
        if (stateChange) {
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        Iterator iter = this.observers.iterator();
        while (iter.hasNext()) {
            ((StateObserver)iter.next()).stateChanged(this);
        }
    }

    public static interface StateObserver {
        public void stateChanged(MarkingEngine var1);
    }
}

