/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class IconUtils {
    private static final String MSG_WRN_ICON_EMPTY = "MSG_NoIcon";
    private static final String MSG_WRN_ICON_WRONG_SIZE = "MSG_WrongIconSize";
    private static final String TITLE_ICON_DIALOG = "TITLE_IconDialog";
    private static final String LBL_ICON_INFO = "LBL_IconInfo";
    private static Reference<JFileChooser> iconChooser;

    public static Set<File> getPossibleIcons(String iconPath) {
        String[] resultSuffixes = new String[]{"16", "24", ""};
        HashSet<File> results = new HashSet<File>();
        File icon = new File(iconPath);
        String iconName = icon.getName();
        int idx = iconName.lastIndexOf(46);
        String name = idx != -1 ? iconName.substring(0, idx) : iconName;
        String extension = idx != -1 ? iconName.substring(idx + 1) : null;
        boolean hasSuffix = name.endsWith("24") || name.endsWith("16");
        name = hasSuffix ? name.substring(0, name.length() - 2) : name;
        for (int i = 0; i < resultSuffixes.length; ++i) {
            File f;
            String resultSuffix = resultSuffixes[i];
            String resultName = name + resultSuffix;
            if (extension != null) {
                resultName = resultName + '.' + extension;
            }
            if (!(f = new File(icon.getParentFile(), resultName)).exists()) continue;
            results.add(f);
        }
        return results;
    }

    public static boolean isValidIcon(File icon, int expectedWidth, int expectedHeight) {
        Dimension iconDimension = IconUtils.getIconDimension(icon);
        return (double)expectedWidth == iconDimension.getWidth() && (double)expectedHeight == iconDimension.getHeight();
    }

    public static String getNoIconMessage(int width, int height) {
        return NbBundle.getMessage(IconUtils.class, (String)MSG_WRN_ICON_EMPTY, (Object[])new Object[]{width, height});
    }

    public static String getIconDimensionMessage(File icon, int expectedWidth, int expectedHeight) {
        Dimension real = new Dimension(IconUtils.getIconDimension(icon));
        if (real.height == expectedHeight && real.width == expectedWidth) {
            return "";
        }
        return NbBundle.getMessage(IconUtils.class, (String)MSG_WRN_ICON_WRONG_SIZE, (Object[])new Object[]{real.width, real.height, expectedWidth, expectedHeight});
    }

    public static Dimension getIconDimension(File icon) {
        try {
            ImageIcon imc = new ImageIcon(icon.toURI().toURL());
            return new Dimension(imc.getIconWidth(), imc.getIconHeight());
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return new Dimension(-1, -1);
        }
    }

    public static JFileChooser getIconFileChooser() {
        JFileChooser choose;
        if (iconChooser != null && (choose = iconChooser.get()) != null) {
            return choose;
        }
        IconFileChooser chooser = new IconFileChooser();
        iconChooser = new WeakReference<IconFileChooser>(chooser);
        return chooser;
    }

    public static JFileChooser getIconFileChooser(String oldValue) {
        File fil;
        JFileChooser chooser = IconUtils.getIconFileChooser();
        String iconText = oldValue.trim();
        if (iconText.length() > 0 && (fil = new File(iconText)).exists()) {
            chooser.setSelectedFile(fil);
        }
        return chooser;
    }

    private static final class IconFilter
    extends FileFilter {
        private IconFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith("gif") || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith("png");
        }

        @Override
        public String getDescription() {
            return "*.gif, *.png";
        }
    }

    private static class IconFileChooser
    extends JFileChooser {
        private final JTextField iconInfo = new JTextField();

        private IconFileChooser() {
            JPanel accessoryPanel = IconFileChooser.getAccesoryPanel(this.iconInfo);
            this.setDialogTitle(NbBundle.getMessage(IconUtils.class, (String)IconUtils.TITLE_ICON_DIALOG));
            this.setAccessory(accessoryPanel);
            this.setAcceptAllFileFilterUsed(false);
            this.setFileSelectionMode(0);
            this.setMultiSelectionEnabled(false);
            this.addChoosableFileFilter(new IconFilter());
            this.setFileView(new FileView(){

                @Override
                public Icon getIcon(File f) {
                    ImageIcon icon;
                    if ((f.getName().endsWith(".gif") || f.getName().endsWith(".png")) && (icon = new ImageIcon(f.getAbsolutePath())).getIconWidth() == 16 && icon.getIconHeight() == 16) {
                        return icon;
                    }
                    return null;
                }

                @Override
                public String getName(File f) {
                    File f2 = IconFileChooser.this.getSelectedFile();
                    if (f2 != null && (f2.getName().endsWith(".gif") || f2.getName().endsWith(".png"))) {
                        ImageIcon icon = new ImageIcon(f2.getAbsolutePath());
                        StringBuffer sb = new StringBuffer();
                        sb.append(f2.getName()).append(" [");
                        sb.append(icon.getIconWidth()).append('x').append(icon.getIconHeight());
                        sb.append(']');
                        IconFileChooser.this.setApproveButtonToolTipText(sb.toString());
                        IconFileChooser.this.iconInfo.setText(sb.toString());
                    } else {
                        IconFileChooser.this.iconInfo.setText("");
                    }
                    return super.getName(f);
                }
            });
        }

        private static JPanel getAccesoryPanel(JTextField iconInfo) {
            iconInfo.setColumns(15);
            iconInfo.setEditable(false);
            JPanel accessoryPanel = new JPanel();
            JPanel inner = new JPanel();
            JLabel iconInfoLabel = new JLabel();
            accessoryPanel.setLayout(new FlowLayout(0, 6, 0));
            inner.setLayout(new GridLayout(2, 1, 0, 6));
            iconInfoLabel.setLabelFor(iconInfo);
            Mnemonics.setLocalizedText((JLabel)iconInfoLabel, (String)NbBundle.getMessage(IconUtils.class, (String)IconUtils.LBL_ICON_INFO));
            inner.add(iconInfoLabel);
            inner.add(iconInfo);
            accessoryPanel.add(inner);
            return accessoryPanel;
        }
    }
}

