/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.print;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class FindFileListener
implements OutputListener {
    private static final Logger LOGGER = Logger.getLogger(FindFileListener.class.getName());
    private final String file;
    private final int lineno;
    private final LineConvertors.FileLocator fileLocator;

    public FindFileListener(String file, int lineno, LineConvertors.FileLocator fileLocator) {
        if (lineno < 0) {
            lineno = 0;
        }
        this.file = file;
        this.lineno = lineno;
        this.fileLocator = fileLocator;
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineAction(OutputEvent ev) {
        FileObject fo = this.findFile(this.file);
        if (fo != null) {
            FindFileListener.open(fo, this.lineno);
        }
    }

    private FileObject findFile(String path) {
        FileObject fo;
        if (this.fileLocator != null && (fo = this.fileLocator.find(path)) != null) {
            return fo;
        }
        File file = new File(path);
        if (file.isFile()) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        LOGGER.warning("Cannot resolve file for \"" + path + "\" path.");
        return null;
    }

    public void outputLineCleared(OutputEvent ev) {
    }

    public static boolean open(final FileObject fo, final int lineno) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindFileListener.open(fo, lineno);
                }
            });
            return true;
        }
        try {
            OpenCookie oc;
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && (doc = ec.openDocument()) != null) {
                int line = lineno;
                if (line < 1) {
                    line = 1;
                }
                try {
                    Line.Set lines = lc.getLineSet();
                    Line l = lines.getCurrent(line - 1);
                    if (l != null) {
                        l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        return true;
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                    // empty catch block
                }
            }
            if ((oc = (OpenCookie)od.getCookie(OpenCookie.class)) != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return false;
    }
}

