/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.nodes.JBItemNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    public static final String WAIT_NODE = "wait_node";
    public static final String INFO_NODE = "info_node";
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    public static MBeanServerConnection getRMIServer(Lookup lookup) {
        return Util.getRMIServer((JBDeploymentManager)lookup.lookup(JBDeploymentManager.class));
    }

    public static MBeanServerConnection getRMIServer(JBDeploymentManager jBDeploymentManager) {
        return jBDeploymentManager.getRMIServer();
    }

    public static Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(NbBundle.getMessage(JBItemNode.class, (String)"LBL_WaitNode_DisplayName"));
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/jboss4/resources/wait.gif");
        return abstractNode;
    }

    public static Node createInfoNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(NbBundle.getMessage(JBItemNode.class, (String)"LBL_InfoNode_DisplayName"));
        abstractNode.setShortDescription(NbBundle.getMessage(JBItemNode.class, (String)"LBL_InfoNode_ToolTip"));
        abstractNode.setIconBaseWithExtension("org/netbeans/core/resources/exception.gif");
        return abstractNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemoteManagementSupported(Lookup lookup) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            MBeanServerConnection mBeanServerConnection = Util.getRMIServer(lookup);
            Thread.currentThread().setContextClassLoader(mBeanServerConnection.getClass().getClassLoader());
            ObjectName objectName = new ObjectName("jboss.management.local:*");
            Set set = (Set)mBeanServerConnection.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke((Object)mBeanServerConnection, objectName, null);
            if (set.size() == 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (SecurityException securityException) {
            Logger.getLogger("global").log(Level.INFO, null, securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger("global").log(Level.INFO, null, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger("global").log(Level.INFO, null, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger("global").log(Level.INFO, null, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger("global").log(Level.INFO, null, noSuchMethodException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Logger.getLogger("global").log(Level.INFO, null, malformedObjectNameException);
        }
        catch (NullPointerException nullPointerException) {
            Logger.getLogger("global").log(Level.INFO, null, nullPointerException);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isObjectDeployed(Object object, ObjectName objectName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
            Set set = (Set)object.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(object, objectName, null);
            if (set.size() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger("global").log(Level.INFO, null, illegalArgumentException);
        }
        catch (SecurityException securityException) {
            Logger.getLogger("global").log(Level.INFO, null, securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger("global").log(Level.INFO, null, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger("global").log(Level.INFO, null, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.getLogger("global").log(Level.INFO, null, noSuchMethodException);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return false;
    }

    public static String getModuleTypeString(ModuleType moduleType) {
        if (moduleType.equals(ModuleType.EAR)) {
            return "J2EEApplication";
        }
        if (moduleType.equals(ModuleType.WAR)) {
            return "WebModule";
        }
        if (moduleType.equals(ModuleType.EJB)) {
            return "EJBModule";
        }
        return "undefined";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMBeanParameter(JBDeploymentManager jBDeploymentManager, String string, String string2) {
        Object object = null;
        MBeanServerConnection mBeanServerConnection = jBDeploymentManager.refreshRMIServer();
        if (mBeanServerConnection == null) {
            return object;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mBeanServerConnection.getClass().getClassLoader());
            object = mBeanServerConnection.getAttribute(new ObjectName(string2), string);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            LOGGER.log(Level.INFO, null, instanceNotFoundException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            LOGGER.log(Level.INFO, null, attributeNotFoundException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            LOGGER.log(Level.INFO, null, malformedObjectNameException);
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.log(Level.FINE, null, nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.FINE, null, illegalArgumentException);
        }
        catch (ReflectionException reflectionException) {
            LOGGER.log(Level.INFO, null, reflectionException);
        }
        catch (MBeanException mBeanException) {
            LOGGER.log(Level.INFO, null, mBeanException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return object;
    }

    public static String getWebContextRoot(String string, String string2) {
        String string3 = Util.getDescriptorContextRoot(string);
        if (string3 == null) {
            string3 = Util.getWarContextRoot(string2);
        }
        if ("/ROOT".equals(string3)) {
            return "/";
        }
        return string3;
    }

    private static String getDescriptorContextRoot(String string) {
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (SAXException sAXException) {
            LOGGER.log(Level.INFO, null, sAXException);
            return null;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.log(Level.INFO, null, parserConfigurationException);
            return null;
        }
        org.w3c.dom.Node node = document.getElementsByTagName("context-root").item(0);
        if (node == null || node.getTextContent() == null) {
            return null;
        }
        String string2 = node.getTextContent();
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    private static String getWarContextRoot(String string) {
        if (string == null) {
            return null;
        }
        if (!string.endsWith(".war")) {
            return "/" + string;
        }
        return "/" + string.substring(0, string.lastIndexOf(".war"));
    }
}

