/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class JsCommentLexer
implements Lexer<JsCommentTokenId> {
    public static final String AT_RETURN = "@return";
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<JsCommentTokenId> tokenFactory;

    public JsCommentLexer(LexerRestartInfo<JsCommentTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        assert (info.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<JsCommentTokenId> nextToken() {
        int ch = this.input.read();
        if (ch == -1) {
            return null;
        }
        if (Character.isJavaIdentifierStart(ch)) {
            while (Character.isJavaIdentifierPart(this.input.read())) {
            }
            this.input.backup(1);
            return this.token(JsCommentTokenId.IDENT);
        }
        if ("@<.#{}".indexOf(ch) == -1) {
            ch = this.input.read();
            while (!Character.isJavaIdentifierStart(ch) && "@<.#{}".indexOf(ch) == -1 && ch != -1) {
                ch = this.input.read();
            }
            if (ch != -1) {
                this.input.backup(1);
            }
            return this.token(JsCommentTokenId.OTHER_TEXT);
        }
        switch (ch) {
            case 64: {
                while (Character.isLetter(ch = this.input.read())) {
                }
                this.input.backup(1);
                return this.tokenFactory.createToken((TokenId)JsCommentTokenId.COMMENT_TAG, this.input.readLength());
            }
            case 60: {
                while ((ch = this.input.read()) != 62 && ch != -1) {
                }
                return this.token(JsCommentTokenId.HTML_TAG);
            }
            case 123: {
                return this.token(JsCommentTokenId.LCURL);
            }
            case 125: {
                return this.token(JsCommentTokenId.RCURL);
            }
            case 46: {
                return this.token(JsCommentTokenId.DOT);
            }
            case 35: {
                return this.token(JsCommentTokenId.HASH);
            }
        }
        assert (false);
        return null;
    }

    private Token<JsCommentTokenId> token(JsCommentTokenId id) {
        return this.tokenFactory.createToken((TokenId)id);
    }

    public void release() {
    }

    public static Map<String, String> findFunctionTypes(TokenSequence<? extends JsCommentTokenId> ts) {
        HashMap<String, String> result = new HashMap<String, String>();
        while (ts.moveNext()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (id != JsCommentTokenId.COMMENT_TAG) continue;
            CharSequence text = token.text();
            if (TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)text) || TokenUtilities.textEquals((CharSequence)"@argument", (CharSequence)text)) {
                String name;
                int index = ts.index();
                String type = JsCommentLexer.nextType(ts);
                if (type == null) {
                    ts.moveIndex(index);
                    ts.moveNext();
                }
                if ((name = JsCommentLexer.nextIdent(ts)) != null) {
                    result.put(name, type);
                    continue;
                }
                ts.moveIndex(index);
                ts.moveNext();
                continue;
            }
            if (TokenUtilities.textEquals((CharSequence)"@type", (CharSequence)text)) {
                String type = JsCommentLexer.nextIdentGroup(ts);
                if (type == null) continue;
                result.put(AT_RETURN, type);
                continue;
            }
            if (TokenUtilities.textEquals((CharSequence)AT_RETURN, (CharSequence)text) || TokenUtilities.textEquals((CharSequence)"@returns", (CharSequence)text)) {
                String type = JsCommentLexer.nextType(ts);
                if (type == null) continue;
                result.put(AT_RETURN, type);
                continue;
            }
            if (TokenUtilities.textEquals((CharSequence)"@namespace", (CharSequence)text) || TokenUtilities.textEquals((CharSequence)"@extends", (CharSequence)text) || TokenUtilities.textEquals((CharSequence)"@method", (CharSequence)text) || TokenUtilities.textEquals((CharSequence)"@property", (CharSequence)text) || TokenUtilities.textEquals((CharSequence)"@class", (CharSequence)text)) {
                String arg = JsCommentLexer.nextIdentGroup(ts);
                if (arg == null) continue;
                result.put(((Object)text).toString(), arg);
                continue;
            }
            if (!TokenUtilities.textEquals((CharSequence)"@private", (CharSequence)text) && !TokenUtilities.textEquals((CharSequence)"@constructor", (CharSequence)text) && !TokenUtilities.textEquals((CharSequence)"@ignore", (CharSequence)text) && !TokenUtilities.textEquals((CharSequence)"@deprecated", (CharSequence)text)) continue;
            result.put(((Object)text).toString(), "");
        }
        return result;
    }

    public static String nextType(TokenSequence<? extends JsCommentTokenId> ts) {
        StringBuilder sb = new StringBuilder();
        Token<? extends JsCommentTokenId> nextToken = JsCommentLexer.nextNonIgnored(ts);
        if (nextToken != null && nextToken.id() == JsCommentTokenId.LCURL) {
            boolean newToken = true;
            while (ts.moveNext() && ts.token().id() != JsCommentTokenId.RCURL) {
                TokenId tid = ts.token().id();
                if (tid == JsCommentTokenId.IDENT || tid == JsCommentTokenId.DOT) {
                    if (newToken && sb.length() > 0) {
                        sb.append('|');
                    }
                    newToken = false;
                    sb.append(ts.token().text());
                    continue;
                }
                if (tid == JsCommentTokenId.OTHER_TEXT && TokenUtilities.startsWith((CharSequence)ts.token().text(), (CharSequence)"[]")) {
                    JsCommentLexer.rewriteAsArray(sb);
                    newToken = true;
                    continue;
                }
                if (tid == JsCommentTokenId.HTML_TAG && TokenUtilities.startsWith((CharSequence)ts.token().text(), (CharSequence)"<") && sb.length() >= 5 && sb.charAt(sb.length() - 1) == 'y' && sb.toString().endsWith("Array")) {
                    sb.append(ts.token().text());
                    newToken = true;
                    continue;
                }
                newToken = true;
            }
            if (ts.token() != null && ts.token().id() == JsCommentTokenId.RCURL) {
                return sb.toString();
            }
        }
        return null;
    }

    public static String nextIdent(TokenSequence<? extends JsCommentTokenId> ts) {
        Token<? extends JsCommentTokenId> nextToken = JsCommentLexer.nextNonIgnored(ts);
        if (nextToken != null && nextToken.id() == JsCommentTokenId.IDENT) {
            return ((Object)nextToken.text()).toString();
        }
        return null;
    }

    public static String nextIdentGroup(TokenSequence<? extends JsCommentTokenId> ts) {
        Token<? extends JsCommentTokenId> nextToken = JsCommentLexer.nextNonIgnored(ts);
        if (nextToken != null && nextToken.id() == JsCommentTokenId.IDENT) {
            if (ts.moveNext()) {
                TokenId tid = ts.token().id();
                if (tid == JsCommentTokenId.DOT) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(nextToken.text());
                    boolean goback = true;
                    while (ts.token().id() == JsCommentTokenId.DOT || ts.token().id() == JsCommentTokenId.IDENT) {
                        sb.append(ts.token().text());
                        if (ts.moveNext()) continue;
                        goback = false;
                        break;
                    }
                    if (goback && TokenUtilities.startsWith((CharSequence)ts.token().text(), (CharSequence)"[]")) {
                        JsCommentLexer.rewriteAsArray(sb);
                    } else if (goback) {
                        ts.movePrevious();
                    }
                    return sb.toString();
                }
                if (tid == JsCommentTokenId.HTML_TAG && TokenUtilities.startsWith((CharSequence)ts.token().text(), (CharSequence)"<") && TokenUtilities.endsWith((CharSequence)nextToken.text(), (CharSequence)"Array")) {
                    return "Array" + ((Object)ts.token().text()).toString();
                }
                if (tid == JsCommentTokenId.OTHER_TEXT && TokenUtilities.startsWith((CharSequence)ts.token().text(), (CharSequence)"[]")) {
                    return "Array<" + ((Object)nextToken.text()).toString() + ">";
                }
                ts.movePrevious();
            }
            return ((Object)nextToken.text()).toString();
        }
        return null;
    }

    public static String getCompat(TokenSequence<? extends JsCommentTokenId> ts) {
        Token t;
        StringBuilder sb = new StringBuilder();
        JsCommentLexer.nextIdent(ts);
        while ((t = ts.token()).id() == JsCommentTokenId.IDENT) {
            sb.append(t.text());
            if (!ts.moveNext() || (t = ts.token()).id() != JsCommentTokenId.OTHER_TEXT || t.length() != 1 || t.text().charAt(0) != '|') break;
            sb.append('|');
            if (ts.moveNext()) continue;
        }
        return sb.toString();
    }

    private static void rewriteAsArray(StringBuilder sb) {
        char c;
        int last;
        for (last = sb.length() - 1; last >= 0 && (c = sb.charAt(last)) != '|'; --last) {
        }
        if (++last == sb.length()) {
            return;
        }
        String s = sb.substring(last);
        sb.setLength(last);
        sb.append("Array<");
        sb.append(s);
        sb.append(">");
    }

    private static Token<? extends JsCommentTokenId> nextNonIgnored(TokenSequence<? extends JsCommentTokenId> ts) {
        while (ts.moveNext() && (ts.token().id() == JsCommentTokenId.OTHER_TEXT || ts.token().id() == JsCommentTokenId.RCURL)) {
        }
        return ts.token();
    }
}

