/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.lexer.Lexer;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.ReaderLexerSource;
import org.jrubyparser.lexer.StrTerm;
import org.jrubyparser.lexer.StringTerm;
import org.jrubyparser.lexer.SyntaxException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.ErrorManager;

public final class RubyLexer
implements org.netbeans.spi.lexer.Lexer<RubyTokenId> {
    private static final boolean REUSE_LEXERS = false;
    private static RubyLexer cached;
    private final Lexer lexer = new Lexer();
    private LexerSource lexerSource;
    private boolean inRegexp;
    private LexerInput input;
    private TokenFactory<RubyTokenId> tokenFactory;
    private boolean substituting;
    private boolean inSymbol;
    private boolean inEmbedded;

    private RubyLexer(LexerRestartInfo<RubyTokenId> info) {
        this.lexer.setWarnings((IRubyWarnings)new NullWarnings());
        this.lexer.setPreserveSpaces(true);
    }

    public static synchronized RubyLexer create(LexerRestartInfo<RubyTokenId> info) {
        RubyLexer rubyLexer = cached;
        if (rubyLexer == null) {
            rubyLexer = new RubyLexer(info);
        }
        rubyLexer.restart(info);
        return rubyLexer;
    }

    void restart(LexerRestartInfo<RubyTokenId> info) {
        this.inEmbedded = false;
        this.inSymbol = false;
        this.substituting = false;
        this.inRegexp = false;
        this.lexer.reset();
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        String fileName = "unknown";
        LexerInputReader lexerReader = new LexerInputReader(this.input);
        this.lexerSource = new ReaderLexerSource(fileName, (Reader)lexerReader, 0);
        this.lexer.setSource(this.lexerSource);
        Object state = info.state();
        if (state instanceof JRubyLexerRestartInfo) {
            ((JRubyLexerRestartInfo)state).initializeState(this);
        } else if (state instanceof Integer) {
            int stateValue = (Integer)state;
            this.lexer.setState(Lexer.LexState.fromOrdinal((int)stateValue));
        }
    }

    public void release() {
    }

    public Object state() {
        if (JRubyLexerRestartInfo.needsStateStorage(this)) {
            return new JRubyLexerRestartInfo(this);
        }
        Lexer.LexState state = this.lexer.getLexState();
        if (state == null) {
            return null;
        }
        if (this.lexer.getStrTerm() != null) {
            return new JRubyLexerRestartInfo(this);
        }
        return state.getOrdinal();
    }

    private Token<RubyTokenId> token(RubyTokenId id, int length) {
        String fixedText = id.fixedText();
        return fixedText != null ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : this.tokenFactory.createToken((TokenId)id, length);
    }

    public Token<RubyTokenId> nextToken() {
        int readAhead;
        int token = 0;
        int tokenLength = 0;
        int oldOffset = this.lexerSource.getOffset();
        while (tokenLength == 0) {
            block18: {
                try {
                    this.lexer.advance();
                    token = this.lexer.token();
                    StrTerm strTerm = this.lexer.getStrTerm();
                    if (strTerm == null) break block18;
                    strTerm.splitEmbeddedTokens();
                }
                catch (StringTerm.UnterminatedStringException use) {
                    int ch;
                    token = 256;
                    int readAhead2 = this.lexerSource.chompReadAhead();
                    if (readAhead2 > 0) {
                        this.input.backup(readAhead2);
                    }
                    this.input.backup(this.input.readLengthEOF());
                    tokenLength = 0;
                    while ((ch = this.input.read()) != -1) {
                        ++tokenLength;
                        if (ch != 10) continue;
                        break;
                    }
                    this.lexerSource.setOffset(oldOffset + tokenLength);
                    if (tokenLength > 0) {
                        return this.token(RubyTokenId.ERROR, tokenLength);
                    }
                    return null;
                }
                catch (SyntaxException ex) {
                    token = 256;
                    tokenLength = this.lexerSource.getOffset() - oldOffset;
                    if (tokenLength != 0) break;
                    if (this.input.readLength() > 0) {
                        return this.token(RubyTokenId.IDENTIFIER, this.input.readLength());
                    }
                    return null;
                }
                catch (Throwable ex) {
                    ErrorManager.getDefault().notify(ex);
                    break;
                }
            }
            assert (token != 0);
            if (token == -1) {
                if (this.input.readLength() > 0) {
                    return this.token(RubyTokenId.IDENTIFIER, this.input.readLength());
                }
                return null;
            }
            int offset = this.lexerSource.getOffset();
            tokenLength = offset - oldOffset;
        }
        if ((readAhead = this.lexerSource.chompReadAhead()) > 0) {
            this.input.backup(readAhead);
        }
        RubyTokenId id = this.getTokenId(token, oldOffset);
        if (this.inSymbol) {
            boolean inEmbedded;
            String category = id.primaryCategory();
            boolean isString = "string".equals(category);
            boolean bl = inEmbedded = id == RubyTokenId.EMBEDDED_RUBY;
            if (!isString && !inEmbedded || id == RubyTokenId.STRING_END || id == RubyTokenId.QUOTED_STRING_END) {
                boolean bl2 = this.inSymbol = token == 364;
            }
            if (isString || id == RubyTokenId.IDENTIFIER || id == RubyTokenId.CONSTANT || "keyword".equals(category)) {
                id = RubyTokenId.TYPE_SYMBOL;
            }
        } else {
            boolean bl = this.inSymbol = token == 364;
        }
        if (tokenLength <= 0) {
            return this.token(RubyTokenId.IDENTIFIER, 1);
        }
        return this.token(id, tokenLength);
    }

    private RubyTokenId getTokenId(int token, int offset) {
        switch (token) {
            case 381: {
                return RubyTokenId.LINE_COMMENT;
            }
            case 382: {
                return RubyTokenId.WHITESPACE;
            }
            case 379: {
                return RubyTokenId.FLOAT_LITERAL;
            }
            case 378: {
                return RubyTokenId.INT_LITERAL;
            }
            case 365: 
            case 366: 
            case 368: 
            case 369: {
                this.substituting = this.lexer.getStrTerm() != null ? this.lexer.getStrTerm().isSubstituting() : false;
                return this.substituting ? RubyTokenId.QUOTED_STRING_BEGIN : RubyTokenId.STRING_BEGIN;
            }
            case 370: 
            case 371: {
                this.inEmbedded = true;
                return this.inRegexp ? RubyTokenId.REGEXP_LITERAL : RubyTokenId.STRING_LITERAL;
            }
            case 372: {
                return this.substituting ? RubyTokenId.QUOTED_STRING_END : RubyTokenId.STRING_END;
            }
            case 377: {
                if (this.inEmbedded) {
                    this.inEmbedded = false;
                    return RubyTokenId.EMBEDDED_RUBY;
                }
                if (this.inRegexp) {
                    return RubyTokenId.REGEXP_LITERAL;
                }
                if (this.lexer.getStrTerm() != null) {
                    this.substituting = this.lexer.getStrTerm().isSubstituting();
                    if (this.substituting) {
                        return RubyTokenId.QUOTED_STRING_LITERAL;
                    }
                    return RubyTokenId.STRING_LITERAL;
                }
                this.substituting = false;
                return RubyTokenId.STRING_LITERAL;
            }
            case 367: {
                this.inRegexp = true;
                return RubyTokenId.REGEXP_BEGIN;
            }
            case 380: {
                this.inRegexp = false;
                return RubyTokenId.REGEXP_END;
            }
            case 383: {
                return RubyTokenId.DOCUMENTATION;
            }
            case 256: {
                return RubyTokenId.ERROR;
            }
            case 308: 
            case 375: 
            case 376: {
                return RubyTokenId.GLOBAL_VAR;
            }
            case 309: {
                return RubyTokenId.INSTANCE_VAR;
            }
            case 311: {
                return RubyTokenId.CLASS_VAR;
            }
            case 310: {
                return RubyTokenId.CONSTANT;
            }
            case 306: {
                return RubyTokenId.IDENTIFIER;
            }
            case 364: {
                return RubyTokenId.TYPE_SYMBOL;
            }
            case 91: 
            case 343: {
                return RubyTokenId.LBRACKET;
            }
            case 93: 
            case 344: {
                return RubyTokenId.RBRACKET;
            }
            case 339: 
            case 340: 
            case 342: {
                return RubyTokenId.LPAREN;
            }
            case 341: {
                return RubyTokenId.RPAREN;
            }
            case 345: 
            case 346: 
            case 361: {
                return RubyTokenId.LBRACE;
            }
            case 362: {
                return RubyTokenId.RBRACE;
            }
            case 259: {
                return RubyTokenId.DEF;
            }
            case 264: {
                return RubyTokenId.END;
            }
            case 257: {
                return RubyTokenId.CLASS;
            }
            case 258: {
                return RubyTokenId.MODULE;
            }
            case 261: {
                return RubyTokenId.BEGIN;
            }
            case 265: {
                return RubyTokenId.IF;
            }
            case 266: {
                return RubyTokenId.UNLESS;
            }
            case 272: {
                return RubyTokenId.WHILE;
            }
            case 273: {
                return RubyTokenId.UNTIL;
            }
            case 281: 
            case 282: {
                return RubyTokenId.ANY_KEYWORD;
            }
            case 280: {
                return RubyTokenId.DO;
            }
            case 270: {
                return RubyTokenId.CASE;
            }
            case 274: {
                return RubyTokenId.FOR;
            }
            case 269: {
                return RubyTokenId.ELSE;
            }
            case 268: {
                return RubyTokenId.ELSIF;
            }
            case 263: {
                return RubyTokenId.ENSURE;
            }
            case 271: {
                return RubyTokenId.WHEN;
            }
            case 262: {
                return RubyTokenId.RESCUE;
            }
            case 285: {
                return RubyTokenId.SUPER;
            }
            case 286: {
                return RubyTokenId.SELF;
            }
            case 331: 
            case 332: {
                return RubyTokenId.ANY_OPERATOR;
            }
            case 260: 
            case 267: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 283: 
            case 284: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                return RubyTokenId.ANY_KEYWORD;
            }
            case 58: 
            case 61: 
            case 63: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 333: 
            case 334: 
            case 337: 
            case 338: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: {
                return RubyTokenId.NONUNARY_OP;
            }
            case 328: {
                return RubyTokenId.DOT;
            }
            case 329: 
            case 330: {
                return RubyTokenId.RANGE;
            }
            case 336: {
                return RubyTokenId.COLON3;
            }
        }
        return RubyTokenId.IDENTIFIER;
    }

    private static class NullWarnings
    implements IRubyWarnings {
        private NullWarnings() {
        }

        public boolean isVerbose() {
            return false;
        }

        public void warn(IRubyWarnings.ID id, String message, Object ... data) {
        }

        public void warning(IRubyWarnings.ID id, String message, Object ... data) {
        }

        public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        }

        public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        }

        public void warn(IRubyWarnings.ID arg0, SourcePosition arg1, String arg2, Object ... arg3) {
        }

        public void warning(IRubyWarnings.ID arg0, SourcePosition arg1, String arg2, Object ... arg3) {
        }
    }

    private static class LexerInputStream
    extends InputStream {
        private LexerInput input;

        LexerInputStream(LexerInput input) {
            this.input = input;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            int c = this.input.read();
            if (c == -1) {
                return -1;
            }
            return c;
        }
    }

    private static class LexerInputReader
    extends Reader {
        private LexerInput input;

        LexerInputReader(LexerInput input) {
            this.input = input;
        }

        @Override
        public int read(char[] buf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                int c = this.input.read();
                if (c == -1) {
                    return -1;
                }
                buf[i + off] = (char)c;
            }
            return len;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class JRubyLexerRestartInfo {
        private static final int IN_REGEXP = 1;
        private static final int IN_SYMBOL = 2;
        private static final int IN_EMBEDDED = 4;
        private static final int IN_SUBSTITUTING = 8;
        private static final int SET_SPACE_SEEN = 16;
        private static final int SET_COMMAND_START = 32;
        private final StrTerm strTerm;
        private int localState;
        private final Lexer.LexState lexState;
        private Object strTermState;
        private final Lexer.HeredocContext heredocContext;

        JRubyLexerRestartInfo(RubyLexer rubyLexer) {
            this.strTerm = rubyLexer.lexer.getStrTerm();
            if (this.strTerm != null) {
                this.strTermState = this.strTerm.getMutableState();
            }
            this.heredocContext = ((RubyLexer)rubyLexer).lexer.heredocContext;
            this.lexState = rubyLexer.lexer.getLexState();
            if (rubyLexer.inRegexp) {
                ++this.localState;
            }
            if (rubyLexer.inSymbol) {
                this.localState += 2;
            }
            if (rubyLexer.inEmbedded) {
                this.localState += 4;
            }
            if (rubyLexer.substituting) {
                this.localState += 8;
            }
            if (rubyLexer.lexer.isSetSpaceSeen()) {
                this.localState += 16;
            }
            if (rubyLexer.lexer.isCommandStart()) {
                this.localState += 32;
            }
        }

        public static boolean needsStateStorage(RubyLexer rubyLexer) {
            return rubyLexer.inRegexp || rubyLexer.inSymbol || rubyLexer.inEmbedded || rubyLexer.substituting || rubyLexer.lexer.isCommandStart() || ((RubyLexer)rubyLexer).lexer.heredocContext != null || rubyLexer.lexer.isSetSpaceSeen();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JRubyLexerRestartInfo other = (JRubyLexerRestartInfo)obj;
            if (!(this.strTerm == other.strTerm || this.strTerm != null && this.strTerm.equals(other.strTerm))) {
                return false;
            }
            if (this.localState != other.localState) {
                return false;
            }
            if (this.lexState != other.lexState && (this.lexState == null || this.lexState.getOrdinal() != other.lexState.getOrdinal())) {
                return false;
            }
            if (!(this.strTermState == other.strTermState || this.strTermState != null && this.strTermState.equals(other.strTermState))) {
                return false;
            }
            return this.heredocContext == other.heredocContext || this.heredocContext != null && this.heredocContext.equals((Object)other.heredocContext);
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + this.localState;
            hash = 43 * hash + (this.strTerm != null ? this.strTerm.hashCode() : 0);
            hash = 43 * hash + (this.strTermState != null ? this.strTermState.hashCode() : 0);
            return hash;
        }

        private static String toStateString(int localState) {
            String s;
            StringBuilder sb = new StringBuilder();
            if ((localState & 1) != 0) {
                sb.append("regexp|");
            }
            if ((localState & 2) != 0) {
                sb.append("symbol|");
            }
            if ((localState & 4) != 0) {
                sb.append("embedded|");
            }
            if ((localState & 8) != 0) {
                sb.append("substituting|");
            }
            if ((localState & 0x20) != 0) {
                sb.append("commandstart|");
            }
            if ((localState & 0x10) != 0) {
                sb.append("spaceseen|");
            }
            if ((s = sb.toString()).endsWith("|")) {
                s = s.substring(0, s.length() - 1);
            } else if (s.length() == 0) {
                s = "-";
            }
            return s;
        }

        public String toString() {
            return "RubyLexerState[" + JRubyLexerRestartInfo.toStateString(this.localState) + "," + this.strTerm + "," + this.lexState + "," + this.strTermState + "," + this.heredocContext + "]";
        }

        void initializeState(RubyLexer rubyLexer) {
            rubyLexer.lexer.setStrTerm(this.strTerm);
            ((RubyLexer)rubyLexer).lexer.heredocContext = this.heredocContext;
            if (this.strTermState != null && this.strTerm != null) {
                this.strTerm.setMutableState(this.strTermState);
            }
            if ((this.localState & 1) != 0) {
                rubyLexer.inRegexp = true;
            }
            if ((this.localState & 2) != 0) {
                rubyLexer.inSymbol = true;
            }
            if ((this.localState & 4) != 0) {
                rubyLexer.inEmbedded = true;
            }
            if ((this.localState & 8) != 0) {
                rubyLexer.substituting = true;
            }
            if ((this.localState & 0x20) != 0) {
                rubyLexer.lexer.setCommandStart(true);
            }
            if ((this.localState & 0x10) != 0) {
                rubyLexer.lexer.setSpaceSeen(true);
            }
            rubyLexer.lexer.setLexState(this.lexState);
        }
    }
}

