/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.DotNode;
import org.jrubyparser.ast.ForNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.ToAryNode;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RDocAnalyzer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.openide.filesystems.FileObject;

final class RubyTypeAnalyzer {
    private final ContextKnowledge knowledge;
    private boolean analyzed;
    private boolean targetReached;
    private final Set<String> analyzedMethods = new HashSet<String>();
    private final RubyTypeInferencer typeInferencer;
    private static final String[] RAILS_CONTROLLER_VARS = new String[]{"action_name", "String", "assigns", "Hash", "cookies", "ActionController::CookieJar", "flash", "ActionController::Flash::FlashHash", "headers", "Hash", "params", "Hash", "request", "ActionController::CgiRequest", "session", "CGI::Session", "url", "ActionController::UrlRewriter"};

    RubyTypeAnalyzer(ContextKnowledge knowledge, RubyTypeInferencer typeInferencer) {
        this.knowledge = knowledge;
        this.typeInferencer = typeInferencer;
    }

    void analyze() {
        if (!this.analyzed) {
            this.knowledge.setAnalyzed(true);
            RubyTypeAnalyzer.initFileTypeVars(this.knowledge);
            RDocAnalyzer.collectTypeAssertions(this.knowledge);
            this.analyze(this.knowledge.getRoot(), this.knowledge.getTypesForSymbols(), true, null);
            this.analyzed = true;
        }
    }

    static void collectMultipleAsgnVars(MultipleAsgnNode multipleAsgnNode, RubyTypeInferencer typeInferencer, Map<Node, RubyType> result) {
        ListNode head = multipleAsgnNode.getHeadNode();
        Node value = multipleAsgnNode.getValueNode();
        if (head == null || value == null) {
            return;
        }
        if (value.getNodeType() == NodeType.TOARYNODE) {
            value = ((ToAryNode)value).getValue();
        }
        if (value.childNodes().size() != head.childNodes().size()) {
            return;
        }
        for (int i = 0; i < head.childNodes().size(); ++i) {
            Node var = (Node)head.childNodes().get(i);
            RubyTypeAnalyzer.collectTypes(var, (Node)value.childNodes().get(i), typeInferencer, result);
        }
    }

    private static void collectTypes(Node head, Node value, RubyTypeInferencer typeInferencer, Map<Node, RubyType> result) {
        if (head == null || value == null) {
            return;
        }
        if (value.getNodeType() == NodeType.TOARYNODE) {
            value = ((ToAryNode)value).getValue();
        }
        if (head.getNodeType() == NodeType.MULTIPLEASGNNODE) {
            MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)head;
            ListNode headNode = multipleAsgnNode.getHeadNode();
            if (headNode != null && headNode.childNodes().size() == value.childNodes().size()) {
                for (int i = 0; i < multipleAsgnNode.getHeadNode().childNodes().size(); ++i) {
                    Node var = (Node)multipleAsgnNode.getHeadNode().childNodes().get(i);
                    RubyTypeAnalyzer.collectTypes(var, (Node)value.childNodes().get(i), typeInferencer, result);
                }
            }
        } else if (head.getNodeType() == NodeType.ARRAYNODE && value.getNodeType() == NodeType.ARRAYNODE) {
            ArrayNode headArray = (ArrayNode)head;
            ArrayNode valueArray = (ArrayNode)value;
            if (headArray.size() == valueArray.size()) {
                for (int i = 0; i < headArray.size(); ++i) {
                    RubyTypeAnalyzer.collectTypes(headArray.get(i), valueArray.get(i), typeInferencer, result);
                }
            }
        } else {
            result.put(head, typeInferencer.inferType(value));
        }
    }

    private static String getCurrentMethod(Node node, String currentMethod) {
        if (node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) {
            return AstUtilities.getName(node);
        }
        if (node.getNodeType() == NodeType.MODULENODE || node.getNodeType() == NodeType.CLASSNODE || node.getNodeType() == NodeType.SCLASSNODE) {
            return "";
        }
        return currentMethod;
    }

    private void analyze(Node node, Map<String, RubyType> typesForSymbols, boolean override, String currentMethod) {
        currentMethod = RubyTypeAnalyzer.getCurrentMethod(node, currentMethod);
        if (node == this.knowledge.getTarget()) {
            this.targetReached = true;
        }
        if (this.targetReached && node.getPosition().getStartOffset() > this.knowledge.getAstOffset()) {
            return;
        }
        switch (node.getNodeType()) {
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
                HashMap<Node, RubyType> vars = new HashMap<Node, RubyType>();
                RubyTypeAnalyzer.collectMultipleAsgnVars(multipleAsgnNode, this.typeInferencer, vars);
                for (Node each : vars.keySet()) {
                    if (!(each instanceof INameNode)) continue;
                    String name = AstUtilities.getName(each);
                    this.maybePutTypeForSymbol(typesForSymbols, name, (RubyType)vars.get(each), override, currentMethod);
                }
                return;
            }
            case LOCALASGNNODE: {
                ForNode forNode;
                Node iterNode;
                AstPath path;
                Node leafParent;
                String symbol = RubyTypeInferencer.getLocalVarPath(this.knowledge.getRoot(), node, currentMethod);
                LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
                if (localAsgnNode.getValueNode() instanceof NilImplicitNode && (leafParent = (path = new AstPath(this.knowledge.getRoot(), node)).leafParent()) instanceof ForNode && (iterNode = (forNode = (ForNode)leafParent).getIterNode()) instanceof DotNode) {
                    DotNode dotNode = (DotNode)iterNode;
                    RubyType type = this.typeInferencer.inferType(dotNode.getBeginNode());
                    this.maybePutTypeForSymbol(typesForSymbols, symbol, type, override, currentMethod);
                    break;
                }
                RubyType type = this.typeInferencer.inferTypesOfRHS(node, currentMethod);
                this.maybePutTypeForSymbol(typesForSymbols, symbol, type, override, currentMethod);
                break;
            }
            case CONSTDECLNODE: {
                RubyType type = this.typeInferencer.inferTypesOfRHS(node, currentMethod);
                String fqn = AstUtilities.getFqnName(this.knowledge.getRoot(), node);
                this.maybePutTypeForSymbol(typesForSymbols, fqn, type, override, currentMethod);
                break;
            }
            case INSTASGNNODE: 
            case GLOBALASGNNODE: 
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case DASGNNODE: {
                RubyType type = this.typeInferencer.inferTypesOfRHS(node, currentMethod);
                String symbol = AstUtilities.getName(node);
                this.maybePutTypeForSymbol(typesForSymbols, symbol, type, override, currentMethod);
                break;
            }
        }
        if (node.getNodeType() == NodeType.IFNODE) {
            this.analyzeIfNode((IfNode)node, typesForSymbols, currentMethod);
        } else {
            for (Node child : node.childNodes()) {
                if (child.isInvisible()) continue;
                this.analyze(child, typesForSymbols, override, currentMethod);
            }
        }
    }

    private void analyzeIfNode(IfNode ifNode, Map<String, RubyType> typesForSymbols, String currentMethod) {
        Node thenBody = ifNode.getThenBody();
        HashMap<String, RubyType> ifTypesAccu = new HashMap<String, RubyType>();
        if (thenBody != null) {
            this.analyze(thenBody, ifTypesAccu, true, currentMethod);
        }
        Node elseBody = ifNode.getElseBody();
        HashMap<String, RubyType> elseTypesAccu = new HashMap<String, RubyType>();
        if (elseBody != null) {
            this.analyze(elseBody, elseTypesAccu, true, currentMethod);
        }
        HashMap<String, RubyType> allTypesForSymbols = new HashMap<String, RubyType>();
        for (Map.Entry entry : elseTypesAccu.entrySet()) {
            this.maybePutTypeForSymbol(allTypesForSymbols, (String)entry.getKey(), (RubyType)entry.getValue(), false, currentMethod);
        }
        for (Map.Entry entry : ifTypesAccu.entrySet()) {
            this.maybePutTypeForSymbol(allTypesForSymbols, (String)entry.getKey(), (RubyType)entry.getValue(), false, currentMethod);
        }
        for (Map.Entry entry : allTypesForSymbols.entrySet()) {
            String var = (String)entry.getKey();
            boolean override = ifTypesAccu.containsKey(var) && elseTypesAccu.containsKey(var);
            this.maybePutTypeForSymbol(typesForSymbols, var, (RubyType)entry.getValue(), override, currentMethod);
        }
    }

    private static void initFileTypeVars(ContextKnowledge knowledge) {
        FileObject fo = RubyUtils.getFileObject((Parser.Result)knowledge.getParserResult());
        if (fo == null) {
            return;
        }
        String ext = fo.getExt();
        if (ext.equals("rb")) {
            String name = fo.getName();
            if (name.endsWith("_controller")) {
                for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                    String var = RAILS_CONTROLLER_VARS[i];
                    String type = RAILS_CONTROLLER_VARS[i + 1];
                    knowledge.maybePutTypeForSymbol(var, type, true);
                }
            }
        } else if (ext.equals("rhtml") || ext.equals("erb")) {
            for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                String var = RAILS_CONTROLLER_VARS[i];
                String type = RAILS_CONTROLLER_VARS[i + 1];
                knowledge.maybePutTypeForSymbol(var, type, true);
            }
        } else if (ext.equals("rjs")) {
            knowledge.maybePutTypeForSymbol("page", "ActionView::Helpers::PrototypeHelper::JavaScriptGenerator::GeneratorMethods", true);
        } else if (ext.equals("builder") || ext.equals("rxml")) {
            knowledge.maybePutTypeForSymbol("xml", "Builder::XmlMarkup", true);
        }
    }

    private void maybePutTypeForSymbol(Map<String, RubyType> typesForSymbols, String symbol, RubyType newType, boolean override, String currentMethod) {
        RubyType mapType = typesForSymbols.get(symbol);
        if (symbol.startsWith("@") && currentMethod != null && !this.analyzedMethods.contains(currentMethod)) {
            this.analyzedMethods.add(currentMethod);
            override = false;
        }
        if (mapType == null || override) {
            mapType = new RubyType();
            typesForSymbols.put(symbol, mapType);
        }
        mapType.append(newType);
    }
}

