/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectConfigurations;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCustomizerPanel;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.cookies.CloseCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JWSCompositeCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_WEBSTART = "WebStart";
    private static JWSProjectProperties jwsProps = null;
    private static final String MASTER_NAME_APPLICATION = "master-application.jnlp";
    private static final String MASTER_NAME_APPLET = "master-applet.jnlp";
    private static final String MASTER_NAME_COMPONENT = "master-component.jnlp";
    private static final String PREVIEW_NAME_APPLICATION = "preview-application.html";
    private static final String PREVIEW_NAME_APPLET = "preview-applet.html";
    private static final String JWS_ANT_TASKS_LIB_NAME = "JWSAntTasks";
    private static final String PREVIOUS_JNLP_IMPL_CRC32 = "3528ef9f";
    private static final Logger LOG = Logger.getLogger(JWSCompositeCategoryProvider.class.getName());

    public ProjectCustomizer.Category createCategory(Lookup lookup) {
        return ProjectCustomizer.Category.create((String)CAT_WEBSTART, (String)NbBundle.getMessage(JWSCompositeCategoryProvider.class, (String)"LBL_Category_WebStart"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
        jwsProps = new JWSProjectProperties(lookup);
        category.setOkButtonListener((ActionListener)new OkButtonListener(jwsProps, (Project)lookup.lookup(Project.class)));
        category.setStoreListener((ActionListener)new SavePropsListener(jwsProps, (Project)lookup.lookup(Project.class)));
        return new JWSCustomizerPanel(jwsProps);
    }

    static String computeCrc32(InputStream inputStream) throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        int n2 = -1;
        while ((n = inputStream.read()) != -1) {
            if (n != 10 && n2 == 13) {
                cRC32.update(10);
            }
            if (n != 13) {
                cRC32.update(n);
            }
            n2 = n;
        }
        if (n2 == 13) {
            cRC32.update(10);
        }
        int n3 = (int)cRC32.getValue();
        String string = Integer.toHexString(n3);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    static boolean isJnlpImplPreviousVer(String string) {
        return PREVIOUS_JNLP_IMPL_CRC32.equals(string);
    }

    private static class SavePropsListener
    implements ActionListener {
        private JWSProjectProperties jwsProps;
        private Project j2seProject;

        public SavePropsListener(JWSProjectProperties jWSProjectProperties, Project project) {
            this.jwsProps = jWSProjectProperties;
            this.j2seProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.jwsProps.store();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            ProjectConfigurationProvider projectConfigurationProvider = (ProjectConfigurationProvider)this.j2seProject.getLookup().lookup(ProjectConfigurationProvider.class);
            try {
                if (this.jwsProps.isJWSEnabled()) {
                    this.setActiveConfig(projectConfigurationProvider, NbBundle.getBundle(JWSCompositeCategoryProvider.class).getString("LBL_Category_WebStart"));
                    this.copyTemplate(this.j2seProject);
                    this.modifyBuildXml(this.j2seProject);
                    this.copyJWSAntTasksLibrary(this.j2seProject);
                } else {
                    this.setActiveConfig(projectConfigurationProvider, NbBundle.getBundle(JWSCompositeCategoryProvider.class).getString("LBL_Category_Default"));
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private <C extends ProjectConfiguration> void setActiveConfig(final ProjectConfigurationProvider<C> projectConfigurationProvider, String string) throws IOException {
            Collection collection = projectConfigurationProvider.getConfigurations();
            for (final ProjectConfiguration projectConfiguration : collection) {
                if (!string.equals(projectConfiguration.getDisplayName())) continue;
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            projectConfigurationProvider.setActiveConfiguration(projectConfiguration);
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    throw (IOException)mutexException.getException();
                }
            }
        }

        private void copyTemplate(Project project) throws IOException {
            FileObject fileObject;
            FileObject fileObject2 = project.getProjectDirectory();
            FileObject fileObject3 = fileObject2.getFileObject("nbproject/jnlp-impl.xml");
            if (fileObject3 != null && JWSCompositeCategoryProvider.isJnlpImplPreviousVer(JWSCompositeCategoryProvider.computeCrc32(fileObject3.getInputStream()))) {
                fileObject = DataObject.find((FileObject)fileObject3);
                CloseCookie closeCookie = (CloseCookie)fileObject.getLookup().lookup(CloseCookie.class);
                if (closeCookie != null) {
                    closeCookie.close();
                }
                FileUtil.moveFile((FileObject)fileObject3, (FileObject)fileObject2.getFileObject("nbproject"), (String)"jnlp-impl_backup");
                fileObject3 = null;
            }
            if (fileObject3 == null && (fileObject = FileUtil.getConfigFile((String)"Templates/JWS/jnlp-impl.xml")) != null) {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2.getFileObject("nbproject"), (String)"jnlp-impl");
            }
        }

        private void modifyBuildXml(Project project) throws IOException {
            Object object;
            int n;
            Element element;
            FileObject fileObject = project.getProjectDirectory();
            final FileObject fileObject2 = SavePropsListener.getBuildXml(project);
            if (fileObject2 == null) {
                LOG.warning("The project build script does not exist, the project cannot be extended by JWS.");
                return;
            }
            Document document = null;
            try {
                document = XMLUtil.parse((InputSource)new InputSource(fileObject2.getURL().toExternalForm()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
            FileObject fileObject3 = fileObject.getFileObject("nbproject/jnlp-impl.xml");
            AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (antBuildExtender != null) {
                assert (fileObject3 != null);
                if (antBuildExtender.getExtension("jws") == null) {
                    element = antBuildExtender.addExtension("jws", fileObject3);
                    element.addDependency("jar", "jnlp");
                }
                ProjectManager.getDefault().saveProject(project);
            } else {
                LOG.log(Level.INFO, "Trying to include JWS build snippet in project type that doesn't support AntBuildExtender API contract.");
            }
            element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("target");
            Element element2 = null;
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = (Element)nodeList.item(n);
                if (object.getAttribute("name") == null || !"-post-jar".equals(object.getAttribute("name"))) continue;
                element2 = object;
                break;
            }
            n = 0;
            if (element2 != null && element2.getAttribute("depends") != null && element2.getAttribute("depends").contains("jnlp")) {
                object = element2.getAttribute("depends");
                object = ((String)object).replaceAll("jnlp", "");
                object = ((String)object).replaceAll(",[\\s]*$", "");
                object = ((String)object).replaceAll("^[\\s]*,", "");
                object = ((String)object).replaceAll(",[\\s]*,", ",");
                if (((String)(object = ((String)object).trim())).length() == 0) {
                    element2.removeAttribute("depends");
                } else {
                    element2.setAttribute("depends", (String)object);
                }
                n = 1;
            }
            nodeList = element.getElementsByTagName("import");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (element3.getAttribute("file") == null || !"nbproject/jnlp-impl.xml".equals(element3.getAttribute("file"))) continue;
                element3.getParentNode().removeChild(element3);
                n = 1;
                break;
            }
            if (n != 0) {
                final Document document2 = document;
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Void run() throws Exception {
                            FileLock fileLock = fileObject2.lock();
                            try {
                                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                                try {
                                    XMLUtil.write((Document)document2, (OutputStream)outputStream, (String)"UTF-8");
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                fileLock.releaseLock();
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    throw (IOException)mutexException.getException();
                }
            }
        }

        private void copyJWSAntTasksLibrary(Project project) throws IOException {
            AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
            if (antBuildExtender != null) {
                LibraryManager.getDefault();
                antBuildExtender.addLibrary(LibraryManager.getDefault().getLibrary(JWSCompositeCategoryProvider.JWS_ANT_TASKS_LIB_NAME));
                ProjectManager.getDefault().saveProject(project);
            }
        }

        private static FileObject getBuildXml(Project project) {
            J2SEPropertyEvaluator j2SEPropertyEvaluator = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
            assert (j2SEPropertyEvaluator != null);
            PropertyEvaluator propertyEvaluator = j2SEPropertyEvaluator.evaluator();
            String string = propertyEvaluator.getProperty("buildfile");
            if (string == null) {
                string = "build.xml";
            }
            return project.getProjectDirectory().getFileObject(string);
        }
    }

    private static class OkButtonListener
    implements ActionListener {
        private JWSProjectProperties jwsProps;
        private Project j2seProject;

        private OkButtonListener(JWSProjectProperties jWSProjectProperties, Project project) {
            this.jwsProps = jWSProjectProperties;
            this.j2seProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.jwsProps.isJWSEnabled()) {
                    FileObject fileObject;
                    J2SEProjectConfigurations.createConfigurationFiles((Project)this.j2seProject, (String)"JWS_generated", (EditableProperties)this.prepareSharedProps(), null);
                    FileObject fileObject2 = this.j2seProject.getProjectDirectory();
                    JWSProjectProperties.DescType descType = this.jwsProps.getDescTypeProp();
                    if (JWSProjectProperties.DescType.application.equals((Object)descType)) {
                        FileObject fileObject3;
                        FileObject fileObject4 = fileObject2.getFileObject(JWSCompositeCategoryProvider.MASTER_NAME_APPLICATION);
                        if (fileObject4 == null || !fileObject4.isValid()) {
                            this.createMasterFile(fileObject2, JWSCompositeCategoryProvider.MASTER_NAME_APPLICATION, descType);
                        }
                        if ((fileObject3 = fileObject2.getFileObject(JWSCompositeCategoryProvider.PREVIEW_NAME_APPLICATION)) == null || !fileObject3.isValid()) {
                            this.createPreviewFile(fileObject2, JWSCompositeCategoryProvider.PREVIEW_NAME_APPLICATION, descType);
                        }
                    } else if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                        FileObject fileObject5;
                        FileObject fileObject6 = fileObject2.getFileObject(JWSCompositeCategoryProvider.MASTER_NAME_APPLET);
                        if (fileObject6 == null || !fileObject6.isValid()) {
                            this.createMasterFile(fileObject2, JWSCompositeCategoryProvider.MASTER_NAME_APPLET, descType);
                        }
                        if ((fileObject5 = fileObject2.getFileObject(JWSCompositeCategoryProvider.PREVIEW_NAME_APPLET)) == null || !fileObject5.isValid()) {
                            this.createPreviewFile(fileObject2, JWSCompositeCategoryProvider.PREVIEW_NAME_APPLET, descType);
                        }
                    } else if (JWSProjectProperties.DescType.component.equals((Object)descType) && ((fileObject = fileObject2.getFileObject(JWSCompositeCategoryProvider.MASTER_NAME_COMPONENT)) == null || !fileObject.isValid())) {
                        this.createMasterFile(fileObject2, JWSCompositeCategoryProvider.MASTER_NAME_COMPONENT, descType);
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private EditableProperties prepareSharedProps() {
            EditableProperties editableProperties = new EditableProperties(true);
            editableProperties.setProperty("$label", NbBundle.getBundle(JWSCompositeCategoryProvider.class).getString("LBL_Category_WebStart"));
            editableProperties.setProperty("$target.run", "jws-run");
            editableProperties.setProperty("$target.debug", "jws-debug");
            editableProperties.setProperty("compile.on.save.unsupported.javawebstart", "true");
            return editableProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createMasterFile(FileObject fileObject, String string, JWSProjectProperties.DescType descType) throws IOException {
            FileObject fileObject2 = fileObject.createData(string);
            FileLock fileLock = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                PrintWriter printWriter = new PrintWriter(outputStream);
                printWriter.println("<jnlp spec=\"1.0+\" codebase=\"${jnlp.codebase}\" href=\"launch.jnlp\">");
                printWriter.println("    <information>");
                printWriter.println("        <title>${APPLICATION.TITLE}</title>");
                printWriter.println("        <vendor>${APPLICATION.VENDOR}</vendor>");
                printWriter.println("        <homepage href=\"${APPLICATION.HOMEPAGE}\"/>");
                printWriter.println("        <description>${APPLICATION.DESC}</description>");
                printWriter.println("        <description kind=\"short\">${APPLICATION.DESC.SHORT}</description>");
                printWriter.println("<!--${JNLP.ICONS}-->");
                printWriter.println("    </information>");
                printWriter.println("<!--${JNLP.UPDATE}-->");
                printWriter.println("<!--${JNLP.SECURITY}-->");
                printWriter.println("    <resources>");
                printWriter.println("<!--${JNLP.RESOURCES.RUNTIME}-->");
                printWriter.println("<!--${JNLP.RESOURCES.MAIN.JAR}-->");
                printWriter.println("<!--${JNLP.RESOURCES.JARS}-->");
                printWriter.println("<!--${JNLP.RESOURCES.EXTENSIONS}-->");
                printWriter.println("    </resources>");
                if (descType.equals((Object)JWSProjectProperties.DescType.application)) {
                    printWriter.println("    <application-desc main-class=\"${jnlp.main.class}\">");
                    printWriter.println("<!--${JNLP.APPLICATION.ARGS}-->");
                    printWriter.println("    </application-desc>");
                } else if (descType.equals((Object)JWSProjectProperties.DescType.applet)) {
                    printWriter.println("    <applet-desc main-class=\"${jnlp.main.class}\" name=\"${APPLICATION.TITLE}\"\n        width=\"${jnlp.applet.width}\" height=\"${jnlp.applet.height}\">");
                    printWriter.println("<!--${JNLP.APPLET.PARAMS}-->");
                    printWriter.println("    </applet-desc>");
                } else if (descType.equals((Object)JWSProjectProperties.DescType.component)) {
                    printWriter.println("    <component-desc/>");
                }
                printWriter.println("</jnlp>");
                printWriter.flush();
                printWriter.close();
                outputStream.close();
            }
            finally {
                fileLock.releaseLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createPreviewFile(FileObject fileObject, String string, JWSProjectProperties.DescType descType) throws IOException {
            FileObject fileObject2 = fileObject.createData(string);
            FileLock fileLock = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                PrintWriter printWriter = new PrintWriter(outputStream);
                printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                    printWriter.println("<!-- ########################## IMPORTANT NOTE ############################ -->");
                    printWriter.println("<!-- This preview HTML page will work only with JDK 6 update 10 and higher! -->");
                    printWriter.println("<!-- ###################################################################### -->");
                }
                printWriter.println("<html>");
                printWriter.println("    <head>");
                if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                    printWriter.println("        <title>Test page for launching the applet via JNLP</title>");
                } else if (JWSProjectProperties.DescType.application.equals((Object)descType)) {
                    printWriter.println("        <title>Test page for launching the application via JNLP</title>");
                }
                printWriter.println("    </head>");
                printWriter.println("    <body>");
                if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                    printWriter.println("        <h3>Test page for launching the applet via JNLP</h3>");
                    printWriter.println("        <script src=\"http://java.com/js/deployJava.js\"></script>");
                    printWriter.println("        <script>");
                    printWriter.println("            var attributes = {");
                    printWriter.println("                code:       \"${JNLP.APPLET.CLASS}\",");
                    printWriter.println("                archive:    \"${JNLP.RESOURCES.MAIN.JAR}\",");
                    printWriter.println("                width:      ${JNLP.APPLET.WIDTH},");
                    printWriter.println("                height:     ${JNLP.APPLET.HEIGHT}");
                    printWriter.println("            };");
                    printWriter.println("            var parameters = {${JNLP.APPLET.PARAMS}}; <!-- Applet Parameters -->");
                    printWriter.println("            var version = \"${JNLP_VM_VERSION}\"; <!-- Required Java Version -->");
                    printWriter.println("            deployJava.runApplet(attributes, parameters, version);");
                    printWriter.println("        </script>");
                    printWriter.println("        <!-- Or use the following applet element to launch the applet using jnlp_href -->");
                    printWriter.println("        <!--");
                    printWriter.println("        <applet width=\"${JNLP.APPLET.WIDTH}\" height=\"${JNLP.APPLET.HEIGHT}\">");
                    printWriter.println("            <param name=\"jnlp_href\" value=\"${JNLP.FILE}\"/>");
                    printWriter.println("        </applet>");
                    printWriter.println("        -->");
                } else if (JWSProjectProperties.DescType.application.equals((Object)descType)) {
                    printWriter.println("        <h3>Test page for launching the application via JNLP</h3>");
                    printWriter.println("        <script src=\"http://java.com/js/deployJava.js\"></script>");
                    printWriter.println("        <script>");
                    printWriter.println("            deployJava.createWebStartLaunchButton(\"${JNLP.FILE}\")");
                    printWriter.println("        </script>");
                    printWriter.println("        <!-- Or use the following link element to launch with the application -->");
                    printWriter.println("        <!--");
                    printWriter.println("        <a href=\"${JNLP.FILE}\">Launch the application</a>");
                    printWriter.println("        -->");
                }
                printWriter.println("    </body>");
                printWriter.println("</html>");
                printWriter.flush();
                printWriter.close();
                outputStream.close();
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }
}

