/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.editor.macros.storage.ui.MacrosModel;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.util.NbBundle;

public final class MacrosKeymapManager
extends KeymapManager {
    private MacrosModel model = null;
    private Map<String, Set<ShortcutAction>> macroActionsMap = null;
    private Map<ShortcutAction, Set<String>> macroShortcutsMap = null;

    public MacrosKeymapManager() {
        super(MacrosKeymapManager.class.getName());
    }

    public Map<String, Set<ShortcutAction>> getActions() {
        if (this.macroActionsMap == null) {
            List<MacrosModel.Macro> allMacrosList = this.getModel().getAllMacros();
            HashSet<MacrosModel.Macro> macroActions = new HashSet<MacrosModel.Macro>(allMacrosList.size());
            this.macroShortcutsMap = new HashMap<ShortcutAction, Set<String>>(allMacrosList.size());
            for (MacrosModel.Macro macro : allMacrosList) {
                macroActions.add(macro);
                HashSet<String> shortcuts = new HashSet<String>();
                for (MultiKeyBinding multiKeyBinding : macro.getShortcuts()) {
                    String shortcut = StorageSupport.keyStrokesToString((Collection)multiKeyBinding.getKeyStrokeList(), (boolean)true);
                    assert (shortcut != null);
                    shortcuts.add(shortcut);
                }
                if (shortcuts.size() <= 0) continue;
                this.macroShortcutsMap.put(macro, shortcuts);
            }
            this.macroActionsMap = new HashMap<String, Set<ShortcutAction>>();
            this.macroActionsMap.put(NbBundle.getMessage(MacrosKeymapManager.class, (String)"Macros_Keymap_Category"), macroActions);
        }
        return this.macroActionsMap;
    }

    public void refreshActions() {
        this.macroActionsMap = null;
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String profileName) {
        this.getActions();
        return this.macroShortcutsMap;
    }

    public Map<ShortcutAction, Set<String>> getDefaultKeymap(String profileName) {
        return this.getKeymap(profileName);
    }

    public void saveKeymap(String profileName, Map<ShortcutAction, Set<String>> actionToShortcuts) {
        for (ShortcutAction shortcutAction : actionToShortcuts.keySet()) {
            if (!(shortcutAction instanceof MacrosModel.Macro)) continue;
            MacrosModel.Macro macro = (MacrosModel.Macro)shortcutAction;
            Set<String> shortcuts = actionToShortcuts.get(shortcutAction);
            macro.setShortcuts(shortcuts);
        }
        this.getModel().save();
        this.macroActionsMap = null;
    }

    public List<String> getProfiles() {
        return null;
    }

    public String getCurrentProfile() {
        return null;
    }

    public void setCurrentProfile(String profileName) {
    }

    public void deleteProfile(String profileName) {
    }

    public boolean isCustomProfile(String profileName) {
        return false;
    }

    private MacrosModel getModel() {
        if (this.model == null) {
            this.model = MacrosModel.get();
            if (!this.model.isLoaded()) {
                this.model.load();
            }
        }
        return this.model;
    }
}

