/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.support.WebBeansModelSupport;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.el.JsfElExpression;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JsfHyperlinkProvider
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(final Document document, final int n) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        document.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(n);
                if (!tokenSequence.moveNext()) {
                    return;
                }
                TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
                if (tokenSequence2 == null) {
                    return;
                }
                tokenSequence2.move(n);
                if (!tokenSequence2.moveNext()) {
                    return;
                }
                atomicBoolean.set(tokenSequence2.token().id() == ELTokenId.IDENTIFIER);
            }
        });
        return atomicBoolean.get();
    }

    public int[] getHyperlinkSpan(final Document document, final int n) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        final WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return null;
        }
        final AtomicReference atomicReference = new AtomicReference();
        document.render(new Runnable(){

            @Override
            public void run() {
                BaseDocument baseDocument = (BaseDocument)document;
                JTextComponent jTextComponent = Utilities.getFocusedComponent();
                if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                    return;
                }
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                if (tokenSequence.move(n) == Integer.MAX_VALUE) {
                    return;
                }
                if (!tokenSequence.moveNext()) {
                    return;
                }
                TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
                if (tokenSequence2 != null) {
                    tokenSequence2.move(n);
                    if (!tokenSequence2.moveNext()) {
                        return;
                    }
                    final int n3 = tokenSequence2.offset() + tokenSequence2.token().length();
                    final int n2 = tokenSequence2.offset();
                    try {
                        final JsfElExpression jsfElExpression = new JsfElExpression(webModule, document, n3);
                        atomicReference.set(new Callable<int[]>(){

                            @Override
                            public int[] call() throws Exception {
                                int n = jsfElExpression.parse();
                                if (n == 100 || n == 1 || n == 102) {
                                    return new int[]{n2, n3};
                                }
                                return null;
                            }
                        });
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
        try {
            Callable callable = (Callable)atomicReference.get();
            return callable == null ? null : (int[])callable.call();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void performClickAction(final Document document, final int n) {
        final FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        final WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return;
        }
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != document) {
            return;
        }
        final AtomicReference atomicReference = new AtomicReference();
        document.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                if (tokenSequence.move(n) == Integer.MAX_VALUE) {
                    return;
                }
                if (!tokenSequence.moveNext()) {
                    return;
                }
                TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
                if (tokenSequence2 != null) {
                    tokenSequence2.move(n);
                    if (!tokenSequence2.moveNext()) {
                        return;
                    }
                    try {
                        int n2 = tokenSequence2.offset() + tokenSequence2.token().length();
                        final String string = ((Object)tokenSequence2.token().text()).toString();
                        final JsfElExpression jsfElExpression = new JsfElExpression(webModule, document, n2);
                        atomicReference.set(new Runnable(){

                            @Override
                            public void run() {
                                int n = jsfElExpression.parse();
                                if (n == 1) {
                                    new OpenConfigFile(fileObject, webModule, string).run();
                                    return;
                                }
                                if (!(n != 100 && n != 102 || jsfElExpression.gotoPropertyDeclaration(jsfElExpression.getBaseObjectClass()))) {
                                    String string2 = NbBundle.getBundle(JsfHyperlinkProvider.class).getString("MSG_source_not_found");
                                    StatusDisplayer.getDefault().setStatusText(string2);
                                    Toolkit.getDefaultToolkit().beep();
                                }
                            }
                        });
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
        Runnable runnable = (Runnable)atomicReference.get();
        if (runnable != null) {
            runnable.run();
        }
    }

    private static class OpenConfigFile
    implements Runnable {
        private String beanName;
        private WebModule wm;
        private FileObject mySource;

        OpenConfigFile(FileObject fileObject, WebModule webModule, String string) {
            this.beanName = string;
            this.wm = webModule;
            this.mySource = fileObject;
        }

        @Override
        public void run() {
            WebBeansModelSupport.WebBean webBean2;
            if (this.wm == null) {
                return;
            }
            List list = WebBeansModelSupport.getNamedBeans(JsfSupport.findFor(this.wm.getDocumentBase()).getWebBeansModel());
            for (WebBeansModelSupport.WebBean webBean2 : list) {
                if (!webBean2.getName().equals(this.beanName)) continue;
                JavaSource javaSource = JavaSource.create((ClasspathInfo)this.getClassPathInfo(), (FileObject[])new FileObject[0]);
                this.openElement(javaSource, webBean2.getBeanClassName());
                return;
            }
            FacesManagedBean facesManagedBean = ConfigurationUtils.findFacesManagedBean((WebModule)this.wm, (String)this.beanName);
            if (facesManagedBean == null) {
                return;
            }
            webBean2 = null;
            if (!(facesManagedBean instanceof ManagedBean)) {
                String string = facesManagedBean.getManagedBeanClass();
                JavaSource javaSource = JavaSource.create((ClasspathInfo)this.getClassPathInfo(), (FileObject[])new FileObject[0]);
                this.openElement(javaSource, string);
                return;
            }
            webBean2 = (FileObject)((ManagedBean)facesManagedBean).getModel().getModelSource().getLookup().lookup(FileObject.class);
            if (webBean2 != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)webBean2);
                    if (dataObject != null) {
                        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
                        if (editorCookie != null) {
                            Line line;
                            StyledDocument styledDocument = editorCookie.openDocument();
                            int[] nArray = JSFEditorUtilities.getManagedBeanDefinition((BaseDocument)((BaseDocument)styledDocument), (String)"managed-bean-name", (String)this.beanName);
                            int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)nArray[0]);
                            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
                            int n3 = n2 - nArray[0];
                            if (n != -1 && (line = lineCookie.getLineSet().getCurrent(n)) != null) {
                                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT, n3);
                            }
                            if (editCookie != null) {
                                editCookie.edit();
                            }
                        }
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        private void openElement(JavaSource javaSource, final String string) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                        if (typeElement == null) {
                            return;
                        }
                        ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)typeElement);
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private ClasspathInfo getClassPathInfo() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.mySource);
            return ClasspathInfo.create((ClassPath)OpenConfigFile.getClassPath(project, "classpath/boot"), (ClassPath)OpenConfigFile.getClassPath(project, "classpath/compile"), (ClassPath)OpenConfigFile.getClassPath(project, "classpath/source"));
        }

        private static ClassPath getClassPath(Project project, String string) {
            ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
            if (classPathProvider == null) {
                return null;
            }
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            if (sources == null) {
                return null;
            }
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            ClassPath[] classPathArray = new ClassPath[sourceGroupArray.length];
            int n = 0;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject = sourceGroup.getRootFolder();
                classPathArray[n] = classPathProvider.findClassPath(fileObject, string);
            }
            return ClassPathSupport.createProxyClassPath((ClassPath[])classPathArray);
        }
    }
}

