/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.reflect.Field;
import org.jcodings.Encoding;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import sun.misc.Unsafe;

public final class StringSupport {
    public static final int CR_MASK = 96;
    public static final int CR_UNKNOWN = 0;
    public static final int CR_7BIT = 32;
    public static final int CR_VALID = 64;
    public static final int CR_BROKEN = 96;
    public static final Object UNSAFE = StringSupport.getUnsafe();
    private static final int OFFSET = UNSAFE != null ? ((Unsafe)UNSAFE).arrayBaseOffset(byte[].class) : 0;
    private static final long NONASCII_MASK = -9187201950435737472L;
    private static final int LONG_SIZE = 8;
    private static final int LOWBITS = 7;

    private static Object getUnsafe() {
        try {
            Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
            Field f = sunUnsafe.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return Unsafe.class.cast(f.get(sunUnsafe));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int length(Encoding enc, byte[] bytes2, int p2, int end2) {
        int n = enc.length(bytes2, p2, end2);
        if (n > 0 && end2 - p2 >= n) {
            return n;
        }
        return end2 - p2 >= enc.minLength() ? enc.minLength() : end2 - p2;
    }

    public static int preciseLength(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (p2 >= end2) {
            return -2;
        }
        int n = enc.length(bytes2, p2, end2);
        if (n > end2 - p2) {
            return -1 - (n - (end2 - p2));
        }
        return n;
    }

    public static int searchNonAscii(byte[] bytes2, int p2, int end2) {
        while (p2 < end2) {
            if (!Encoding.isAscii(bytes2[p2])) {
                return p2;
            }
            ++p2;
        }
        return -1;
    }

    public static int searchNonAscii(ByteList bytes2) {
        return StringSupport.searchNonAscii(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static int codeRangeScan(Encoding enc, byte[] bytes2, int p2, int len) {
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.searchNonAscii(bytes2, p2, p2 + len) != -1 ? 64 : 32;
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.codeRangeScanAsciiCompatible(enc, bytes2, p2, len);
        }
        return StringSupport.codeRangeScanNonAsciiCompatible(enc, bytes2, p2, len);
    }

    private static int codeRangeScanAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int len) {
        int end2 = p2 + len;
        if ((p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) == -1) {
            return 32;
        }
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                return 96;
            }
            if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) != -1) continue;
            return 64;
        }
        return p2 > end2 ? 96 : 64;
    }

    private static int codeRangeScanNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int len) {
        int end2 = p2 + len;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                return 96;
            }
            p2 += cl;
        }
        return p2 > end2 ? 96 : 64;
    }

    public static int codeRangeScan(Encoding enc, ByteList bytes2) {
        return StringSupport.codeRangeScan(enc, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
    }

    public static long codeRangeScanRestartable(Encoding enc, byte[] bytes2, int s, int end2, int cr) {
        int p2;
        if (cr == 96) {
            return StringSupport.pack(end2 - s, cr);
        }
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.pack(end2 - s, StringSupport.searchNonAscii(bytes2, p2, end2) == -1 && cr != 64 ? 32 : 64);
        }
        if (enc.isAsciiCompatible()) {
            if ((p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) == -1) {
                return StringSupport.pack(end2 - s, cr != 64 ? 32 : cr);
            }
            while (p2 < end2) {
                int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (cl <= 0) {
                    return StringSupport.pack(p2 - s, cl == -1 ? 96 : 0);
                }
                if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) != -1) continue;
                return StringSupport.pack(end2 - s, 64);
            }
        } else {
            int cl;
            for (p2 = s; p2 < end2; p2 += cl) {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (cl > 0) continue;
                return StringSupport.pack(p2 - s, cl == -1 ? 96 : 0);
            }
        }
        return StringSupport.pack(p2 - s, p2 > end2 ? 96 : 64);
    }

    private static int countUtf8LeadBytes(long d) {
        d |= d >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        d >>>= 6;
        d &= 0x101010101010101L;
        d += d >>> 8;
        d += d >>> 16;
        d += d >>> 32;
        return (int)(d & 0xFL);
    }

    public static int utf8Length(byte[] bytes2, int p2, int end2) {
        int len = 0;
        if (UNSAFE != null && end2 - p2 > 16) {
            int ep = 0xFFFFFFF8 & p2 + 7;
            while (p2 < ep) {
                if ((bytes2[p2++] & 0xC0) == 128) continue;
                ++len;
            }
            Unsafe us = (Unsafe)UNSAFE;
            int eend = 0xFFFFFFF8 & end2;
            while (p2 < eend) {
                len += StringSupport.countUtf8LeadBytes(us.getLong(bytes2, OFFSET + p2));
                p2 += 8;
            }
        }
        while (p2 < end2) {
            if ((bytes2[p2++] & 0xC0) == 128) continue;
            ++len;
        }
        return len;
    }

    public static int utf8Length(ByteList bytes2) {
        return StringSupport.utf8Length(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static int strLength(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            int c = 0;
            while (p2 < end2) {
                if (Encoding.isAscii(bytes2[p2])) {
                    int q = StringSupport.searchNonAscii(bytes2, p2, end2);
                    if (q == -1) {
                        return c + (end2 - p2);
                    }
                    c += q - p2;
                    p2 = q;
                }
                p2 += StringSupport.length(enc, bytes2, p2, end2);
                ++c;
            }
            return c;
        }
        int c = 0;
        while (end2 > p2) {
            p2 += StringSupport.length(enc, bytes2, p2, end2);
            ++c;
        }
        return c;
    }

    public static int strLength(ByteList bytes2) {
        return StringSupport.strLength(bytes2.getEncoding(), bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long strLengthWithCodeRange(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.strLengthWithCodeRangeAsciiCompatible(enc, bytes2, p2, end2);
        }
        return StringSupport.strLengthWithCodeRangeNonAsciiCompatible(enc, bytes2, p2, end2);
    }

    private static long strLengthWithCodeRangeAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2) {
        int cr = 0;
        int c = 0;
        while (p2 < end2) {
            int cl;
            if (Encoding.isAscii(bytes2[p2])) {
                int q = StringSupport.searchNonAscii(bytes2, p2, end2);
                if (q == -1) {
                    return StringSupport.pack(c + (end2 - p2), cr == 0 ? 32 : cr);
                }
                c += q - p2;
                p2 = q;
            }
            if ((cl = StringSupport.preciseLength(enc, bytes2, p2, end2)) > 0) {
                cr |= 0x40;
                p2 += cl;
            } else {
                cr = 96;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 32 : cr);
    }

    private static long strLengthWithCodeRangeNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2) {
        int cr = 0;
        int c = 0;
        c = 0;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl > 0) {
                cr |= 0x40;
                p2 += cl;
            } else {
                cr = 96;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 32 : cr);
    }

    public static long strLengthWithCodeRange(ByteList bytes2) {
        return StringSupport.strLengthWithCodeRange(bytes2.getEncoding(), bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long strLengthWithCodeRange(ByteList bytes2, Encoding enc) {
        return StringSupport.strLengthWithCodeRange(enc, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    static long pack(int result, int arg2) {
        return (long)arg2 << 31 | (long)result;
    }

    public static int unpackResult(long len) {
        return (int)len & Integer.MAX_VALUE;
    }

    public static int unpackArg(long cr) {
        return (int)(cr >>> 31);
    }

    public static int codePoint(Ruby runtime2, Encoding enc, byte[] bytes2, int p2, int end2) {
        if (p2 >= end2) {
            throw runtime2.newArgumentError("empty string");
        }
        int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (cl <= 0) {
            throw runtime2.newArgumentError("invalid byte sequence in " + enc);
        }
        return enc.mbcToCode(bytes2, p2, end2);
    }

    public static int codeLength(Ruby runtime2, Encoding enc, int c) {
        int n = enc.codeToMbcLength(c);
        if (n == 0) {
            throw runtime2.newArgumentError("invalid codepoint " + String.format("0x%x in ", c) + enc.getName());
        }
        return n;
    }

    public static long getAscii(Encoding enc, byte[] bytes2, int p2, int end2) {
        return StringSupport.getAscii(enc, bytes2, p2, end2, 0);
    }

    public static long getAscii(Encoding enc, byte[] bytes2, int p2, int end2, int len) {
        if (p2 >= end2) {
            return StringSupport.pack(-1, len);
        }
        if (enc.isAsciiCompatible()) {
            int c = bytes2[p2] & 0xFF;
            if (!Encoding.isAscii(c)) {
                StringSupport.pack(-1, len);
            }
            return StringSupport.pack(c, len == 0 ? 0 : 1);
        }
        int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (cl <= 0) {
            return StringSupport.pack(-1, len);
        }
        int c = enc.mbcToCode(bytes2, p2, end2);
        if (!Encoding.isAscii(c)) {
            return StringSupport.pack(-1, len);
        }
        return StringSupport.pack(c, len == 0 ? 0 : cl);
    }

    public static int preciseCodePoint(Encoding enc, byte[] bytes2, int p2, int end2) {
        int l = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (l > 0) {
            enc.mbcToCode(bytes2, p2, end2);
        }
        return -1;
    }

    public static int utf8Nth(byte[] bytes2, int p2, int end2, int n) {
        if (UNSAFE != null && n > 16) {
            int ep = 0xFFFFFFF8 & p2 + 7;
            while (p2 < ep) {
                if ((bytes2[p2++] & 0xC0) == 128) continue;
                --n;
            }
            Unsafe us = (Unsafe)UNSAFE;
            int eend = 0xFFFFFFF8 & end2;
            while ((p2 += 8) < eend && (n -= StringSupport.countUtf8LeadBytes(us.getLong(bytes2, OFFSET + p2))) >= 8) {
            }
        }
        while (p2 < end2 && ((bytes2[p2] & 0xC0) == 128 || n-- != 0)) {
            ++p2;
        }
        return p2;
    }

    public static int nth(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        p2 = enc.isSingleByte() ? (p2 += n) : (enc.isFixedWidth() ? (p2 += n * enc.maxLength()) : (enc.isAsciiCompatible() ? StringSupport.nthAsciiCompatible(enc, bytes2, p2, end2, n) : StringSupport.nthNonAsciiCompatible(enc, bytes2, p2, end2, n)));
        return p2 > end2 ? end2 : p2;
    }

    private static int nthAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        while (p2 < end2 && n > 0) {
            int end22 = p2 + n;
            if (end2 < end22) {
                return end2;
            }
            if (Encoding.isAscii(bytes2[p2])) {
                int p22 = StringSupport.searchNonAscii(bytes2, p2, end22);
                if (p22 == -1) {
                    return end22;
                }
                n -= p22 - p2;
                p2 = p22;
            }
            int cl = StringSupport.length(enc, bytes2, p2, end2);
            p2 += cl;
            --n;
        }
        return n != 0 ? end2 : p2;
    }

    private static int nthNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        while (p2 < end2 && n-- != 0) {
            p2 += StringSupport.length(enc, bytes2, p2, end2);
        }
        return p2;
    }

    public static int utf8Offset(byte[] bytes2, int p2, int end2, int n) {
        int pp = StringSupport.utf8Nth(bytes2, p2, end2, n);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int offset(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        int pp = StringSupport.nth(enc, bytes2, p2, end2, n);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int toLower(Encoding enc, int c) {
        return Encoding.isAscii(c) ? AsciiTables.ToLowerCaseTable[c] : c;
    }

    public static int toUpper(Encoding enc, int c) {
        return Encoding.isAscii(c) ? AsciiTables.ToUpperCaseTable[c] : c;
    }

    public static int caseCmp(byte[] bytes1, int p1, byte[] bytes2, int p2, int len) {
        int i = -1;
        while (++i < len && bytes1[p1 + i] == bytes2[p2 + i]) {
        }
        if (i < len) {
            return (bytes1[p1 + i] & 0xFF) > (bytes2[p2 + i] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public static int scanHex(byte[] bytes2, int p2, int len) {
        return StringSupport.scanHex(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int scanHex(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isXDigit(c = bytes2[p2++] & 0xFF)) {
            v = (v << 4) + enc.xdigitVal(c);
        }
        return v;
    }

    public static int hexLength(byte[] bytes2, int p2, int len) {
        return StringSupport.hexLength(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int hexLength(byte[] bytes2, int p2, int len, Encoding enc) {
        int hlen = 0;
        while (len-- > 0 && enc.isXDigit(bytes2[p2++] & 0xFF)) {
            ++hlen;
        }
        return hlen;
    }

    public static int scanOct(byte[] bytes2, int p2, int len) {
        return StringSupport.scanOct(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int scanOct(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isDigit(c = bytes2[p2++] & 0xFF) && c < 56) {
            v = (v << 3) + Encoding.digitVal(c);
        }
        return v;
    }

    public static int octLength(byte[] bytes2, int p2, int len) {
        return StringSupport.octLength(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int octLength(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int olen = 0;
        while (len-- > 0 && enc.isDigit(c = bytes2[p2++] & 0xFF) && c < 56) {
            ++olen;
        }
        return olen;
    }
}

