/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.parser.EvalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class PersistentLocalVariable
extends AbstractVariable {
    private static String pattern = "([a-z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(Ruby runtime2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new PersistentLocalVariable(runtime2, name2, javaObject);
        }
        return null;
    }

    private PersistentLocalVariable(Ruby runtime2, String name2, Object ... javaObject) {
        super(runtime2, name2, javaObject);
    }

    PersistentLocalVariable(IRubyObject origin, String name2, IRubyObject irubyObject) {
        super(origin, name2, irubyObject);
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.LocalVariable;
    }

    public static boolean isValidName(Object name2) {
        return PersistentLocalVariable.isValidName(pattern, name2);
    }

    public static void retrieve(Ruby runtime2, IRubyObject receiver2, BiVariableMap vars) {
        ManyVarsDynamicScope scope = (ManyVarsDynamicScope)runtime2.getCurrentContext().getCurrentScope();
        if (scope == null) {
            return;
        }
        String[] names2 = scope.getAllNamesInScope();
        IRubyObject[] values = scope.getValues();
        if (names2 == null || values == null || names2.length == 0 || values.length == 0) {
            return;
        }
        for (int i = 0; i < names2.length; ++i) {
            BiVariable v = vars.getVariable(names2[i]);
            if (v != null) {
                v.setRubyObject(values[i]);
                continue;
            }
            v = new PersistentLocalVariable(receiver2, names2[i], values[i]);
            vars.update(names2[i], v);
        }
    }

    public void inject(Ruby runtime2, IRubyObject receiver2) {
    }

    public void remove(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        try {
            DynamicScope currentScope = context.getCurrentScope();
            ManyVarsDynamicScope scope = (ManyVarsDynamicScope)context.getCurrentScope();
            scope = new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope()), currentScope);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

