/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.connector;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.installer.downloader.connector.MyProxy;
import org.netbeans.installer.downloader.connector.MyProxyType;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.xml.DomExternalizable;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.DomVisitor;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyProxySelector
extends ProxySelector
implements DomExternalizable {
    private final Map<MyProxyType, MyProxy> proxies = new HashMap<MyProxyType, MyProxy>();
    private transient Set<String> byPassSet = new HashSet<String>();
    public static final String ERROR_URI_CANNOT_BE_NULL_KEY = "MPS.error.uri.cannot.be.null";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String FTP_SCHEME = "ftp";

    public void add(MyProxy proxy) {
        this.proxies.put(proxy.type, proxy);
    }

    public void remove(MyProxyType type) {
        this.proxies.remove((Object)type);
    }

    public MyProxy getForType(MyProxyType type) {
        return this.proxies.get((Object)type);
    }

    public void addByPassHost(String host) {
        this.byPassSet.add(host);
    }

    public void clearByPassList() {
        this.byPassSet.clear();
    }

    public String[] getByPass() {
        return this.byPassSet.toArray(new String[0]);
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(ResourceUtils.getString(MyProxySelector.class, ERROR_URI_CANNOT_BE_NULL_KEY));
        }
        Proxy proxy = Proxy.NO_PROXY;
        if (this.byPassSet.contains(uri.getHost())) {
            return Collections.singletonList(proxy);
        }
        if (HTTP_SCHEME.equalsIgnoreCase(uri.getScheme()) || HTTPS_SCHEME.equalsIgnoreCase(uri.getScheme())) {
            if (this.proxies.containsKey((Object)MyProxyType.HTTP)) {
                proxy = this.proxies.get((Object)MyProxyType.HTTP).getProxy();
            }
        } else if (FTP_SCHEME.equalsIgnoreCase(uri.getScheme())) {
            if (this.proxies.containsKey((Object)MyProxyType.FTP)) {
                proxy = this.proxies.get((Object)MyProxyType.FTP).getProxy();
            }
        } else if (this.proxies.containsKey((Object)MyProxyType.SOCKS)) {
            proxy = this.proxies.get((Object)MyProxyType.SOCKS).getProxy();
        }
        return Collections.singletonList(proxy);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public void readXML(Element element) {
        RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

            public void visit(Element element) {
                if ("proxy".equals(element.getNodeName())) {
                    MyProxy proxy = new MyProxy();
                    proxy.readXML(element);
                    MyProxySelector.this.add(proxy);
                } else {
                    super.visit(element);
                }
            }
        };
        ((DomVisitor)visitor).visit(element);
    }

    @Override
    public Element writeXML(Document document) {
        Element root = document.createElement("selector-proxies");
        for (MyProxy proxy : this.proxies.values()) {
            DomUtil.addChild(root, proxy);
        }
        return root;
    }
}

