/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.options.BugzillaOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class BugzillaOptionsController
extends OptionsPanelController
implements DocumentListener {
    private final BugzillaOptionsPanel panel;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean valid = false;

    public BugzillaOptionsController() {
        this.panel = new BugzillaOptionsPanel();
    }

    public void update() {
        this.panel.issuesTextField.getDocument().removeDocumentListener(this);
        this.panel.queriesTextField.getDocument().removeDocumentListener(this);
        this.panel.issuesTextField.setText(BugzillaConfig.getInstance().getIssueRefreshInterval() + "");
        this.panel.queriesTextField.setText(BugzillaConfig.getInstance().getQueryRefreshInterval() + "");
        this.panel.issuesTextField.getDocument().addDocumentListener(this);
        this.panel.queriesTextField.getDocument().addDocumentListener(this);
    }

    public void applyChanges() {
        String queryRefresh = this.panel.queriesTextField.getText().trim();
        int r = queryRefresh.equals("") ? 0 : Integer.parseInt(queryRefresh);
        BugzillaConfig.getInstance().setQueryRefreshInterval(r);
        String issueRefresh = this.panel.issuesTextField.getText().trim();
        r = issueRefresh.equals("") ? 0 : Integer.parseInt(issueRefresh);
        BugzillaConfig.getInstance().setIssueRefreshInterval(r);
    }

    public void cancel() {
        this.update();
    }

    public boolean isValid() {
        this.validate(false);
        return this.valid;
    }

    private boolean isValidRefreshValue(String s) {
        if (!s.equals("")) {
            try {
                int i = Integer.parseInt(s);
                if (i < 5) {
                    this.panel.errorLabel.setText(NbBundle.getMessage(BugzillaOptionsController.class, (String)"MSG_MUST_BE_GREATER_THEN_5"));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.panel.errorLabel.setText(NbBundle.getMessage(BugzillaOptionsController.class, (String)"MSG_INVALID_VALUE"));
                return false;
            }
        }
        return true;
    }

    public boolean isChanged() {
        return !this.panel.issuesTextField.getText().trim().equals(BugzillaConfig.getInstance().getIssueRefreshInterval() + "") || !this.panel.queriesTextField.getText().trim().equals(BugzillaConfig.getInstance().getQueryRefreshInterval() + "");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validate(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validate(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validate(true);
    }

    private void validate(boolean fireEvents) {
        boolean oldValid = this.valid;
        this.panel.errorLabel.setVisible(false);
        this.panel.errorLabel.setText("");
        String queryRefresh = this.panel.queriesTextField.getText().trim();
        String issueRefresh = this.panel.issuesTextField.getText().trim();
        this.valid = this.isValidRefreshValue(queryRefresh) && this.isValidRefreshValue(issueRefresh);
        this.panel.errorLabel.setVisible(!this.valid);
        if (fireEvents && oldValid != this.valid) {
            this.support.firePropertyChange(new PropertyChangeEvent(this, "valid", oldValid, this.valid));
        }
    }
}

