/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignJarsTask
extends Task {
    private static final String SIG_START = "META-INF/";
    private static final String SIG_END = ".SF";
    private int compIndex = 1;
    private String keystore;
    private String storepass;
    private String keypass;
    private String alias;
    private File mainJar;
    private File destDir;
    private String codebase;
    private String compProp;
    private String signedJarsProp;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setKeystore(String s) {
        this.keystore = s;
    }

    public void setStorepass(String s) {
        this.storepass = s;
    }

    public void setKeypass(String s) {
        this.keypass = s;
    }

    public void setAlias(String s) {
        this.alias = s;
    }

    public void setMainjar(File f) {
        this.mainJar = f;
    }

    public void setDestdir(File f) {
        this.destDir = f;
    }

    public void setCodebase(String s) {
        this.codebase = s;
    }

    public void setComponentsprop(String s) {
        this.compProp = s;
    }

    public void setSignedjarsprop(String s) {
        this.signedJarsProp = s;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        HashMap signersMap = new HashMap();
        ArrayList<File> files2sign = new ArrayList<File>();
        ArrayList<File> alreadySigned = new ArrayList<File>();
        for (FileSet fs : this.filesets) {
            String[] files;
            File dir = fs.getDir(this.getProject());
            if (!dir.exists()) continue;
            this.log("Processing FileSet: " + fs, 3);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String f : files = ds.getIncludedFiles()) {
                try {
                    File fl = new File(basedir, f);
                    Set<String> sgs = SignJarsTask.getSignatures(fl);
                    if (sgs.size() == 0) {
                        files2sign.add(fl);
                        continue;
                    }
                    if (sgs.size() == 1 && sgs.contains(this.alias.toUpperCase())) {
                        alreadySigned.add(fl);
                        continue;
                    }
                    List lst = (List)signersMap.get(sgs);
                    if (lst != null) {
                        lst.add(fl);
                        continue;
                    }
                    ArrayList<File> nlst = new ArrayList<File>();
                    nlst.add(fl);
                    signersMap.put(sgs, nlst);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex, this.getLocation());
                }
            }
        }
        this.log("Files to be signed: " + this.mainJar.toString() + ", " + ((Object)files2sign).toString(), 3);
        this.log("Files already signed by requested alias: " + ((Object)alreadySigned).toString(), 3);
        StringBuilder signedJarsBuilder = new StringBuilder();
        SignJar signJar = (SignJar)this.getProject().createTask("signjar");
        signJar.setLocation(this.getLocation());
        signJar.setKeystore(this.keystore);
        signJar.setStorepass(this.storepass);
        signJar.setKeypass(this.keypass);
        signJar.setAlias(this.alias);
        signJar.init();
        this.log("Signing main jar file: " + this.mainJar, 3);
        signJar.setJar(this.mainJar);
        signJar.execute();
        if (files2sign.size() > 0) {
            for (File f : files2sign) {
                this.log("Signing file: " + f, 3);
                signJar.setJar(f);
                signJar.execute();
                signedJarsBuilder.append("\n        <jar href=\"lib/" + f.getName() + "\" download=\"eager\"/>");
            }
        }
        if (alreadySigned.size() > 0) {
            for (File f : alreadySigned) {
                this.log("Adding signed file: " + f, 3);
                signedJarsBuilder.append("\n        <jar href=\"lib/" + f.getName() + "\" download=\"eager\"/>");
            }
        }
        this.getProject().setProperty(this.signedJarsProp, signedJarsBuilder.toString());
        StringBuilder compsBuilder = new StringBuilder();
        for (Map.Entry entry : signersMap.entrySet()) {
            this.log("Already signed: keystore aliases = " + entry.getKey() + " -> signed jars = " + entry.getValue(), 3);
            String compName = "jnlpcomponent" + this.compIndex++;
            this.createJNLPComponentFile((Set)entry.getKey(), (List)entry.getValue(), compName);
            compsBuilder.append("\n        <extension name=\"" + compName + "\" href=\"" + compName + ".jnlp\"/>");
        }
        this.getProject().setProperty(this.compProp, compsBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getSignatures(File f) throws IOException {
        ZipFile jarFile = null;
        HashSet<String> signatures = new HashSet<String>(3);
        try {
            jarFile = new ZipFile(f);
            Enumeration<? extends ZipEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry je = en.nextElement();
                if (je.isDirectory() || !je.getName().startsWith(SIG_START) || !je.getName().endsWith(SIG_END)) continue;
                String sigName = je.getName().substring(SIG_START.length(), je.getName().indexOf(SIG_END));
                signatures.add(sigName);
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        return signatures;
    }

    private String createJNLPComponentFile(Set<String> aliases, List<File> jars, String compName) {
        File f = new File(this.destDir, compName + ".jnlp");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(f);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe, this.getLocation());
        }
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<jnlp spec=\"1.0+\" codebase=\"" + this.codebase + "\">");
        writer.println("    <information>");
        writer.println("        <title>" + compName + "</title>");
        writer.println("        <vendor>" + this.concatSet(aliases) + "</vendor>");
        writer.println("    </information>");
        writer.println("    <security>");
        writer.println("        <all-permissions/>");
        writer.println("    </security>");
        writer.println("    <resources>");
        Iterator<File> iter = jars.iterator();
        while (iter.hasNext()) {
            writer.println("        <jar href=\"" + this.getPath(this.destDir.getAbsolutePath(), iter.next().getAbsolutePath()) + "\" download=\"eager\"/>");
        }
        writer.println("    </resources>");
        writer.println("    <component-desc/>");
        writer.println("</jnlp>");
        writer.flush();
        writer.close();
        return f.getAbsolutePath();
    }

    private String getPath(String dirPath, String filePath) {
        String retVal = null;
        if (filePath.indexOf(dirPath) != -1) {
            retVal = filePath.substring(dirPath.length() + 1).replace('\\', '/');
        }
        return retVal;
    }

    private String concatSet(Set<String> s) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator<String> iter = s.iterator();
        while (iter.hasNext()) {
            if (first) {
                sb.append((Object)iter.next());
                continue;
            }
            sb.append(", " + iter.next());
        }
        return sb.toString();
    }
}

