/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.core.NbAuthenticatorPanel;
import org.netbeans.core.ProxySettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class NbAuthenticator
extends Authenticator {
    private static final long TIMEOUT = 3000L;
    private static long lastTry = 0L;

    NbAuthenticator() {
        Preferences proxySettingsNode = NbPreferences.root().node("/org/netbeans/core");
        assert (proxySettingsNode != null);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Logger.getLogger(NbAuthenticator.class.getName()).log(Level.FINER, "Authenticator.getPasswordAuthentication() with prompt " + this.getRequestingPrompt());
        if (Authenticator.RequestorType.PROXY == this.getRequestorType() && ProxySettings.useAuthentication()) {
            Logger.getLogger(NbAuthenticator.class.getName()).log(Level.FINER, "Username set to " + ProxySettings.getAuthenticationUsername() + " while request " + this.getRequestingURL());
            return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
        }
        if (System.currentTimeMillis() - lastTry > 3000L) {
            if (this.getRequestingProtocol().startsWith("SOCKS") && ProxySettings.getAuthenticationUsername().length() > 0) {
                return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
            }
            NbAuthenticatorPanel ui = new NbAuthenticatorPanel(this.getRequestingPrompt());
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)ui, NbBundle.getMessage(NbAuthenticator.class, (String)"CTL_Authentication")));
            if (DialogDescriptor.OK_OPTION == result) {
                lastTry = 0L;
                return new PasswordAuthentication(ui.getUserName(), ui.getPassword());
            }
            lastTry = System.currentTimeMillis();
        }
        Logger.getLogger(NbAuthenticator.class.getName()).log(Level.WARNING, "No authentication set while requesting " + this.getRequestingURL());
        return null;
    }
}

