/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import org.netbeans.modules.dlight.core.ui.components.DLightIndicatorsTopComponent;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.ui.spi.IndicatorComponentDelegator;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.util.UIThread;

public final class DLightIndicatorDelegator
implements IndicatorComponentDelegator {
    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        if (oldSession == newSession) {
            return;
        }
        if (oldSession != null) {
            oldSession.removeSessionStateListener((SessionStateListener)this);
        }
        if (newSession == null) {
            return;
        }
        if (newSession != null) {
            newSession.addSessionStateListener((SessionStateListener)this);
        }
    }

    public void sessionStateChanged(final DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        if (newState == DLightSession.SessionState.STARTING) {
            if (!this.needToHandle(session)) {
                session.removeSessionStateListener((SessionStateListener)this);
                return;
            }
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    DLightIndicatorsTopComponent indicators = DLightIndicatorsTopComponent.findInstance();
                    indicators.setSession(session);
                    indicators.open();
                    indicators.requestActive();
                }
            });
        }
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
    }

    private boolean needToHandle(DLightSession session) {
        if (session == null) {
            return false;
        }
        ServiceInfoDataStorage serviceInfoStorage = session.getServiceInfoDataStorage();
        return serviceInfoStorage != null && serviceInfoStorage.getValue("service.storage.dlight.run") != null;
    }
}

