/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.IOException;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public final class BinaryExecSupport
extends ExecutionSupport {
    private static final String PROP_RUN_DIRECTORY = "rundirectory";

    public BinaryExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    @Override
    public void addProperties(Sheet.Set set) {
        set.put(this.createRunDirectoryProperty());
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, this.getString("PROP_RUN_DIRECTORY"), this.getString("HINT_RUN_DIRECTORY")){

            public String getValue() {
                return BinaryExecSupport.this.getRunDirectory();
            }

            public void setValue(String val) {
                BinaryExecSupport.this.setRunDirectory(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return BinaryExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private String getString(String s) {
        return NbBundle.getBundle(BinaryExecSupport.class).getString(s);
    }
}

