/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class NewCndFileChooserPanelGUI
extends CndPanelGUI
implements ActionListener {
    private final Logger logger = Logger.getLogger("cnd.editor.filecreation");
    private final String defaultExtension;
    private String expectedExtension;
    private final MIMEExtensions es;
    private final boolean fileWithoutExtension;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JComboBox cbExtension;
    private JCheckBox cbSetAsDefault;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    NewCndFileChooserPanelGUI(Project project, SourceGroup[] folders, Component bottomPanel, MIMEExtensions es, String defaultExt) {
        super(project, folders);
        this.es = es;
        this.fileWithoutExtension = "".equals(defaultExt);
        this.initComponents();
        this.initMnemonics();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.defaultExtension = defaultExt;
        this.initValues(null, null, null);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    @Override
    public void initValues(FileObject template, FileObject preselectedFolder, String documentName) {
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "sources is {0}", sources);
        }
        this.folders = sources.getSourceGroups("generic");
        if (this.logger.isLoggable(Level.FINE)) {
            for (int i = 0; i < this.folders.length; ++i) {
                this.logger.log(Level.FINE, "folders[{0}] = {1}", new Object[]{i, this.folders[i]});
            }
        }
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = NewCndFileChooserPanelGUI.getPreselectedGroup(this.folders, preselectedFolder);
        this.locationComboBox.setSelectedItem(preselectedGroup);
        this.folderTextField.setText(NewCndFileChooserPanelGUI.getRelativeNativeName(preselectedGroup.getRootFolder(), preselectedFolder));
        String ext = this.defaultExtension == null ? this.es.getDefaultExtension() : this.defaultExtension;
        this.cbExtension.setSelectedItem(ext);
        this.cbExtension.enableInputMethods(true);
        this.expectedExtension = ext;
        Component editorComp = this.cbExtension.getEditor().getEditorComponent();
        if (editorComp instanceof JTextField) {
            ((JTextField)editorComp).getDocument().addDocumentListener(new DocumentListener(){

                private void update(Document doc) {
                    try {
                        NewCndFileChooserPanelGUI.this.expectedExtension = doc.getText(0, doc.getLength());
                        NewCndFileChooserPanelGUI.this.updateCreatedFile();
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update(e.getDocument());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update(e.getDocument());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update(e.getDocument());
                }
            });
        }
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        if (template != null) {
            if (documentName == null) {
                FileObject currentFolder;
                String baseName;
                documentName = baseName = NEW_FILE_PREFIX + template.getName();
                FileObject fileObject = currentFolder = preselectedFolder != null ? preselectedFolder : this.getTargetGroup().getRootFolder();
                if (currentFolder != null) {
                    FileObject _tmp;
                    int index = 0;
                    while ((_tmp = currentFolder.getFileObject(documentName, ext)) != null) {
                        documentName = baseName + ++index;
                    }
                }
            }
            this.documentNameTextField.setText(documentName);
            this.documentNameTextField.selectAll();
        }
    }

    @Override
    public SourceGroup getTargetGroup() {
        Object selectedItem = this.locationComboBox.getSelectedItem();
        if (selectedItem == null && (selectedItem = this.locationComboBox.getItemAt(this.locationComboBox.getSelectedIndex())) == null) {
            selectedItem = this.locationComboBox.getItemAt(0);
        }
        return (SourceGroup)selectedItem;
    }

    @Override
    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    @Override
    public String getTargetName() {
        String documentName = this.documentNameTextField.getText().trim();
        if (documentName.length() == 0) {
            return null;
        }
        String docExt = FileUtil.getExtension((String)documentName);
        if (docExt.length() == 0 && this.expectedExtension.length() > 0) {
            documentName = documentName + '.' + this.expectedExtension;
        } else assert (docExt.equals(this.expectedExtension));
        return documentName;
    }

    public String getTargetExtension() {
        return this.expectedExtension;
    }

    public boolean useTargetExtensionAsDefault() {
        return this.cbSetAsDefault.isSelected();
    }

    @Override
    protected void updateCreatedFile() {
        if (this.fileWithoutExtension && this.getTargetExtension().length() == 0 || this.es.getDefaultExtension().equals(this.getTargetExtension())) {
            this.cbSetAsDefault.setEnabled(false);
        } else {
            this.cbSetAsDefault.setEnabled(true);
        }
        FileObject root = this.getTargetGroup().getRootFolder();
        String folderName = this.folderTextField.getText().trim();
        String documentName = this.documentNameTextField.getText().trim();
        String docExt = FileUtil.getExtension((String)documentName);
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/") + documentName;
        if (docExt.length() == 0) {
            this.cbExtension.setEnabled(true);
            createdFileName = createdFileName + "." + this.expectedExtension;
        } else {
            this.cbExtension.setEnabled(false);
            this.cbExtension.setSelectedItem(docExt);
            this.expectedExtension = docExt;
        }
        createdFileName = createdFileName.replace('/', File.separatorChar);
        if (!createdFileName.equals(this.fileTextField.getText())) {
            this.fileTextField.setText(createdFileName);
            this.changeSupport.fireChange();
        }
    }

    private DefaultComboBoxModel getExtensionsCBModel() {
        Vector vExt = new Vector(this.es.getValues());
        return new DefaultComboBoxModel(vExt);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.cbExtension = new JComboBox();
        this.cbSetAsDefault = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_ClassName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_documentNameTextField"));
        this.jLabel5.setLabelFor(this.cbExtension);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_Extension_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.cbExtension.setEditable(true);
        this.cbExtension.setModel(this.getExtensionsCBModel());
        this.cbExtension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCndFileChooserPanelGUI.this.cbExtensionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.jPanel1.add((Component)this.cbExtension, gridBagConstraints);
        this.cbExtension.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"AD_ExtensionTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSetAsDefault, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"ACSD_SetAsDefaultCheckBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel1.add((Component)this.cbSetAsDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 4, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_locationComboBox"));
        this.jLabel2.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_browseButton"));
        this.jLabel4.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(NewCndFileChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndFileChooserPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void initMnemonics() {
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_FileName_Label_Mnemonic").charAt(0));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Extension_Label_Mnemonic").charAt(0));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Project_Label_Mnemonic").charAt(0));
        this.locationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Location_Label_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Folder_Label_Mnemonic").charAt(0));
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Browse_Button_Mnemonic").charAt(0));
        this.jLabel4.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
    }

    private void cbExtensionActionPerformed(ActionEvent evt) {
        this.expectedExtension = (String)this.cbExtension.getSelectedItem();
        this.updateCreatedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            SourceGroup group = this.getTargetGroup();
            fo = BrowseFolders.showDialog(new SourceGroup[]{group}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == e.getSource()) {
            this.updateCreatedFile();
        } else if (this.cbExtension.getEditor() == e.getSource()) {
            this.expectedExtension = (String)this.cbExtension.getEditor().getItem();
            this.updateCreatedFile();
        }
    }
}

