/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.widget.Widget;

public class GridGraphLayoutUtility {
    public static <N, E, P> void performLayout(GraphPinScene<N, E, P> graph, boolean checker, int horizontalGap, int verticalGap) {
        int i;
        Point grid;
        Collection allNodes = graph.getNodes();
        HashSet unresolvedNodes = new HashSet(allNodes);
        final HashMap node2connected = new HashMap();
        for (Object node : unresolvedNodes) {
            HashSet connected = new HashSet();
            for (Object edge : graph.getEdges()) {
                Object pinTarget;
                Object pinSource = graph.getEdgeSource(edge);
                if (graph.getPinNode(pinSource).equals(node)) {
                    connected.add(node);
                }
                if (!graph.getPinNode(pinTarget = graph.getEdgeTarget(edge)).equals(node)) continue;
                connected.add(node);
            }
            node2connected.put(node, connected);
        }
        LinkedList queue = new LinkedList();
        HashMap node2grid = new HashMap();
        Rectangle gridBounds = new Rectangle();
        block2: while (true) {
            Object node;
            Object e = node = queue.isEmpty() ? GridGraphLayoutUtility.findNodeWithMaxEdges(unresolvedNodes, node2connected) : queue.poll();
            if (node == null) break;
            unresolvedNodes.remove(node);
            Point center = (Point)node2grid.get(node);
            if (center == null) {
                center = GridGraphLayoutUtility.findCenter(node2grid, checker);
                node2grid.put(node, center);
                gridBounds.add(center);
            }
            Point index = new Point();
            ArrayList connected = new ArrayList((Collection)node2connected.get(node));
            Collections.sort(connected, new Comparator<N>(){

                @Override
                public int compare(N node1, N node2) {
                    return ((Collection)node2connected.get(node1)).size() - ((Collection)node2connected.get(node2)).size();
                }
            });
            Iterator i$ = connected.iterator();
            while (true) {
                if (!i$.hasNext()) continue block2;
                Object conn = i$.next();
                if (unresolvedNodes.contains(conn)) {
                    queue.offer(conn);
                }
                if (node2grid.containsKey(conn)) continue;
                grid = GridGraphLayoutUtility.resolvePoint(node2grid, center, index, checker);
                node2grid.put(conn, grid);
                gridBounds.add(grid);
            }
            break;
        }
        int[] xAxis = new int[gridBounds.width + 1];
        int[] yAxis = new int[gridBounds.height + 1];
        for (Object node : allNodes) {
            Rectangle bounds;
            Widget widget = graph.findWidget(node);
            if (widget == null || (bounds = widget.getBounds()) == null) continue;
            grid = (Point)node2grid.get(node);
            xAxis[grid.x - gridBounds.x] = Math.max(xAxis[grid.x - gridBounds.x], bounds.width);
            yAxis[grid.y - gridBounds.y] = Math.max(yAxis[grid.y - gridBounds.y], bounds.height);
        }
        int pos = horizontalGap / 2;
        for (i = 0; i < xAxis.length; ++i) {
            int add = xAxis[i];
            xAxis[i] = pos;
            pos += add + horizontalGap;
        }
        pos = verticalGap / 2;
        for (i = 0; i < yAxis.length; ++i) {
            int add = yAxis[i];
            yAxis[i] = pos;
            pos += add + verticalGap;
        }
        for (Object node : allNodes) {
            Rectangle bounds;
            Widget widget = graph.findWidget(node);
            if (widget == null || (bounds = widget.getBounds()) == null) continue;
            Point grid2 = (Point)node2grid.get(node);
            widget.setPreferredLocation(new Point(xAxis[grid2.x - gridBounds.x] - bounds.x, yAxis[grid2.y - gridBounds.y]));
        }
        graph.validate();
    }

    public static <N, E, P> void performLayout(GraphPinScene<N, E, P> scene) {
        GridGraphLayoutUtility.performLayout(scene, false);
    }

    public static <N, E, P> void performLayout(GraphPinScene<N, E, P> scene, boolean checker) {
        GridGraphLayoutUtility.performLayout(scene, checker, 64, 64);
    }

    private static <N> N findNodeWithMaxEdges(HashSet<N> unresolvedNodes, Map<N, Collection<N>> node2connected) {
        N bestNode = null;
        int bestCount = Integer.MIN_VALUE;
        for (N node : unresolvedNodes) {
            int i = node2connected.get(node).size();
            if (i <= bestCount) continue;
            bestNode = node;
            bestCount = i;
        }
        return bestNode;
    }

    private static <N> Point findCenter(Map<N, Point> node2grid, boolean checker) {
        int add = checker ? 2 : 1;
        int x = 0;
        Point point;
        while (GridGraphLayoutUtility.isOccupied(node2grid, point = new Point(x, 0))) {
            x += add;
        }
        return point;
    }

    private static <N> boolean isOccupied(Map<N, Point> node2grid, Point point) {
        boolean occupied = false;
        for (Point p : node2grid.values()) {
            if (point.x != p.x || point.y != p.y) continue;
            occupied = true;
            break;
        }
        return occupied;
    }

    private static <N> Point resolvePoint(Map<N, Point> node2grid, Point center, Point index, boolean checker) {
        Point point;
        do {
            int max = 8 * index.y;
            ++index.x;
            if (index.x >= max) {
                ++index.y;
                index.x -= max;
            }
            point = GridGraphLayoutUtility.index2point(index);
            point.x += center.x;
            point.y += center.y;
        } while (checker && (point.x + point.y & 1) != 0 || GridGraphLayoutUtility.isOccupied(node2grid, point));
        return point;
    }

    private static Point index2point(Point index) {
        int indexPos = index.x;
        int indexLevel = index.y;
        if (indexPos < indexLevel) {
            return new Point(indexLevel, indexPos);
        }
        if (indexPos < 3 * indexLevel) {
            return new Point(indexLevel - (indexPos - indexLevel), indexLevel);
        }
        if (indexPos < 5 * indexLevel) {
            return new Point(-indexLevel, indexLevel - (indexPos - 3 * indexLevel));
        }
        if (indexPos < 7 * indexLevel) {
            return new Point(indexPos - 5 * indexLevel - indexLevel, -indexLevel);
        }
        if (indexPos < 8 * indexLevel) {
            return new Point(indexLevel, indexPos - 7 * indexLevel - indexLevel);
        }
        throw new InternalError("Index: " + indexPos);
    }
}

