/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.core.stack.storage.impl.SnapshotImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.ThreadDumpImpl;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.Util;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SQLStackDataStorage
implements ProxyDataStorage,
StackDataStorage,
ThreadDumpProvider {
    private SQLDataStorage sqlStorage;
    private final List<DataTableMetadata> tableMetadatas = new ArrayList<DataTableMetadata>();
    private final Map<String, PreparedStatement> stmtCache;
    private CppSymbolDemangler demangler = null;
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private final Map<CharSequence, Long> funcCache = new HashMap<CharSequence, Long>();
    private final Map<NodeCacheKey, Long> nodeCache = new HashMap<NodeCacheKey, Long>();
    private long funcIdSequence = 0L;
    private long nodeIdSequence = 0L;
    private final ExecutorThread executor = new ExecutorThread();
    private boolean isRunning = true;
    private static final int MAX_STRING_LENGTH = 16384;

    public SQLStackDataStorage() {
        this.executor.setPriority(1);
        this.executor.start();
        this.stmtCache = new ConcurrentHashMap<String, PreparedStatement>();
    }

    public void syncAddData(String tableName, List<DataRow> data) {
        this.addData(tableName, data);
    }

    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        this.serviceInfoDataStorage = serviceInfoStorage;
        CppSymbolDemanglerFactory factory = (CppSymbolDemanglerFactory)Lookup.getDefault().lookup(CppSymbolDemanglerFactory.class);
        this.demangler = factory != null ? factory.getForCurrentSession(serviceInfoStorage.getInfo()) : null;
    }

    public DataStorageType getBackendDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getBackendTablesMetadata() {
        return Collections.emptyList();
    }

    public void attachTo(DataStorage storage) {
        this.sqlStorage = (SQLDataStorage)storage;
        try {
            this.initTables();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private final <T extends DataFilter> Collection<T> getDataFilters(List<DataFilter> filters, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (DataFilter f : filters) {
            if (f.getClass() != clazz) continue;
            result.add(clazz.cast(f));
        }
        return result;
    }

    public boolean hasData(DataTableMetadata data) {
        return data.isProvidedBy(this.tableMetadatas);
    }

    public void addData(String tableName, List<DataRow> data) {
    }

    public Collection<DataStorageType> getStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType("stack"));
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        this.tableMetadatas.addAll(tableMetadatas);
    }

    public boolean shutdown(boolean shutdownSqlStorage) {
        boolean result = this.shutdown();
        if (shutdownSqlStorage) {
            result = this.sqlStorage.shutdown() && result;
        }
        return result;
    }

    public boolean shutdown() {
        this.isRunning = false;
        this.funcCache.clear();
        this.nodeCache.clear();
        for (PreparedStatement stmt : this.stmtCache.values()) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        this.stmtCache.clear();
        return true;
    }

    private synchronized PreparedStatement getPreparedStatement(String sql) throws SQLException {
        PreparedStatement stmt = this.stmtCache.get(sql);
        if (stmt == null) {
            stmt = this.sqlStorage.prepareStatement(sql);
            this.stmtCache.put(sql, stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTables() throws SQLException, IOException {
        InputStream is = SQLStackDataStorage.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/core/stack/resources/schema.sql");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("-- ")) continue;
                buf.append(line);
                if (!line.endsWith(";")) continue;
                String sql = buf.toString();
                buf.setLength(0);
                String sqlToExecute = sql.substring(0, sql.length() - 1);
                this.sqlStorage.executeUpdate(sqlToExecute);
            }
        }
        finally {
            reader.close();
        }
    }

    @Override
    public long putStack(List<CharSequence> stack) {
        return this.putSample(stack, -1L, -1L);
    }

    @Override
    public long putSample(List<CharSequence> stack, long timestamp, long duration) {
        long callerId = 0L;
        HashSet<Long> funcs = new HashSet<Long>();
        for (int i = 0; i < stack.size(); ++i) {
            boolean isLeaf = i + 1 == stack.size();
            CharSequence funcName = stack.get(i);
            long funcId = this.generateFuncId(funcName);
            this.updateMetrics(funcId, false, timestamp, duration, !funcs.contains(funcId), isLeaf);
            funcs.add(funcId);
            long nodeId = this.generateNodeId(callerId, funcId, this.getOffset(funcName));
            this.updateMetrics(nodeId, true, timestamp, duration, true, isLeaf);
            callerId = nodeId;
        }
        return callerId;
    }

    public void flush() {
        try {
            this.executor.flush();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return METRICS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        try {
            ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
            ResultSet rs = this.sqlStorage.select(null, null, this.prepareCallersSelect(path));
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(4)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(5)));
                    String funcName = rs.getString(2);
                    result.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(1), funcName, rs.getString(3)), metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(result);
            return result;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        try {
            ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
            ResultSet rs = this.sqlStorage.select(null, null, this.prepareCalleesSelect(path));
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(4)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(5)));
                    String funcName = rs.getString(2);
                    result.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(1), funcName, rs.getString(3)), metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(result);
            return result;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getHotSpotFunctions(FunctionMetric metric, List<DataFilter> filters, int limit) {
        try {
            ArrayList<FunctionCallWithMetric> funcList = new ArrayList<FunctionCallWithMetric>();
            TimeIntervalDataFilter timeFilter = (TimeIntervalDataFilter)Util.firstInstanceOf(TimeIntervalDataFilter.class, filters);
            PreparedStatement select = this.getPreparedStatement("SELECT Func.func_id, Func.func_name, Func.func_full_name, SUM(FuncMetricAggr.time_incl) AS time_incl, SUM(FuncMetricAggr.time_excl) AS time_excl FROM Func LEFT JOIN FuncMetricAggr ON Func.func_id = FuncMetricAggr.func_id " + (timeFilter != null ? "WHERE ? <= FuncMetricAggr.bucket_id AND FuncMetricAggr.bucket_id < ? " : "") + "GROUP BY Func.func_id, Func.func_name, Func.func_full_name " + "ORDER BY " + metric.getMetricID() + " DESC");
            if (timeFilter != null) {
                select.setLong(1, SQLStackDataStorage.timeToBucketId((Long)timeFilter.getInterval().getStart()));
                select.setLong(2, SQLStackDataStorage.timeToBucketId((Long)timeFilter.getInterval().getEnd()));
            }
            select.setMaxRows(limit);
            ResultSet rs = select.executeQuery();
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(4)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(5)));
                    String name = rs.getString(2);
                    funcList.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(1), name, rs.getString(3)), metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(funcList);
            return funcList;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata metadata, List<DataTableMetadata.Column> metricsColumn, FunctionDatatableDescription functionDescription, List<DataFilter> filters) {
        try {
            ArrayList<FunctionMetric> metrics = new ArrayList<FunctionMetric>();
            for (DataTableMetadata.Column metricColumn : metricsColumn) {
                FunctionMetric metric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetric.FunctionMetricConfiguration(metricColumn.getColumnName(), metricColumn.getColumnUName(), metricColumn.getColumnClass()));
                metrics.add(metric);
            }
            String functionColumnName = functionDescription.getNameColumn();
            String offesetColumnName = functionDescription.getOffsetColumn();
            String functionUniqueID = functionDescription.getUniqueColumnName();
            ArrayList<FunctionCallWithMetric> funcList = new ArrayList<FunctionCallWithMetric>();
            Collection<TimeIntervalDataFilter> timeFilters = this.getDataFilters(filters, TimeIntervalDataFilter.class);
            ArrayList tableFilters = new ArrayList();
            DataTableMetadataFilterSupport filtersSupport = DataTableMetadataFilterSupport.getInstance();
            for (TimeIntervalDataFilter timeFilter : timeFilters) {
                tableFilters.addAll(filtersSupport.createFilters(metadata, timeFilter));
            }
            ResultSet rs = this.sqlStorage.select(metadata, tableFilters);
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metricValues = new HashMap<FunctionMetric, Object>();
                    for (FunctionMetric m : metrics) {
                        try {
                            rs.findColumn(m.getMetricID());
                            Object value = rs.getObject(m.getMetricID());
                            if (m.getMetricValueClass() == Time.class && value != null) {
                                value = new Time(Long.valueOf(value + "").longValue());
                            }
                            metricValues.put(m, value);
                        }
                        catch (SQLException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                    String funcName = rs.getString(functionColumnName);
                    funcList.add(new FunctionCallImpl(new FunctionImpl(rs.getInt(functionUniqueID), funcName, funcName), offesetColumnName != null ? rs.getLong(offesetColumnName) : -1L, metricValues));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(funcList);
            return funcList;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private void updateMetrics(long id, boolean funcOrNode, long timestamp, long duration, boolean addIncl, boolean addExcl) {
        if (0L < duration) {
            UpdateMetrics cmd = new UpdateMetrics();
            cmd.objId = id;
            cmd.bucketId = SQLStackDataStorage.timeToBucketId(timestamp);
            cmd.funcOrNode = funcOrNode;
            if (addIncl) {
                cmd.cpuTimeInclusive = duration;
            }
            if (addExcl) {
                cmd.cpuTimeExclusive = duration;
            }
            this.executor.submitCommand(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateNodeId(long callerId, long funcId, long offset) {
        Map<NodeCacheKey, Long> map = this.nodeCache;
        synchronized (map) {
            NodeCacheKey cacheKey = new NodeCacheKey(callerId, funcId, offset);
            Long nodeId = this.nodeCache.get(cacheKey);
            if (nodeId == null) {
                nodeId = ++this.nodeIdSequence;
                AddNode cmd = new AddNode();
                cmd.id = nodeId;
                cmd.callerId = callerId;
                cmd.funcId = funcId;
                cmd.offset = offset;
                this.executor.submitCommand(cmd);
                this.nodeCache.put(cacheKey, nodeId);
            }
            return nodeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateFuncId(CharSequence fname) {
        String funcName = ((Object)fname).toString();
        int plusPos = this.lastIndexOf(funcName, '+');
        if (0 <= plusPos) {
            funcName = funcName.substring(0, plusPos);
        }
        Map<CharSequence, Long> map = this.funcCache;
        synchronized (map) {
            Long funcId = this.funcCache.get(funcName);
            if (funcId == null) {
                funcId = ++this.funcIdSequence;
                AddFunction cmd = new AddFunction();
                cmd.id = funcId;
                cmd.name = funcName;
                this.executor.submitCommand(cmd);
                this.funcCache.put(funcName, funcId);
            }
            return funcId;
        }
    }

    private long getOffset(CharSequence cs) {
        int plusPos = this.lastIndexOf(cs, '+');
        if (0 <= plusPos) {
            try {
                return Long.parseLong(((Object)cs.subSequence(plusPos + 3, cs.length())).toString(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private int lastIndexOf(CharSequence cs, char c) {
        for (int i = cs.length() - 1; 0 <= i; --i) {
            if (cs.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private String prepareCallersSelect(List<FunctionCallWithMetric> path) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        int size = path.size();
        buf.append(" SELECT F.func_id, F.func_name, F.func_full_name, SUM(N.time_incl), SUM(N.time_excl) FROM Node AS N ");
        buf.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id ");
        buf.append(" INNER JOIN Node N1 ON N.node_id = N1.caller_id ");
        for (i = 1; i < size; ++i) {
            buf.append(" INNER JOIN Node AS N").append(i + 1);
            buf.append(" ON N").append(i).append(".node_id = N").append(i + 1).append(".caller_id ");
        }
        buf.append(" WHERE ");
        for (i = 0; i < size; ++i) {
            if (0 < i) {
                buf.append("AND ");
            }
            buf.append("N").append(i + 1).append(".func_id = ");
            buf.append(((FunctionImpl)path.get(i).getFunction()).getId());
        }
        buf.append(" GROUP BY F.func_id, F.func_name, F.func_full_name");
        return buf.toString();
    }

    private String prepareCalleesSelect(List<FunctionCallWithMetric> path) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        int size = path.size();
        buf.append("SELECT F.func_id, F.func_name, F.func_full_name, SUM(N.time_incl), SUM(N.time_excl) FROM Node AS N1 ");
        for (i = 1; i < size; ++i) {
            buf.append(" INNER JOIN Node AS N").append(i + 1);
            buf.append(" ON N").append(i).append(".node_id = N").append(i + 1).append(".caller_id ");
        }
        buf.append(" INNER JOIN Node N ON N").append(size).append(".node_id = N.caller_id ");
        buf.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id WHERE ");
        for (i = 0; i < size; ++i) {
            if (0 < i) {
                buf.append(" AND ");
            }
            buf.append(" N").append(i + 1).append(".func_id = ");
            buf.append(((FunctionImpl)path.get(i).getFunction()).getId());
        }
        buf.append(" GROUP BY F.func_id, F.func_name, F.func_full_name");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadSnapshot fetchSnapshot(int threadId, long timestamp, boolean fullMsa) throws SQLException {
        PreparedStatement s = this.getPreparedStatement("SELECT leaf_id, mstate FROM CallStack WHERE thread_id = ? AND time_stamp = ?");
        s.setInt(1, threadId);
        s.setLong(2, timestamp);
        ResultSet rs = s.executeQuery();
        try {
            if (rs.next()) {
                SnapshotImpl snapshotImpl = new SnapshotImpl(this, timestamp, threadId, rs.getInt(1), ThreadState.MSAState.fromCode(rs.getInt(2), fullMsa));
                return snapshotImpl;
            }
            ThreadSnapshot threadSnapshot = null;
            return threadSnapshot;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadSnapshot> getThreadSnapshots(ThreadSnapshotQuery query) {
        ThreadSnapshotQuery.TimeFilter timeFilter;
        ArrayList<String> conditions = new ArrayList<String>(3);
        ThreadSnapshotQuery.ThreadFilter threadFilter = (ThreadSnapshotQuery.ThreadFilter)Util.firstInstanceOf(ThreadSnapshotQuery.ThreadFilter.class, query.getFilters());
        if (threadFilter != null) {
            StringBuilder where = new StringBuilder("thread_id IN (");
            boolean first = true;
            for (int threadId : threadFilter.getThreadIds()) {
                if (first) {
                    first = false;
                } else {
                    where.append(',');
                }
                where.append(threadId);
            }
            where.append(')');
            conditions.add(where.toString());
        }
        if ((timeFilter = (ThreadSnapshotQuery.TimeFilter)Util.firstInstanceOf(ThreadSnapshotQuery.TimeFilter.class, query.getFilters())) != null) {
            if (0L <= timeFilter.getStartTime()) {
                conditions.add(timeFilter.getStartTime() + " <= time_stamp");
            }
            if (0L <= timeFilter.getEndTime()) {
                conditions.add("time_stamp <= " + timeFilter.getEndTime());
            }
        }
        StringBuilder select = new StringBuilder("SELECT thread_id, ");
        if (timeFilter != null) {
            switch (timeFilter.getMode()) {
                case FIRST: {
                    select.append("MIN(time_stamp) ");
                    break;
                }
                case LAST: {
                    select.append("MAX(time_stamp) ");
                    break;
                }
                default: {
                    select.append("time_stamp ");
                    break;
                }
            }
        } else {
            select.append("time_stamp ");
        }
        select.append("FROM CallStack ");
        if (!conditions.isEmpty()) {
            select.append("WHERE ");
            boolean first = true;
            for (String condition : conditions) {
                if (first) {
                    first = false;
                } else {
                    select.append("AND ");
                }
                select.append(condition).append(' ');
            }
        }
        if (timeFilter != null && timeFilter.getMode() != ThreadSnapshotQuery.TimeFilter.Mode.ALL) {
            select.append("GROUP BY thread_id");
        }
        try {
            ArrayList<ThreadSnapshot> snapshots = new ArrayList<ThreadSnapshot>();
            ResultSet rs = this.sqlStorage.select(null, null, select.toString());
            try {
                if (rs != null) {
                    while (rs.next()) {
                        ThreadSnapshot snapshot = this.fetchSnapshot(rs.getInt(1), rs.getLong(2), query.isFullMSA());
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            return snapshots;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public ThreadDump getThreadDump(ThreadDumpQuery query) {
        ThreadDump res = this._getThreadDump(query);
        if (res == null) {
            return null;
        }
        ThreadDumpImpl result = new ThreadDumpImpl(res.getTimestamp());
        block0: for (Integer i : query.getShowThreads()) {
            for (ThreadSnapshot dump : res.getThreadStates()) {
                if (dump.getThreadInfo().getThreadId() != i.intValue()) continue;
                result.addStack(dump);
                continue block0;
            }
        }
        return result;
    }

    private ThreadState.MSAState getTrueState(ThreadSnapshot dump, ThreadDumpQuery query) {
        ThreadState.MSAState state = dump.getState();
        return state;
    }

    private ThreadDump _getThreadDump(ThreadDumpQuery query) {
        long start = query.getThreadState().getTimeStamp();
        long middle = query.getThreadState().getTimeStamp() + query.getThreadState().getMSASamplePeriod() / 2L;
        long end = query.getThreadState().getTimeStamp() + query.getThreadState().getMSASamplePeriod();
        ThreadSnapshotQuery.TimeFilter time = new ThreadSnapshotQuery.TimeFilter(start, end, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
        ThreadSnapshotQuery.ThreadFilter threads = new ThreadSnapshotQuery.ThreadFilter(query.getShowThreads());
        Collection res = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
        ThreadSnapshot found = null;
        long foundTimeSamp = -1L;
        for (ThreadSnapshot dump : res) {
            if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
            found = dump;
            foundTimeSamp = found.getTimestamp();
            break;
        }
        if (found == null) {
            time = new ThreadSnapshotQuery.TimeFilter(0L, middle, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
            threads = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)query.getThreadID()));
            Collection res2 = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
            long foundAny = -1L;
            for (ThreadSnapshot dump : res2) {
                foundAny = dump.getTimestamp();
                if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
                found = dump;
                foundTimeSamp = middle;
                break;
            }
            if (found == null && foundAny > 0L) {
                time = new ThreadSnapshotQuery.TimeFilter(foundAny - 1000000L, foundAny + 1L, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
                threads = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)query.getThreadID()));
                res2 = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
                for (ThreadSnapshot dump : res2) {
                    foundAny = dump.getTimestamp();
                    if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
                    found = dump;
                    foundTimeSamp = middle;
                    break;
                }
                if (found == null) {
                    for (ThreadSnapshot dump : res2) {
                        foundAny = dump.getTimestamp();
                        if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId()) continue;
                        found = dump;
                        foundTimeSamp = middle;
                        break;
                    }
                }
            }
        }
        if (found != null) {
            HashMap<Integer, ThreadSnapshot> map = new HashMap<Integer, ThreadSnapshot>();
            map.put(found.getThreadInfo().getThreadId(), found);
            for (ThreadSnapshot dump : res) {
                if (dump.getThreadInfo().getThreadId() == found.getThreadInfo().getThreadId()) continue;
                int id = dump.getThreadInfo().getThreadId();
                ThreadSnapshot prev = (ThreadSnapshot)map.get(id);
                if (prev == null) {
                    map.put(id, dump);
                    continue;
                }
                if (Math.abs(prev.getTimestamp() - foundTimeSamp) <= Math.abs(dump.getTimestamp() - foundTimeSamp)) continue;
                map.put(id, dump);
            }
            HashSet<Integer> toAdd = new HashSet<Integer>(query.getShowThreads());
            ThreadDumpImpl result = new ThreadDumpImpl(foundTimeSamp);
            for (ThreadSnapshot dump : map.values()) {
                toAdd.remove(dump.getThreadInfo().getThreadId());
                result.addStack(dump);
            }
            if (!toAdd.isEmpty()) {
                time = new ThreadSnapshotQuery.TimeFilter(0L, foundTimeSamp, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
                threads = new ThreadSnapshotQuery.ThreadFilter(toAdd);
                res = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
                for (ThreadSnapshot dump : res) {
                    result.addStack(dump);
                }
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<FunctionCall> getCallStack(long stackId) {
        ArrayList<FunctionCall> result = new ArrayList<FunctionCall>();
        try {
            long nodeID = stackId;
            while (0L < nodeID) {
                PreparedStatement ps = this.getPreparedStatement("SELECT Node.node_id, Node.caller_id, Node.func_id, Node.offset, Func.func_name FROM Node LEFT JOIN Func ON Node.func_id = Func.func_id WHERE node_id = ?");
                ps.setLong(1, nodeID);
                ResultSet rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        String funcName = rs.getString(5);
                        FunctionImpl func = new FunctionImpl(rs.getInt(3), funcName, funcName);
                        result.add(new FunctionCallImpl(func, rs.getLong(4), new HashMap<FunctionMetric, Object>()));
                        nodeID = rs.getInt(2);
                        continue;
                    }
                    break;
                }
                finally {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.demangle(result);
        Collections.reverse(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void demangle(List<? extends FunctionCall> calls) {
        if (this.demangler != null) {
            void var4_6;
            ArrayList<String> mangled = new ArrayList<String>(calls.size());
            for (FunctionCall functionCall : calls) {
                mangled.add(functionCall.getFunction().getName());
            }
            List demangled = this.demangler.demangle(mangled);
            boolean bl = false;
            while (var4_6 < calls.size()) {
                ((FunctionImpl)calls.get((int)var4_6).getFunction()).setName((String)demangled.get((int)var4_6));
                ++var4_6;
            }
        }
    }

    private static long timeToBucketId(long timestamp) {
        return timestamp / 1000L / 1000L / 1000L;
    }

    private static String truncateString(String str) {
        if (str.length() <= 16384) {
            return str;
        }
        return str.substring(0, 16381) + "...";
    }

    private class ExecutorThread
    extends Thread {
        private static final int MAX_COMMANDS = 5000;
        private static final long SLEEP_INTERVAL = 200L;
        private final LinkedBlockingQueue<Object> queue;

        public ExecutorThread() {
            this.setName("DLIGTH: SQLStackStorage executor thread");
            this.queue = new LinkedBlockingQueue();
        }

        public void submitCommand(Object cmd) {
            this.queue.offer(cmd);
        }

        public synchronized void flush() throws InterruptedException {
            while (!this.queue.isEmpty()) {
                this.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashMap funcMetrics = new HashMap();
                HashMap<Long, UpdateMetrics> nodeMetrics = new HashMap<Long, UpdateMetrics>();
                LinkedList cmds = new LinkedList();
                while (SQLStackDataStorage.this.isRunning) {
                    ExecutorThread executorThread = this;
                    synchronized (executorThread) {
                        PreparedStatement stmt;
                        Object cmd;
                        this.queue.drainTo(cmds, 5000);
                        Iterator cmdIterator = cmds.iterator();
                        while (cmdIterator.hasNext()) {
                            if (!SQLStackDataStorage.this.isRunning) {
                                return;
                            }
                            cmd = cmdIterator.next();
                            if (!(cmd instanceof UpdateMetrics)) continue;
                            UpdateMetrics updateMetricsCmd = (UpdateMetrics)cmd;
                            HashMap<Long, UpdateMetrics> map = updateMetricsCmd.funcOrNode ? nodeMetrics : funcMetrics;
                            UpdateMetrics original = (UpdateMetrics)map.get(updateMetricsCmd.objId);
                            if (original == null) {
                                map.put(updateMetricsCmd.objId, updateMetricsCmd);
                            } else {
                                original.add(updateMetricsCmd);
                            }
                            cmdIterator.remove();
                        }
                        cmdIterator = cmds.iterator();
                        while (cmdIterator.hasNext()) {
                            if (!SQLStackDataStorage.this.isRunning) {
                                return;
                            }
                            cmd = cmdIterator.next();
                            try {
                                if (cmd instanceof AddFunction) {
                                    AddFunction addFunctionCmd = (AddFunction)cmd;
                                    stmt = SQLStackDataStorage.this.getPreparedStatement("INSERT INTO Func (func_id, func_full_name, func_name) VALUES (?, ?, ?)");
                                    stmt.setLong(1, addFunctionCmd.id);
                                    stmt.setString(2, SQLStackDataStorage.truncateString(((Object)addFunctionCmd.name).toString()));
                                    stmt.setString(3, SQLStackDataStorage.truncateString(((Object)addFunctionCmd.name).toString()));
                                    stmt.executeUpdate();
                                    continue;
                                }
                                if (!(cmd instanceof AddNode)) continue;
                                AddNode addNodeCmd = (AddNode)cmd;
                                stmt = SQLStackDataStorage.this.getPreparedStatement("INSERT INTO Node (node_id, caller_id, func_id, offset, time_incl, time_excl) VALUES (?, ?, ?, ?, ?, ?)");
                                stmt.setLong(1, addNodeCmd.id);
                                stmt.setLong(2, addNodeCmd.callerId);
                                stmt.setLong(3, addNodeCmd.funcId);
                                stmt.setLong(4, addNodeCmd.offset);
                                UpdateMetrics metrics = (UpdateMetrics)nodeMetrics.remove(addNodeCmd.id);
                                if (metrics == null) {
                                    stmt.setLong(5, 0L);
                                    stmt.setLong(6, 0L);
                                } else {
                                    stmt.setLong(5, metrics.cpuTimeInclusive);
                                    stmt.setLong(6, metrics.cpuTimeExclusive);
                                }
                                stmt.executeUpdate();
                            }
                            catch (SQLException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        cmds.clear();
                        for (UpdateMetrics cmd2 : funcMetrics.values()) {
                            try {
                                stmt = SQLStackDataStorage.this.getPreparedStatement("SELECT func_id, bucket_id, time_incl, time_excl FROM FuncMetricAggr WHERE func_id = ? AND bucket_id = ? FOR UPDATE");
                                stmt.setLong(1, cmd2.objId);
                                stmt.setLong(2, cmd2.bucketId);
                                ResultSet rs = stmt.executeQuery();
                                try {
                                    if (rs.next()) {
                                        rs.updateLong(3, rs.getLong(3) + cmd2.cpuTimeInclusive);
                                        rs.updateLong(4, rs.getLong(4) + cmd2.cpuTimeExclusive);
                                        rs.updateRow();
                                        continue;
                                    }
                                    rs.moveToInsertRow();
                                    rs.updateLong(1, cmd2.objId);
                                    rs.updateLong(2, cmd2.bucketId);
                                    rs.updateLong(3, cmd2.cpuTimeInclusive);
                                    rs.updateLong(4, cmd2.cpuTimeExclusive);
                                    rs.insertRow();
                                }
                                finally {
                                    rs.close();
                                }
                            }
                            catch (SQLException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        funcMetrics.clear();
                        for (UpdateMetrics cmd2 : nodeMetrics.values()) {
                            try {
                                stmt = SQLStackDataStorage.this.getPreparedStatement("UPDATE Node SET time_incl = time_incl + ?, time_excl = time_excl + ? WHERE node_id = ?");
                                stmt.setLong(1, cmd2.cpuTimeInclusive);
                                stmt.setLong(2, cmd2.cpuTimeExclusive);
                                stmt.setLong(3, cmd2.objId);
                                stmt.executeUpdate();
                            }
                            catch (SQLException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        nodeMetrics.clear();
                        this.notifyAll();
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class UpdateMetrics {
        public boolean funcOrNode;
        public long objId;
        public long bucketId;
        public long cpuTimeInclusive;
        public long cpuTimeExclusive;

        private UpdateMetrics() {
        }

        public void add(UpdateMetrics delta) {
            this.cpuTimeInclusive += delta.cpuTimeInclusive;
            this.cpuTimeExclusive += delta.cpuTimeExclusive;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.funcOrNode ? "func" : "node");
            buf.append(" id=").append(this.objId);
            buf.append(": time_incl+=").append(this.cpuTimeInclusive);
            buf.append(", time_excl+=").append(this.cpuTimeExclusive);
            return buf.toString();
        }
    }

    private static class AddNode {
        public long id;
        public long callerId;
        public long funcId;
        public long offset;

        private AddNode() {
        }
    }

    private static class AddFunction {
        public long id;
        public CharSequence name;

        private AddFunction() {
        }
    }

    protected static class FunctionCallImpl
    extends FunctionCallWithMetric {
        private final Map<FunctionMetric, Object> metrics;

        FunctionCallImpl(Function function, long offset, Map<FunctionMetric, Object> metrics) {
            super(function, offset);
            this.metrics = metrics;
        }

        FunctionCallImpl(Function function, Map<FunctionMetric, Object> metrics) {
            this(function, 0L, metrics);
        }

        @Override
        public String getDisplayedName() {
            return this.getFunction().getName() + (this.hasOffset() ? "+0x" + Long.toHexString(this.getOffset()) : "");
        }

        @Override
        public Object getMetricValue(FunctionMetric metric) {
            return this.metrics.get(metric);
        }

        @Override
        public Object getMetricValue(String metric_id) {
            for (FunctionMetric metric : this.metrics.keySet()) {
                if (!metric.getMetricID().equals(metric_id)) continue;
                return this.metrics.get(metric);
            }
            return null;
        }

        @Override
        public boolean hasMetric(String metric_id) {
            for (FunctionMetric metric : this.metrics.keySet()) {
                if (!metric.getMetricID().equals(metric_id)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("FunctionCall{ function=").append(this.getFunction());
            buf.append(", metrics=").append(this.metrics).append(" }");
            return buf.toString();
        }
    }

    protected static class FunctionImpl
    implements Function {
        private final long id;
        private String name;
        private final String quilifiedName;

        public FunctionImpl(long id, String name, String qualifiedName) {
            this.id = id;
            this.name = name;
            this.quilifiedName = qualifiedName;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        @Override
        public String getSignature() {
            return this.quilifiedName;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getQuilifiedName() {
            return FunctionNameUtils.getFunctionQName(this.name);
        }
    }

    private static class NodeCacheKey {
        private final long callerId;
        private final long funcId;
        private final long offset;

        public NodeCacheKey(long callerId, long funcId, long offset) {
            this.callerId = callerId;
            this.funcId = funcId;
            this.offset = offset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeCacheKey)) {
                return false;
            }
            NodeCacheKey that = (NodeCacheKey)obj;
            return this.callerId == that.callerId && this.funcId == that.funcId && this.offset == that.offset;
        }

        public int hashCode() {
            return 13 * ((int)(this.callerId >> 32) | (int)this.callerId) + 17 * ((int)(this.funcId >> 32) | (int)this.funcId) + ((int)(this.offset >> 32) | (int)this.offset);
        }
    }
}

