/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ThreadSnapshotQuery {
    private final boolean fullMsa;
    private final List<Filter> filters;

    public ThreadSnapshotQuery(boolean fullMsa, Filter ... filters) {
        this.fullMsa = fullMsa;
        this.filters = filters.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList((Object[])filters.clone()));
    }

    public boolean isFullMSA() {
        return this.fullMsa;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public static final class TimeFilter
    implements Filter {
        private final long startTime;
        private final long endTime;
        private final Mode mode;

        public TimeFilter(long startTime, long endTime, Mode mode) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.mode = mode;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String toString() {
            return this.mode.toString() + " with " + this.startTime + " <= timestamp <= " + this.endTime;
        }

        public static enum Mode {
            ALL,
            FIRST,
            LAST;

        }
    }

    public static final class ThreadFilter
    implements Filter {
        private final Set<Integer> threadIds;

        public ThreadFilter(Collection<Integer> threadIds) {
            this.threadIds = Collections.unmodifiableSet(new HashSet<Integer>(threadIds));
        }

        public Set<Integer> getThreadIds() {
            return this.threadIds;
        }

        public String toString() {
            return "thread_id in " + this.threadIds.toString();
        }
    }

    public static interface Filter {
    }
}

