/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr.preprocessor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.netbeans.modules.cnd.antlr.Tool;
import org.netbeans.modules.cnd.antlr.collections.impl.IndexedVector;
import org.netbeans.modules.cnd.antlr.preprocessor.Grammar;
import org.netbeans.modules.cnd.antlr.preprocessor.Hierarchy;

public class GrammarFile {
    protected String fileName;
    protected String headerAction = "";
    protected IndexedVector options;
    protected IndexedVector grammars;
    protected boolean expanded = false;
    protected Tool tool;

    public GrammarFile(Tool tool, String f) {
        this.fileName = f;
        this.grammars = new IndexedVector();
        this.tool = tool;
    }

    public void addGrammar(Grammar g) {
        this.grammars.appendElement(g.getName(), g);
    }

    public void generateExpandedFile() throws IOException {
        if (!this.expanded) {
            return;
        }
        String expandedFileName = this.nameForExpandedGrammarFile(this.getName());
        PrintWriter expF = this.tool.openOutputFile(expandedFileName);
        expF.println(this.toString());
        expF.close();
    }

    public IndexedVector getGrammars() {
        return this.grammars;
    }

    public String getName() {
        return this.fileName;
    }

    public String nameForExpandedGrammarFile(String f) {
        if (this.expanded) {
            return "expanded" + this.tool.fileMinusPath(f);
        }
        return f;
    }

    public void setExpanded(boolean exp) {
        this.expanded = exp;
    }

    public void addHeaderAction(String a) {
        this.headerAction = this.headerAction + a + System.getProperty("line.separator");
    }

    public void setOptions(IndexedVector o) {
        this.options = o;
    }

    public String toString() {
        String h = this.headerAction == null ? "" : this.headerAction;
        String o = this.options == null ? "" : Hierarchy.optionsToString(this.options);
        StringBuffer s = new StringBuffer(10000);
        s.append(h);
        s.append(o);
        Enumeration e = this.grammars.elements();
        while (e.hasMoreElements()) {
            Grammar g = (Grammar)e.nextElement();
            s.append(g.toString());
        }
        return s.toString();
    }
}

