/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ConnectionNotifier;
import org.netbeans.modules.cnd.remote.server.RemoteServerListUI;
import org.netbeans.modules.cnd.remote.support.RemoteCodeModelUtils;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ShellScriptRunner;
import org.openide.util.NbBundle;

public class RemoteFileSupport
extends NamedRunnable {
    private final PendingFilesQueue pendingFilesQueue = new PendingFilesQueue();
    private final ExecutionEnvironment execEnv;
    private int fileCopyCount;
    private int dirSyncCount;
    private final Object mainLock = new Object();
    private Map<File, Object> locks = new HashMap<File, Object>();
    private final Map<ExecutionEnvironment, Boolean> cancels = new HashMap<ExecutionEnvironment, Boolean>();
    public static final String FLAG_FILE_NAME = ".rfs";
    private static final String CC_STR = "cc";
    static final String POSTFIX = ".cnd.rfs.small";

    public RemoteFileSupport(ExecutionEnvironment execEnv) {
        super(NbBundle.getMessage(RemoteFileSupport.class, (String)"RemoteDownloadTask.TITLE", (Object)RemoteUtil.getDisplayName(execEnv)));
        this.execEnv = execEnv;
        this.resetStatistic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLock(File file) {
        Object object = this.mainLock;
        synchronized (object) {
            Object lock = this.locks.get(file);
            if (lock == null) {
                lock = new Object();
                this.locks.put(file, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLock(File file) {
        Object object = this.mainLock;
        synchronized (object) {
            this.locks.remove(file);
        }
    }

    static String fixCaseSensitivePathIfNeeded(String in) {
        StringBuilder out = new StringBuilder(in);
        int left = out.indexOf(CC_STR);
        if (left >= 0 && out.length() >= CC_STR.length()) {
            if (left > 0 && out.charAt(left - 1) != '/') {
                return out.toString();
            }
            int right = left + CC_STR.length();
            if (out.length() > right && out.charAt(right) != '/') {
                return out.toString();
            }
            if (right == out.length()) {
                out.append(POSTFIX);
            } else {
                out.insert(right, POSTFIX);
            }
        }
        return out.toString();
    }

    static String fromFixedCaseSensitivePathIfNeeded(String in) {
        return in.replaceAll(POSTFIX, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureFileSync(File file, String remotePath) throws IOException, InterruptedException, ExecutionException, ConnectException {
        if (!file.exists() || file.length() == 0L) {
            Object object = this.getLock(file);
            synchronized (object) {
                if (!file.exists() || file.length() == 0L) {
                    this.syncFile(file, RemoteFileSupport.fromFixedCaseSensitivePathIfNeeded(remotePath));
                    this.removeLock(file);
                }
            }
        }
    }

    private void syncFile(File file, String remotePath) throws IOException, InterruptedException, ExecutionException, ConnectException {
        block4: {
            CndUtils.assertTrue((!file.exists() || file.isFile() ? 1 : 0) != 0, (String)("not a file " + file.getAbsolutePath()));
            this.checkConnection(file, remotePath, false);
            Future task = CommonTasksSupport.downloadFile((String)remotePath, (ExecutionEnvironment)this.execEnv, (String)file.getAbsolutePath(), null);
            try {
                int rc = (Integer)task.get();
                if (rc == 0) {
                    ++this.fileCopyCount;
                    break block4;
                }
                throw new IOException("Can't copy file " + file.getAbsolutePath() + " from " + this.execEnv + ':' + remotePath + ": rc=" + rc);
            }
            catch (InterruptedException ex) {
                this.truncate(file);
                throw ex;
            }
            catch (ExecutionException ex) {
                this.truncate(file);
                throw ex;
            }
        }
    }

    private void truncate(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureDirSync(File dir, String remoteDir) throws IOException, ConnectException {
        if (!dir.exists() || !new File(dir, FLAG_FILE_NAME).exists()) {
            Object object = this.getLock(dir);
            synchronized (object) {
                if (!dir.exists() || !new File(dir, FLAG_FILE_NAME).exists()) {
                    this.syncDirStruct(dir, RemoteFileSupport.fromFixedCaseSensitivePathIfNeeded(remoteDir));
                    this.removeLock(dir);
                }
            }
        }
    }

    @SuppressWarnings(value={"RV"})
    private void syncDirStruct(final File dir, String remoteDir) throws IOException, ConnectException {
        if (dir.exists()) {
            CndUtils.assertTrue((boolean)dir.isDirectory(), (String)(dir.getAbsolutePath() + " is not a directory"));
        }
        final String rdir = remoteDir.length() == 0 ? "/" : remoteDir;
        this.checkConnection(dir, rdir, true);
        String script = "test -d \"" + rdir + "\" && " + "cd \"" + rdir + "\" &&" + "for D in `/bin/ls`; do " + "if [ -d \"$D\" ]; then echo D \"$D\"; else echo F \"$D\"; fi; done";
        final AtomicReference<IOException> ex = new AtomicReference<IOException>();
        final AtomicBoolean dirCreated = new AtomicBoolean(false);
        LineProcessor outputProcessor = new LineProcessor(){

            public void processLine(String inputLine) {
                if (!dirCreated.get()) {
                    dirCreated.set(true);
                    if (!dir.mkdirs() && !dir.exists()) {
                        ex.set(new IOException("Can not create directory " + dir.getAbsolutePath()));
                        return;
                    }
                }
                CndUtils.assertTrueInConsole((inputLine.length() > 2 ? 1 : 0) != 0, (String)("unexpected file information " + inputLine));
                boolean directory = inputLine.charAt(0) == 'D';
                String fileName = inputLine.substring(2);
                if (directory) {
                    fileName = RemoteFileSupport.fixCaseSensitivePathIfNeeded(fileName);
                }
                File file = new File(dir, fileName);
                try {
                    RemoteUtil.LOGGER.log(Level.FINEST, "\tcreating {0}", fileName);
                    if (directory) {
                        if (!file.mkdirs() && !file.exists()) {
                            throw new IOException("can't create directory " + file.getAbsolutePath());
                        }
                    } else {
                        file.createNewFile();
                    }
                }
                catch (IOException ioex) {
                    RemoteUtil.LOGGER.log(Level.WARNING, "Error creating {0}{1}{2}: {3}", new Object[]{directory ? "directory" : "file", Character.valueOf(' '), file.getAbsolutePath(), ioex.getMessage()});
                    ex.set(ioex);
                }
            }

            public void reset() {
            }

            public void close() {
            }
        };
        LineProcessor errorProcessor = new LineProcessor(){

            public void processLine(String line) {
                RemoteUtil.LOGGER.log(Level.FINEST, "Error [{0}]\n\ton Synchronizing dir {1} with {2}{3}{4}", new Object[]{line, dir.getAbsolutePath(), RemoteFileSupport.this.execEnv, Character.valueOf(':'), rdir});
            }

            public void reset() {
            }

            public void close() {
            }
        };
        ShellScriptRunner scriptRunner = new ShellScriptRunner(this.execEnv, script, outputProcessor);
        scriptRunner.setErrorProcessor(errorProcessor);
        RemoteUtil.LOGGER.log(Level.FINEST, "Synchronizing dir {0} with {1}{2}{3}", new Object[]{dir.getAbsolutePath(), this.execEnv, Character.valueOf(':'), rdir});
        scriptRunner.execute();
        if (ex.get() != null) {
            throw (IOException)ex.get();
        }
        if (dirCreated.get()) {
            File flag = new File(dir, FLAG_FILE_NAME);
            RemoteUtil.LOGGER.log(Level.FINEST, "Creating Flag file {0}", flag.getAbsolutePath());
            try {
                flag.createNewFile();
            }
            catch (IOException ie) {
                RemoteUtil.LOGGER.log(Level.FINEST, "FAILED creating Flag file {0}", flag.getAbsolutePath());
                ex.set(ie);
            }
            ++this.dirSyncCount;
        }
    }

    final void resetStatistic() {
        this.dirSyncCount = 0;
        this.fileCopyCount = 0;
    }

    int getDirSyncCount() {
        return this.dirSyncCount;
    }

    int getFileCopyCount() {
        return this.fileCopyCount;
    }

    private void checkConnection(File localFile, String remotePath, boolean isDirectory) throws ConnectException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            RemoteUtil.LOGGER.log(Level.FINEST, "Adding notification for {0}:{1}", new Object[]{this.execEnv, remotePath});
            this.pendingFilesQueue.add(localFile, remotePath, isDirectory);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (NamedRunnable)this);
            throw new ConnectException();
        }
    }

    protected void runImpl() {
        try {
            this.onConnect();
        }
        catch (ConnectException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (NamedRunnable)this);
        }
        catch (InterruptedException ex) {
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (NamedRunnable)this);
        }
        catch (ExecutionException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (NamedRunnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect() throws InterruptedException, ConnectException, InterruptedIOException, IOException, ExecutionException {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Progress_Title", (Object)RemoteUtil.getDisplayName(this.execEnv)));
        handle.start();
        RemoteServerListUI.revalidate(this.execEnv);
        handle.switchToDeterminate(this.pendingFilesQueue.size());
        int cnt = 0;
        try {
            PendingFile pendingFile;
            while ((pendingFile = this.pendingFilesQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                if (pendingFile.isDirectory) {
                    this.ensureDirSync(pendingFile.localFile, pendingFile.remotePath);
                } else {
                    this.ensureFileSync(pendingFile.localFile, pendingFile.remotePath);
                }
                handle.progress(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Progress_Message", (Object)pendingFile.remotePath), cnt++);
            }
        }
        finally {
            handle.finish();
            RemoteCodeModelUtils.scheduleReparse(this.execEnv);
        }
    }

    private static class PendingFilesQueue {
        private final BlockingQueue<PendingFile> queue = new LinkedBlockingQueue<PendingFile>();
        private final Set<String> remoteAbsPaths = new TreeSet<String>();

        private PendingFilesQueue() {
        }

        public synchronized void add(File localFile, String remotePath, boolean isDirectory) {
            if (this.remoteAbsPaths.add(remotePath)) {
                this.queue.add(new PendingFile(localFile, remotePath, isDirectory));
            }
        }

        public synchronized PendingFile take() throws InterruptedException {
            PendingFile pendingFile = this.queue.take();
            this.remoteAbsPaths.remove(pendingFile.remotePath);
            return pendingFile;
        }

        public synchronized PendingFile poll(long timeout, TimeUnit unit) throws InterruptedException {
            PendingFile pendingFile = this.queue.poll(timeout, unit);
            if (pendingFile != null) {
                this.remoteAbsPaths.remove(pendingFile.remotePath);
            }
            return pendingFile;
        }

        public synchronized List<String> getPendingFiles() {
            return Collections.unmodifiableList(new ArrayList<String>(this.remoteAbsPaths));
        }

        public int size() {
            return this.remoteAbsPaths.size();
        }
    }

    private static class PendingFile {
        public final File localFile;
        public final String remotePath;
        private final boolean isDirectory;

        public PendingFile(File localFile, String remotePath, boolean isDirectory) {
            this.localFile = localFile;
            this.remotePath = remotePath;
            this.isDirectory = isDirectory;
        }
    }
}

