/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.j2ee.sun.persistence.mapping.core;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.FieldHolderState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.FieldState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.PairHolderState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.PairState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.TableState;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.ReferenceKey;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class RelationshipState
extends FieldState
implements PairHolderState,
Cloneable {
    public static final int LOCAL = 0;
    public static final int ASSOCIATED = 1;
    private static final int TABLE_THRESHHOLD = 50;
    private PairState _columnsPairState;
    private PairState _associatedColumnsPairState;
    private String _relatedClass;
    private RelationshipElement _relatedField;
    private String _joinTable;
    private boolean _useJoin;

    public RelationshipState(FieldHolderState declaringHolder, RelationshipElement field) {
        super(declaringHolder, (PersistenceFieldElement)field);
        Model model = this.getModel();
        this._columnsPairState = new PairState(model, this, this.getColumns());
        this._associatedColumnsPairState = new PairState(model, this, new ArrayList());
    }

    public Object clone() {
        RelationshipState clonedState = (RelationshipState)super.clone();
        clonedState._columnsPairState = (PairState)this._columnsPairState.clone();
        clonedState._columnsPairState.setColumns(clonedState.getColumns());
        clonedState._associatedColumnsPairState = (PairState)this._associatedColumnsPairState.clone();
        return clonedState;
    }

    public String getDebugInfo() {
        StringBuffer lDump = new StringBuffer(super.getDebugInfo());
        lDump.append("\tRelated class is " + this.getRelatedClass() + "\n");
        lDump.append("\tRelated field is " + this.getRelatedField() + "\n");
        return lDump.toString();
    }

    protected String getColumnDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        lDump.append(this.getColumnPairState().getDebugInfo());
        if (this.isJoinRelationship()) {
            lDump.append("\tMapped to Join Columns\n");
            lDump.append(this._associatedColumnsPairState.getDebugInfo());
        }
        return lDump.toString();
    }

    public boolean isJoinRelationship() {
        return this._useJoin;
    }

    public void setJoinRelationship(boolean flag) {
        this._useJoin = flag;
    }

    public String getJoinTable() {
        return this._joinTable;
    }

    public void setJoinTable(TableElement table) {
        this._joinTable = table != null ? table.getName().getName() : null;
    }

    public TableState getTableState() {
        return this.getFieldHolderState().getTableState();
    }

    protected void setMapping(List columns) {
        super.setMapping(columns);
        if (columns == null || columns.size() == 0) {
            this.getAssociatedColumnPairState().setColumnPairs((ColumnPairElement[])null);
        }
    }

    public boolean hasInvalidMapping() {
        return this.getColumnPairState().hasInvalidPairs() && (!this.isJoinRelationship() || this.getAssociatedColumnPairState().hasInvalidPairs());
    }

    protected List getLocalColumns() {
        Iterator iterator = this.getColumnPairState().getCompletePairs().iterator();
        ArrayList<String> localList = new ArrayList<String>();
        while (iterator.hasNext()) {
            localList.add(((String[])iterator.next())[0]);
        }
        return localList;
    }

    public boolean hasPairAt(int type, int index) {
        return this.getPairState(type).hasPairAt(index);
    }

    public PairState getColumnPairState() {
        return this._columnsPairState;
    }

    private PairState getPairState(int type) {
        return type == 0 ? this.getColumnPairState() : this.getAssociatedColumnPairState();
    }

    public PairState getAssociatedColumnPairState() {
        return this._associatedColumnsPairState;
    }

    public void addColumnPair(ColumnElement localColumn, ColumnElement foreignColumn, int type) {
        this.getPairState(type).addColumnPair(localColumn, foreignColumn);
    }

    public void editColumnPair(int index, ColumnElement localColumn, ColumnElement foreignColumn, int type) {
        this.getPairState(type).editColumnPair(index, localColumn, foreignColumn);
    }

    public void removeColumnPair(int index, int type) {
        this.getPairState(type).removeColumnPair(index);
    }

    public String getRelatedClass() {
        return this._relatedClass;
    }

    public void setRelatedClass(String relatedClass) {
        this._relatedClass = relatedClass;
    }

    public RelationshipElement getRelatedField() {
        return this._relatedField;
    }

    public void setRelatedField(RelationshipElement relatedField) {
        this._relatedField = relatedField;
    }

    protected static List getSortedRelatedFieldCandidates(FieldHolderState holder, RelationshipElement field) {
        Model model;
        PersistenceClassElement relatedPClass;
        ArrayList<String> returnList = new ArrayList<String>();
        String relatedClassName = holder.getCurrentRelatedClass(field);
        if (relatedClassName != null && (relatedPClass = (model = holder.getModel()).getPersistenceClass(relatedClassName)) != null) {
            RelationshipElement[] candidateRels = relatedPClass.getRelationships();
            String thisClassName = holder.getMappingClassElement().getName();
            int count = candidateRels != null ? candidateRels.length : 0;
            for (int i = 0; i < count; ++i) {
                RelationshipState relFieldState;
                FieldHolderState relatedState;
                RelationshipElement relatedField;
                String candidateRelatedClass;
                RelationshipElement candidate = candidateRels[i];
                if (candidate == field || 0 != candidate.getPersistenceType() || !thisClassName.equals(candidateRelatedClass = holder.getCurrentRelatedClass(candidate)) && (!RelationshipState.isCollection(candidate, model) || candidateRelatedClass != null) || (relatedField = (relatedState = holder.getRelatedState(candidate.getDeclaringClass().getName(), true)).getCurrentRelatedField(candidate)) != null && relatedField != field) continue;
                RelationshipState lField = holder.getCurrentStateForField(field);
                RelationshipState relationshipState = relFieldState = relatedState == null ? null : relatedState.getCurrentStateForField(candidate);
                if (!RelationshipState.isInverseMapping(lField, relFieldState)) continue;
                returnList.add(candidate.getName());
            }
        }
        Collections.sort(returnList, Collator.getInstance());
        return returnList;
    }

    protected static RelationshipState getMappedStateForField(FieldHolderState holder, RelationshipElement field) {
        MappingClassElement mappingClass;
        MappingFieldElement mappingField;
        if (field != null && (mappingField = (mappingClass = holder.getMappingClassElement()).getField(field.getName())) != null && mappingField instanceof MappingRelationshipElement) {
            RelationshipState state = new RelationshipState(holder, field);
            ArrayList locals = ((MappingRelationshipElement)mappingField).getAssociatedColumns();
            state.setRelatedClass(holder.getMappedRelatedClass(field));
            state.setRelatedField(holder.getMappedRelatedField(field));
            state.getColumnPairState().addColumnPairs(mappingField.getColumns());
            if (locals != null && locals.size() > 0) {
                PairState associatedPairState = state.getAssociatedColumnPairState();
                state.setJoinRelationship(true);
                associatedPairState.addColumnPairs(locals);
                state._joinTable = associatedPairState.getDeclaringTableName();
            }
            return state;
        }
        return null;
    }

    protected static RelationshipState getDefaultStateForField(FieldHolderState holder, RelationshipElement field, TableElement joinTable, boolean useJoin, boolean mustMatchFlag) {
        boolean hasJoin;
        RelationshipState state = mustMatchFlag ? null : RelationshipState.getInverseStateForField(holder, field);
        boolean bl = hasJoin = joinTable != null;
        if (mustMatchFlag) {
            if (!useJoin) {
                state = RelationshipState.getDefaultStateForField(holder, field, true);
                if (state != null && state.isJoinRelationship()) {
                    state = null;
                }
            } else {
                state = RelationshipState.getDefaultStateForField(holder, field, joinTable);
            }
        } else if (state == null || !state.getColumnPairState().hasCompleteRows()) {
            RelationshipState relationshipState = state = useJoin && hasJoin ? RelationshipState.getDefaultStateForField(holder, field, joinTable) : RelationshipState.getDefaultStateForField(holder, field);
            if (state == null) {
                state = !useJoin ? RelationshipState.getDefaultStateForField(holder, field, joinTable) : RelationshipState.getDefaultStateForField(holder, field);
            }
        }
        return state;
    }

    private static RelationshipState getDefaultStateForField(FieldHolderState holder, RelationshipElement field, TableElement joinTable) {
        SchemaElement schema;
        TableState tableState = holder.getTableState();
        TableElement relatedPrimary = holder.getPrimaryTable(holder.getCurrentRelatedClass(field));
        TableElement primary = tableState.getCurrentPrimaryTable();
        ReferenceKey[] keys = RelationshipState.findKeys(holder, primary, relatedPrimary, joinTable);
        if (keys == null && joinTable == null && (schema = tableState.getCurrentSchema()) != null && primary != null && relatedPrimary != null) {
            String primaryName = primary.getName().getName();
            String relatedName = relatedPrimary.getName().getName();
            String schemaName = schema.getName().getFullName();
            TableElement candidate = TableElement.forName((String)NameUtil.getAbsoluteTableName((String)schemaName, (String)(primaryName + relatedName)));
            keys = RelationshipState.findKeys(holder, primary, relatedPrimary, candidate);
            if (keys != null) {
                joinTable = candidate;
            } else {
                candidate = TableElement.forName((String)NameUtil.getAbsoluteTableName((String)schemaName, (String)(relatedName + primaryName)));
                keys = RelationshipState.findKeys(holder, primary, relatedPrimary, candidate);
                if (keys != null) {
                    joinTable = candidate;
                } else if (schema != null) {
                    int count;
                    TableElement[] lTableList = schema != null ? schema.getTables() : null;
                    int n = count = lTableList != null ? lTableList.length : 0;
                    if (count > 50) {
                        return null;
                    }
                    for (int i = 0; i < count; ++i) {
                        candidate = lTableList[i];
                        keys = RelationshipState.findKeys(holder, primary, relatedPrimary, candidate);
                        if (keys == null) continue;
                        joinTable = candidate;
                        break;
                    }
                }
            }
        }
        if (keys != null) {
            return RelationshipState.getStateForKeys(holder, field, joinTable, keys[0], keys[1]);
        }
        return null;
    }

    private static RelationshipState getDefaultStateForField(FieldHolderState holder, RelationshipElement field, boolean mustMatch) {
        TableElement myPrimary = holder.getTableState().getCurrentPrimaryTable();
        TableElement relatedPrimary = holder.getPrimaryTable(holder.getCurrentRelatedClass(field));
        ReferenceKey key = RelationshipState.findKey(holder, myPrimary, relatedPrimary);
        RelationshipState state = null;
        if (key != null) {
            state = RelationshipState.getStateForKey(holder, field, key);
        } else if (relatedPrimary != null) {
            PairState pairState = null;
            boolean hasComplete = false;
            state = holder.getMappedStateForField(field);
            pairState = state != null ? state.getColumnPairState() : null;
            boolean bl = hasComplete = pairState != null && pairState.hasCompleteRows();
            if (state != null && !hasComplete && !pairState.hasInvalidPairs()) {
                state = null;
            }
            if (state != null && hasComplete) {
                List columnPairs = !state.isJoinRelationship() ? pairState.getAllColumnPairs() : state.getAssociatedColumnPairState().getAllColumnPairs();
                Iterator iterator = columnPairs.iterator();
                String[] firstPair = (String[])iterator.next();
                if (myPrimary == null || !myPrimary.getName().getName().equals(NameUtil.getTableName((String)firstPair[0])) || !relatedPrimary.getName().getName().equals(NameUtil.getTableName((String)firstPair[1]))) {
                    state = null;
                }
            }
        }
        if (!mustMatch && state == null) {
            state = RelationshipState.getDefaultStateForField(holder, field, null);
        }
        return state;
    }

    public static RelationshipState getDefaultStateForField(FieldHolderState holder, RelationshipElement field) {
        return RelationshipState.getDefaultStateForField(holder, field, false);
    }

    public static RelationshipState getInverseStateForState(FieldHolderState holder, RelationshipState relatedState) {
        RelationshipElement relatedField;
        RelationshipState state = null;
        if (relatedState != null && (relatedField = relatedState.getRelatedField()) != null) {
            String relatedClass = relatedState.getRelatedClass();
            if (relatedState != null) {
                boolean isJoin = relatedState.isJoinRelationship();
                List relatedPairs = relatedState.getColumnPairState().getCompletePairs();
                Collection inversePairs = RelationshipState.getInversePairs(isJoin ? relatedState.getAssociatedColumnPairState().getCompletePairs() : relatedPairs);
                state = new RelationshipState(holder, relatedField);
                state.setRelatedField((RelationshipElement)relatedState.getField());
                state.setRelatedClass(state.getRelatedField().getDeclaringClass().getName());
                state.setJoinRelationship(isJoin);
                state.getColumnPairState().addColumnPairs(inversePairs);
                if (isJoin) {
                    state._joinTable = relatedState.getJoinTable();
                    state.getAssociatedColumnPairState().addColumnPairs(RelationshipState.getInversePairs(relatedPairs));
                }
            }
        }
        return state;
    }

    public static RelationshipState getInverseStateForField(FieldHolderState holder, RelationshipElement field) {
        RelationshipElement relatedField;
        RelationshipState state = null;
        if (field != null && (relatedField = holder.getCurrentRelatedField(field)) != null) {
            String relatedClass = holder.getCurrentRelatedClass(field);
            RelationshipState relatedState = holder.getRelatedState(field).getCurrentStateForField(relatedField);
            if (relatedState != null) {
                relatedState.setRelatedField(field);
                state = RelationshipState.getInverseStateForState(holder, relatedState);
            }
        }
        return state;
    }

    private static RelationshipState getStateForKey(FieldHolderState holder, RelationshipElement field, ReferenceKey key) {
        RelationshipState state = null;
        if (key != null) {
            TableState tableState = holder.getTableState();
            TableElement testTable = tableState.getCurrentPrimaryTable();
            boolean sameTable = key.getDeclaringTable().equals((Object)testTable);
            TableElement relatedPrimary = holder.getPrimaryTable(holder.getCurrentRelatedClass(field));
            boolean selfRef = relatedPrimary != null && testTable.equals((Object)relatedPrimary);
            ColumnPairElement[] pairs = key.getColumnPairs();
            PairState pairState = null;
            state = new RelationshipState(holder, field);
            state.setRelatedClass(holder.getCurrentRelatedClass(field));
            state.setRelatedField(holder.getCurrentRelatedField(field));
            pairState = state.getColumnPairState();
            if (selfRef && RelationshipState.isCollection(field, holder.getModel()) || !sameTable) {
                pairState.addColumnPairs(RelationshipState.getInversePairs(pairs));
            } else {
                pairState.addColumnPairs(pairs);
            }
        }
        return state;
    }

    private static RelationshipState getStateForKeys(FieldHolderState holder, RelationshipElement field, TableElement joinTable, ReferenceKey key1, ReferenceKey key2) {
        RelationshipState state = null;
        if (key1 != null && key2 != null) {
            ColumnPairElement[] pairs = key1.getColumnPairs();
            PairState pairState = null;
            state = new RelationshipState(holder, field);
            state.setRelatedClass(holder.getCurrentRelatedClass(field));
            state.setRelatedField(holder.getCurrentRelatedField(field));
            state.setJoinRelationship(true);
            state.setJoinTable(joinTable);
            pairState = state.getColumnPairState();
            if (!key1.getDeclaringTable().equals((Object)holder.getTableState().getCurrentPrimaryTable())) {
                pairState.addColumnPairs(RelationshipState.getInversePairs(pairs));
            } else {
                pairState.addColumnPairs(pairs);
            }
            pairState = state.getAssociatedColumnPairState();
            pairs = key2.getColumnPairs();
            if (!key2.getDeclaringTable().equals((Object)joinTable)) {
                pairState.addColumnPairs(RelationshipState.getInversePairs(pairs));
            } else {
                pairState.addColumnPairs(pairs);
            }
        }
        return state;
    }

    private static ReferenceKey findKey(FieldHolderState holder, TableElement primaryTable, TableElement secondaryTable) {
        TableState myState = holder.getTableState();
        ForeignKeyElement key = TableState.findForeignKey(primaryTable, secondaryTable);
        if (key == null && secondaryTable != null) {
            key = myState.findCurrentKey(primaryTable, secondaryTable.getName().getName());
        }
        if (key == null && (key = TableState.findForeignKey(secondaryTable, primaryTable)) == null && primaryTable != null) {
            key = myState.findCurrentKey(secondaryTable, primaryTable.getName().getName());
        }
        return key;
    }

    private static ReferenceKey[] findKeys(FieldHolderState holder, TableElement primary, TableElement relatedPrimary, TableElement joinCandidate) {
        if (joinCandidate != null) {
            ReferenceKey key1 = RelationshipState.findKey(holder, primary, joinCandidate);
            ReferenceKey key2 = RelationshipState.findKey(holder, joinCandidate, relatedPrimary);
            if (key1 != null && key2 != null && key1 != key2) {
                return new ReferenceKey[]{key1, key2};
            }
        }
        return null;
    }

    private static boolean isInverseMapping(RelationshipState state1, RelationshipState state2) {
        boolean state2HasRows;
        boolean state1IsNotNull = state1 != null;
        boolean state2IsNotNull = state2 != null;
        PairState pairState1 = state1IsNotNull ? state1.getColumnPairState() : null;
        PairState pairState2 = state2IsNotNull ? state2.getColumnPairState() : null;
        boolean state1HasRows = state1IsNotNull && pairState1.hasCompleteRows();
        boolean bl = state2HasRows = state2IsNotNull && pairState2.hasCompleteRows();
        if (state1HasRows && state2HasRows) {
            boolean state1IsJoin = state1.isJoinRelationship();
            if (state1IsJoin == state2.isJoinRelationship()) {
                List pairs1 = pairState1.getCompletePairs();
                List pairs2 = pairState2.getCompletePairs();
                return !state1IsJoin ? RelationshipState.isInverseMapping(pairs1, pairs2) : RelationshipState.isInverseMapping(pairs1, state2.getAssociatedColumnPairState().getCompletePairs()) && RelationshipState.isInverseMapping(state1.getAssociatedColumnPairState().getCompletePairs(), pairs2);
            }
            return false;
        }
        return true;
    }

    private static boolean isInverseMapping(List pairs1, List pairs2) {
        int size2;
        int size1 = pairs1.size();
        if (size1 == (size2 = pairs2.size())) {
            for (int i = 0; i < size1; ++i) {
                String[] inversePair;
                String[] nextPair = (String[])pairs1.get(i);
                if (nextPair[0].equals((inversePair = (String[])pairs2.get(i))[1]) && nextPair[1].equals(inversePair[0])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Collection getInversePairs(ColumnPairElement[] originalPairs) {
        return RelationshipState.getInversePairs(Arrays.asList(originalPairs));
    }

    private static Collection getInversePairs(Collection originalPairs) {
        ArrayList<Object> inversePairs = null;
        if (originalPairs != null) {
            Iterator iterator = originalPairs.iterator();
            inversePairs = new ArrayList<Object>(originalPairs.size());
            while (iterator.hasNext()) {
                inversePairs.add(RelationshipState.getInversePair(iterator.next()));
            }
        }
        return inversePairs;
    }

    private static Object getInversePair(Object originalPair) {
        if (originalPair != null) {
            String local = null;
            Object foreign = null;
            if (originalPair instanceof String[]) {
                local = ((String[])originalPair)[0];
                if (local != null & (foreign = ((String[])originalPair)[1]) != null) {
                    return new String[]{(String)foreign, local};
                }
            } else if (originalPair instanceof ColumnPairElement) {
                local = ((ColumnPairElement)originalPair).getLocalColumn();
                foreign = ((ColumnPairElement)originalPair).getReferencedColumn();
            } else if (originalPair instanceof ColumnElement[]) {
                local = ((ColumnElement[])originalPair)[0];
                foreign = ((ColumnElement[])originalPair)[1];
            }
            if (local != null & foreign != null) {
                return new ColumnElement[]{foreign, (ColumnElement)local};
            }
        }
        return null;
    }

    protected static boolean isCollection(RelationshipElement field, Model model) {
        String fieldType = model.getFieldType(field.getDeclaringClass().getName(), field.getName());
        return model.isCollection(fieldType);
    }
}

