/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int MAX_HEADER_SIZE = 1024;
    private long sizeMax = -1L;
    private String headerEncoding;

    public static final boolean isMultipartContent(RequestContext ctx) {
        String contentType = ctx.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static final boolean isMultipartContent(HttpServletRequest req) {
        if (!"post".equals(req.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public List parseRequest(HttpServletRequest req) throws FileUploadException {
        return this.parseRequest(new ServletRequestContext(req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseRequest(RequestContext ctx) throws FileUploadException {
        if (ctx == null) {
            throw new NullPointerException("ctx parameter");
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = ctx.getContentType();
        if (null == contentType || !contentType.toLowerCase().startsWith(MULTIPART)) {
            throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        int requestSize = ctx.getContentLength();
        if (requestSize == -1) {
            throw new UnknownSizeException("the request was rejected because its size is unknown");
        }
        if (this.sizeMax >= 0L && (long)requestSize > this.sizeMax) {
            throw new SizeLimitExceededException("the request was rejected because its size (" + requestSize + ") exceeds the configured maximum (" + this.sizeMax + ")", requestSize, this.sizeMax);
        }
        String charEncoding = this.headerEncoding;
        if (charEncoding == null) {
            charEncoding = ctx.getCharacterEncoding();
        }
        try {
            byte[] boundary = this.getBoundary(contentType);
            if (boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            InputStream input = ctx.getInputStream();
            MultipartStream multi = new MultipartStream(input, boundary);
            multi.setHeaderEncoding(charEncoding);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = this.getHeader(headers, CONTENT_TYPE);
                    if (subContentType != null && subContentType.toLowerCase().startsWith(MULTIPART_MIXED)) {
                        byte[] subBoundary = this.getBoundary(subContentType);
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                FileItem item = this.createItem(headers, false);
                                OutputStream os = item.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                }
                                finally {
                                    os.close();
                                }
                                items.add(item);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else {
                        FileItem item = this.createItem(headers, this.getFileName(headers) == null);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        items.add(item);
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            throw new FileUploadException("Processing of multipart/form-data request failed. " + e.getMessage());
        }
        return items;
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(contentType, ';');
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    protected String getFileName(Map headers) {
        String cdl;
        String fileName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && ((cdl = cd.toLowerCase()).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(cd, ';');
            if (params.containsKey("filename")) {
                fileName = (String)params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    protected String getFieldName(Map headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && cd.toLowerCase().startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(cd, ';');
            fieldName = (String)params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected FileItem createItem(Map headers, boolean isFormField) throws FileUploadException {
        return this.getFileItemFactory().createItem(this.getFieldName(headers), this.getHeader(headers, CONTENT_TYPE), isFormField, this.getFileName(headers));
    }

    protected Map parseHeaders(String headerPart) {
        HashMap<String, String> headers = new HashMap<String, String>();
        char[] buffer = new char[1024];
        boolean done = false;
        int j = 0;
        try {
            while (!done) {
                int i = 0;
                while (i < 2 || buffer[i - 2] != '\r' || buffer[i - 1] != '\n') {
                    buffer[i++] = headerPart.charAt(j++);
                }
                String header = new String(buffer, 0, i - 2);
                if (header.equals("")) {
                    done = true;
                    continue;
                }
                if (header.indexOf(58) == -1) continue;
                String headerName = header.substring(0, header.indexOf(58)).trim().toLowerCase();
                String headerValue = header.substring(header.indexOf(58) + 1).trim();
                if (this.getHeader(headers, headerName) != null) {
                    headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
                    continue;
                }
                headers.put(headerName, headerValue);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return headers;
    }

    protected final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }

    public static class SizeLimitExceededException
    extends FileUploadException {
        private long actual;
        private long permitted;

        public SizeLimitExceededException() {
        }

        public SizeLimitExceededException(String message) {
            super(message);
        }

        public SizeLimitExceededException(String message, long actual, long permitted) {
            super(message);
            this.actual = actual;
            this.permitted = permitted;
        }

        public long getActualSize() {
            return this.actual;
        }

        public long getPermittedSize() {
            return this.permitted;
        }
    }

    public static class UnknownSizeException
    extends FileUploadException {
        public UnknownSizeException() {
        }

        public UnknownSizeException(String message) {
            super(message);
        }
    }

    public static class InvalidContentTypeException
    extends FileUploadException {
        public InvalidContentTypeException() {
        }

        public InvalidContentTypeException(String message) {
            super(message);
        }
    }
}

