/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.MultiMapImpl;
import org.ini4j.OptionMap;
import org.ini4j.spi.BeanAccess;
import org.ini4j.spi.BeanTool;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionMapImpl
extends MultiMapImpl<String, String>
implements OptionMap {
    private static final char SUBST_CHAR = '$';
    private static final String SYSTEM_PROPERTY_PREFIX = "@prop/";
    private static final String ENVIRONMENT_PREFIX = "@env/";
    private static final int SYSTEM_PROPERTY_PREFIX_LEN = "@prop/".length();
    private static final int ENVIRONMENT_PREFIX_LEN = "@env/".length();
    private static final Pattern EXPRESSION = Pattern.compile("(?<!\\\\)\\$\\{(([^\\[]+)(\\[([0-9]+)\\])?)\\}");
    private static final int G_OPTION = 2;
    private static final int G_INDEX = 4;
    private BeanAccess _defaultBeanAccess;

    @Override
    public <T> T as(Class<T> clazz) {
        return BeanTool.getInstance().proxy(clazz, this.getDefaultBeanAccess());
    }

    @Override
    public <T> T as(Class<T> clazz, String keyPrefix) {
        return BeanTool.getInstance().proxy(clazz, this.newBeanAccess(keyPrefix));
    }

    @Override
    public String fetch(Object key) {
        int len = this.length(key);
        return len == 0 ? null : this.fetch(key, len - 1);
    }

    @Override
    public String fetch(Object key, int index) {
        String value = (String)this.get(key, index);
        if (value != null && value.indexOf(36) >= 0) {
            StringBuffer buffer = new StringBuffer(value);
            this.resolve(buffer);
            value = buffer.toString();
        }
        return value;
    }

    @Override
    public void from(Object bean) {
        BeanTool.getInstance().inject(this.getDefaultBeanAccess(), bean);
    }

    @Override
    public void from(Object bean, String keyPrefix) {
        BeanTool.getInstance().inject(this.newBeanAccess(keyPrefix), bean);
    }

    @Override
    public void to(Object bean) {
        BeanTool.getInstance().inject(bean, this.getDefaultBeanAccess());
    }

    @Override
    public void to(Object bean, String keyPrefix) {
        BeanTool.getInstance().inject(bean, this.newBeanAccess(keyPrefix));
    }

    protected synchronized BeanAccess getDefaultBeanAccess() {
        if (this._defaultBeanAccess == null) {
            this._defaultBeanAccess = this.newBeanAccess();
        }
        return this._defaultBeanAccess;
    }

    protected BeanAccess newBeanAccess() {
        return new Access();
    }

    protected BeanAccess newBeanAccess(String propertyNamePrefix) {
        return new Access(propertyNamePrefix);
    }

    protected void resolve(StringBuffer buffer) {
        Matcher m = EXPRESSION.matcher(buffer);
        while (m.find()) {
            String value;
            int index;
            String name = m.group(2);
            int n = index = m.group(4) == null ? -1 : Integer.parseInt(m.group(4));
            if (name.startsWith(ENVIRONMENT_PREFIX)) {
                value = System.getenv(name.substring(ENVIRONMENT_PREFIX_LEN));
            } else if (name.startsWith(SYSTEM_PROPERTY_PREFIX)) {
                value = System.getProperty(name.substring(SYSTEM_PROPERTY_PREFIX_LEN));
            } else {
                String string = value = index == -1 ? this.fetch(name) : this.fetch(name, index);
            }
            if (value == null) continue;
            buffer.replace(m.start(), m.end(), value);
            m.reset(buffer);
        }
    }

    protected class Access
    implements BeanAccess {
        private final String _prefix;

        protected Access() {
            this(null);
        }

        protected Access(String prefix) {
            this._prefix = prefix;
        }

        public void propAdd(String propertyName, String value) {
            OptionMapImpl.this.add(this.transform(propertyName), value);
        }

        public String propDel(String propertyName) {
            return (String)OptionMapImpl.this.remove(this.transform(propertyName));
        }

        public String propGet(String propertyName) {
            return OptionMapImpl.this.fetch(this.transform(propertyName));
        }

        public String propGet(String propertyName, int index) {
            return OptionMapImpl.this.fetch(this.transform(propertyName), index);
        }

        public int propLength(String propertyName) {
            return OptionMapImpl.this.length(this.transform(propertyName));
        }

        public String propSet(String propertyName, String value) {
            return OptionMapImpl.this.put(this.transform(propertyName), value);
        }

        public String propSet(String propertyName, String value, int index) {
            return OptionMapImpl.this.put(this.transform(propertyName), value, index);
        }

        private String transform(String orig) {
            return orig == null ? null : (this._prefix == null ? orig : this._prefix + orig);
        }
    }
}

