/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.form.RefactoringInfo;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;

public class GuardedBlockHandlerFactoryImpl
implements GuardedBlockHandlerFactory {
    public GuardedBlockHandler createInstance(AbstractRefactoring abstractRefactoring) {
        RefactoringInfo refactoringInfo = (RefactoringInfo)abstractRefactoring.getContext().lookup(RefactoringInfo.class);
        return new GuardedBlockHandlerImpl(refactoringInfo);
    }

    private static class GuardedBlockInfo {
        private String blockName;
        private int originalPosition;
        private String originalText;
        private Set<ChangeInfo> changes = new TreeSet<ChangeInfo>();

        GuardedBlockInfo(SimpleSection simpleSection) {
            this.blockName = simpleSection.getName();
            this.originalPosition = simpleSection.getStartPosition().getOffset();
            this.originalText = simpleSection.getText();
        }

        boolean containsPosition(ModificationResult.Difference difference) {
            int n = difference.getStartPosition().getOffset();
            return n >= this.originalPosition && n < this.originalPosition + this.originalText.length();
        }

        void addChange(ModificationResult.Difference difference) {
            this.changes.add(new ChangeInfo(difference.getStartPosition().getOffset() - this.originalPosition, difference.getOldText() != null ? difference.getOldText().length() : 0, difference.getNewText()));
        }

        String getName() {
            return this.blockName;
        }

        String getNewSectionText() {
            if (this.changes.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                for (ChangeInfo changeInfo : this.changes) {
                    stringBuilder.append(this.originalText.substring(n, changeInfo.startPos));
                    if (changeInfo.newText != null) {
                        stringBuilder.append(changeInfo.newText);
                    }
                    n = changeInfo.startPos + changeInfo.length;
                }
                stringBuilder.append(this.originalText.substring(n));
                return stringBuilder.toString();
            }
            return null;
        }

        private static class ChangeInfo
        implements Comparable<ChangeInfo> {
            private int startPos;
            private int length;
            private String newText;

            ChangeInfo(int n, int n2, String string) {
                this.startPos = n;
                this.length = n2;
                this.newText = string;
            }

            @Override
            public int compareTo(ChangeInfo changeInfo) {
                return this.startPos - changeInfo.startPos;
            }
        }
    }

    private static class GuardedBlockUpdate
    implements Transaction {
        private FormEditorSupport formEditorSupport;
        private List<GuardedBlockInfo> guardedInfos;

        GuardedBlockUpdate(FormEditorSupport formEditorSupport) {
            this.formEditorSupport = formEditorSupport;
            this.guardedInfos = new ArrayList<GuardedBlockInfo>(2);
            this.guardedInfos.add(new GuardedBlockInfo(formEditorSupport.getInitComponentSection()));
            this.guardedInfos.add(new GuardedBlockInfo(formEditorSupport.getVariablesSection()));
        }

        void addChange(ModificationResult.Difference difference) {
            for (GuardedBlockInfo guardedBlockInfo : this.guardedInfos) {
                if (!guardedBlockInfo.containsPosition(difference)) continue;
                guardedBlockInfo.addChange(difference);
                break;
            }
        }

        public void commit() {
            for (GuardedBlockInfo guardedBlockInfo : this.guardedInfos) {
                String string = guardedBlockInfo.getNewSectionText();
                if (string == null) continue;
                this.formEditorSupport.getGuardedSectionManager().findSimpleSection(guardedBlockInfo.getName()).setText(string);
            }
        }

        public void rollback() {
        }
    }

    private static class GuardedBlockHandlerImpl
    implements GuardedBlockHandler {
        private RefactoringInfo refInfo;
        private Map<FileObject, GuardedBlockUpdate> guardedUpdates;
        private boolean first = true;

        public GuardedBlockHandlerImpl(RefactoringInfo refactoringInfo) {
            this.refInfo = refactoringInfo;
        }

        public Problem handleChange(RefactoringElementImplementation refactoringElementImplementation, Collection<RefactoringElementImplementation> collection, Collection<Transaction> collection2) {
            ModificationResult.Difference difference;
            if (this.refInfo == null) {
                return null;
            }
            FileObject fileObject = refactoringElementImplementation.getParentFile();
            if (!RefactoringInfo.isJavaFileOfForm(fileObject)) {
                return null;
            }
            FormRefactoringUpdate formRefactoringUpdate = this.refInfo.getUpdateForFile(fileObject);
            formRefactoringUpdate.setGaurdedCodeChanging(true);
            boolean bl = false;
            boolean bl2 = false;
            if (this.refInfo.containsOriginalFile(fileObject)) {
                switch (this.refInfo.getChangeType()) {
                    case VARIABLE_RENAME: 
                    case CLASS_RENAME: 
                    case EVENT_HANDLER_RENAME: {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case CLASS_MOVE: {
                        if (this.refInfo.getOriginalFiles().length != 1) break;
                        bl2 = true;
                    }
                }
            } else if (this.first) {
                collection.add(formRefactoringUpdate.getPreviewElement());
                this.first = false;
            }
            if (bl && !formRefactoringUpdate.prepareForm(true)) {
                return new Problem(true, "Error loading form. Cannot update generated code.");
            }
            if (!bl2 && (difference = (ModificationResult.Difference)refactoringElementImplementation.getLookup().lookup(ModificationResult.Difference.class)) != null) {
                GuardedBlockUpdate guardedBlockUpdate;
                if (this.guardedUpdates == null) {
                    this.guardedUpdates = new HashMap<FileObject, GuardedBlockUpdate>();
                    guardedBlockUpdate = null;
                } else {
                    guardedBlockUpdate = this.guardedUpdates.get(fileObject);
                }
                if (guardedBlockUpdate == null) {
                    guardedBlockUpdate = new GuardedBlockUpdate(formRefactoringUpdate.getFormDataObject().getFormEditorSupport());
                    this.guardedUpdates.put(fileObject, guardedBlockUpdate);
                }
                guardedBlockUpdate.addChange(difference);
                collection2.add(guardedBlockUpdate);
            }
            collection2.add(formRefactoringUpdate);
            return null;
        }
    }
}

