/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class RailsUrlDisplayer {
    private static final Logger LOGGER = Logger.getLogger(RailsUrlDisplayer.class.getName());
    private static boolean NO_BROWSER = Boolean.getBoolean("rails.nobrowser");

    RailsUrlDisplayer() {
    }

    static void showURL(String contextRoot, String relativeUrl, int port, boolean runClientDebugger, RailsProject project) {
        if (NO_BROWSER) {
            return;
        }
        LOGGER.fine("Opening URL: http://localhost:" + port + "/" + relativeUrl);
        try {
            URL url = new URL("http://localhost:" + port + contextRoot + "/" + relativeUrl);
            if (!runClientDebugger) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            } else {
                FileObject projectDocBase = project.getRakeProjectHelper().resolveFileObject("public");
                String hostPrefix = "http://localhost:" + port + "/";
                HtmlBrowser.Factory browser = null;
                browser = WebClientToolsProjectUtils.isInternetExplorer((Project)project) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
                if (browser == null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                    return;
                }
                LocationMappersFactory mapperFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
                Lookup debuggerLookup = null;
                if (mapperFactory != null) {
                    URI appContext = new URI(hostPrefix);
                    HashMap<String, String> extendedInfo = null;
                    FileObject welcomeFile = projectDocBase.getFileObject("index.html");
                    if (welcomeFile != null) {
                        extendedInfo = new HashMap<String, String>();
                        extendedInfo.put("welcome-file", "index.html");
                    }
                    JSToNbJSLocationMapper forwardMapper = mapperFactory.getJSToNbJSLocationMapper(projectDocBase, appContext, extendedInfo);
                    NbJSToJSLocationMapper reverseMapper = mapperFactory.getNbJSToJSLocationMapper(projectDocBase, appContext, extendedInfo);
                    debuggerLookup = Lookups.fixed((Object[])new Object[]{forwardMapper, reverseMapper, project});
                } else {
                    debuggerLookup = Lookups.fixed((Object[])new Object[]{project});
                }
                WebClientToolsSessionStarterService.startSession((URI)url.toURI(), (HtmlBrowser.Factory)browser, (Lookup)debuggerLookup);
            }
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (WebClientToolsSessionException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }
}

