/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.plugins;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.ruby.railsprojects.plugins.InstallationSettingsPanel;
import org.netbeans.modules.ruby.railsprojects.plugins.NewUrlPanel;
import org.netbeans.modules.ruby.railsprojects.plugins.Plugin;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginManager;
import org.netbeans.modules.ruby.railsprojects.plugins.RepositorySelectionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class PluginPanel
extends JPanel {
    static final String MSG_WAIT = NbBundle.getMessage(PluginPanel.class, (String)"PleaseWait");
    static final String MSG_NO_NETWORK = NbBundle.getMessage(PluginPanel.class, (String)"NoNetwork");
    static final String MSG_FETCHING_LOCAL_REPOS = NbBundle.getMessage(PluginPanel.class, (String)"FetchingLocalRepos");
    static final String MSG_FETCHING_REMOTE_REPOS = NbBundle.getMessage(PluginPanel.class, (String)"FetchingRemoteRepos");
    static final String MSG_FETCHING_LOCAL_PLUGINS = NbBundle.getMessage(PluginPanel.class, (String)"FetchingLocalPlugins");
    static final String MSG_FETCHING_REMOTE_PLUGINS = NbBundle.getMessage(PluginPanel.class, (String)"FetchingRemotePlugins");
    private final PluginManager pluginManager;
    private List<Plugin> installedPlugins;
    private List<Plugin> newPlugins;
    private List<String> activeRepositories;
    private boolean installedInitialized;
    private boolean newInitialized;
    private boolean repositoriesInitialized;
    private boolean installedModified;
    private boolean newModified;
    private boolean repositoriesModified;
    private boolean pluginsModified;
    private JButton addUrlButton;
    private JButton discoverButton;
    private JLabel instSearchLbl;
    private JTextField instSearchText;
    private JButton installButton;
    private JList installedList;
    private JPanel installedPanel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList newList;
    private JPanel newPanel;
    private JLabel newSearchLbl;
    private JTabbedPane pluginsTab;
    private JButton proxyButton;
    private JButton reloadInstalledButton;
    private JButton reloadNewButton;
    private JButton reloadReposButton;
    private JLabel repSearchLbl;
    private JList repositoryList;
    private JPanel repositoryPanel;
    private JTextField searchNewText;
    private JTextField searchReposText;
    private JButton uninstallButton;
    private JButton unregisterButton;
    private JButton updateAllButton;
    private JButton updateButton;

    public PluginPanel(PluginManager pluginManager) {
        Parameters.notNull((CharSequence)"pluginManager", (Object)pluginManager);
        this.initComponents();
        this.pluginManager = pluginManager;
    }

    public boolean isModified() {
        return this.pluginsModified;
    }

    private void refreshInstalled() {
        this.refreshPluginList(this.getPluginFilter(true), true, this.installedList, true);
        this.pluginsModified = this.pluginsModified || this.installedModified;
        this.installedModified = false;
    }

    private void refreshNew() {
        this.refreshPluginList(this.getPluginFilter(false), true, this.newList, false);
        this.newModified = false;
    }

    private void refreshRepositories() {
        this.refreshRepositoryList(this.getRepositoryFilter(false), true, this.repositoryList, true);
        this.repositoriesModified = false;
    }

    private void initComponents() {
        this.pluginsTab = new JTabbedPane();
        this.installedPanel = new JPanel();
        this.instSearchText = new JTextField();
        this.instSearchLbl = new JLabel();
        this.reloadInstalledButton = new JButton();
        this.uninstallButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.installedList = new JList();
        this.updateButton = new JButton();
        this.updateAllButton = new JButton();
        this.newPanel = new JPanel();
        this.searchNewText = new JTextField();
        this.newSearchLbl = new JLabel();
        this.reloadNewButton = new JButton();
        this.installButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.newList = new JList();
        this.repositoryPanel = new JPanel();
        this.searchReposText = new JTextField();
        this.repSearchLbl = new JLabel();
        this.reloadReposButton = new JButton();
        this.unregisterButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.repositoryList = new JList();
        this.discoverButton = new JButton();
        this.addUrlButton = new JButton();
        this.jPanel1 = new JPanel();
        this.proxyButton = new JButton();
        FormListener formListener = new FormListener();
        this.installedPanel.addComponentListener(formListener);
        this.instSearchText.setColumns(14);
        this.instSearchText.addActionListener(formListener);
        this.instSearchLbl.setLabelFor(this.instSearchText);
        Mnemonics.setLocalizedText((JLabel)this.instSearchLbl, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.instSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadInstalledButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadInstalledButton.text"));
        this.reloadInstalledButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.uninstallButton.text"));
        this.uninstallButton.setEnabled(false);
        this.uninstallButton.addActionListener(formListener);
        this.jScrollPane1.setViewportView(this.installedList);
        this.installedList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installedList.AccessibleContext.accessibleName"));
        this.installedList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installedList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.updateAllButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateAllButton.text"));
        this.updateAllButton.addActionListener(formListener);
        GroupLayout installedPanelLayout = new GroupLayout((Container)this.installedPanel);
        this.installedPanel.setLayout((LayoutManager)installedPanelLayout);
        installedPanelLayout.setHorizontalGroup((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 692, Short.MAX_VALUE).add(2, (GroupLayout.Group)installedPanelLayout.createSequentialGroup().add((Component)this.reloadInstalledButton).addPreferredGap(0, 376, Short.MAX_VALUE).add((Component)this.instSearchLbl).addPreferredGap(0).add((Component)this.instSearchText, -2, 156, -2)).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().add((Component)this.uninstallButton).addPreferredGap(0).add((Component)this.updateButton).addPreferredGap(0).add((Component)this.updateAllButton))).addContainerGap()));
        installedPanelLayout.setVerticalGroup((GroupLayout.Group)installedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)installedPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)installedPanelLayout.createParallelGroup(3).add((Component)this.instSearchLbl).add((Component)this.reloadInstalledButton).add((Component)this.instSearchText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 352, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)installedPanelLayout.createParallelGroup(3).add((Component)this.uninstallButton).add((Component)this.updateAllButton).add((Component)this.updateButton)).addContainerGap()));
        this.instSearchText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.instSearchText.AccessibleContext.accessibleDescription"));
        this.reloadInstalledButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadInstalledButton.AccessibleContext.accessibleDescription"));
        this.uninstallButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.uninstallButton.AccessibleContext.accessibleDescription"));
        this.updateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateButton.AccessibleContext.accessibleDescription"));
        this.updateAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.updateAllButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installedPanel.TabConstraints.tabTitle"), this.installedPanel);
        this.newPanel.addComponentListener(formListener);
        this.searchNewText.setColumns(14);
        this.searchNewText.addActionListener(formListener);
        this.newSearchLbl.setLabelFor(this.searchNewText);
        Mnemonics.setLocalizedText((JLabel)this.newSearchLbl, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadNewButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadNewButton.text"));
        this.reloadNewButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installButton.text"));
        this.installButton.setEnabled(false);
        this.installButton.addActionListener(formListener);
        this.jScrollPane2.setViewportView(this.newList);
        this.newList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newList.AccessibleContext.accessibleName"));
        this.newList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newList.AccessibleContext.accessibleDescription"));
        GroupLayout newPanelLayout = new GroupLayout((Container)this.newPanel);
        this.newPanel.setLayout((LayoutManager)newPanelLayout);
        newPanelLayout.setHorizontalGroup((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add((GroupLayout.Group)newPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 692, Short.MAX_VALUE).add(2, (GroupLayout.Group)newPanelLayout.createSequentialGroup().add((Component)this.reloadNewButton).addPreferredGap(0, 376, Short.MAX_VALUE).add((Component)this.newSearchLbl).addPreferredGap(0).add((Component)this.searchNewText, -2, 156, -2)).add((Component)this.installButton)).addContainerGap()));
        newPanelLayout.setVerticalGroup((GroupLayout.Group)newPanelLayout.createParallelGroup(1).add((GroupLayout.Group)newPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)newPanelLayout.createParallelGroup(3).add((Component)this.newSearchLbl).add((Component)this.reloadNewButton).add((Component)this.searchNewText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 352, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.installButton).addContainerGap()));
        this.searchNewText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.searchNewText.AccessibleContext.accessibleDescription"));
        this.reloadNewButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadNewButton.AccessibleContext.accessibleDescription"));
        this.installButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.installButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.newPanel.TabConstraints.tabTitle"), this.newPanel);
        this.repositoryPanel.addComponentListener(formListener);
        this.searchReposText.setColumns(14);
        this.searchReposText.addActionListener(formListener);
        this.repSearchLbl.setLabelFor(this.searchReposText);
        Mnemonics.setLocalizedText((JLabel)this.repSearchLbl, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repSearchLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reloadReposButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadReposButton.text"));
        this.reloadReposButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.unregisterButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.unregisterButton.text"));
        this.unregisterButton.setEnabled(false);
        this.unregisterButton.addActionListener(formListener);
        this.jScrollPane3.setViewportView(this.repositoryList);
        this.repositoryList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repositoryList.AccessibleContext.accessibleName"));
        this.repositoryList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repositoryList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.discoverButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.discoverButton.text"));
        this.discoverButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.addUrlButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.addUrlButton.text"));
        this.addUrlButton.addActionListener(formListener);
        GroupLayout repositoryPanelLayout = new GroupLayout((Container)this.repositoryPanel);
        this.repositoryPanel.setLayout((LayoutManager)repositoryPanelLayout);
        repositoryPanelLayout.setHorizontalGroup((GroupLayout.Group)repositoryPanelLayout.createParallelGroup(1).add((GroupLayout.Group)repositoryPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)repositoryPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 692, Short.MAX_VALUE).add(2, (GroupLayout.Group)repositoryPanelLayout.createSequentialGroup().add((Component)this.discoverButton).addPreferredGap(1).add((Component)this.addUrlButton).addPreferredGap(1).add((Component)this.reloadReposButton).addPreferredGap(0, 144, Short.MAX_VALUE).add((Component)this.repSearchLbl).addPreferredGap(0).add((Component)this.searchReposText, -2, 156, -2)).add((Component)this.unregisterButton)).addContainerGap()));
        repositoryPanelLayout.setVerticalGroup((GroupLayout.Group)repositoryPanelLayout.createParallelGroup(1).add((GroupLayout.Group)repositoryPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)repositoryPanelLayout.createParallelGroup(3).add((Component)this.repSearchLbl).add((Component)this.searchReposText, -2, -1, -2).add((Component)this.discoverButton).add((Component)this.addUrlButton).add((Component)this.reloadReposButton)).addPreferredGap(0).add((Component)this.jScrollPane3, -1, 352, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.unregisterButton).addContainerGap()));
        this.searchReposText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.searchReposText.AccessibleContext.accessibleDescription"));
        this.reloadReposButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.reloadReposButton.AccessibleContext.accessibleDescription"));
        this.unregisterButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.unregisterButton.AccessibleContext.accessibleDescription"));
        this.discoverButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.discoverButton.AccessibleContext.accessibleDescription"));
        this.addUrlButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.addUrlButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.repositoryPanel.TabConstraints.tabTitle"), this.repositoryPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).addContainerGap(564, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.proxyButton).addContainerGap(406, Short.MAX_VALUE)));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.pluginsTab.addTab(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pluginsTab, -1, 721, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pluginsTab, -1, 468, Short.MAX_VALUE).addContainerGap()));
        this.pluginsTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.pluginsTab.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"PluginPanel.AccessibleContext.accessibleDescription"));
    }

    private void reloadNewButtonActionPerformed(ActionEvent evt) {
        this.refreshNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUrlButtonActionPerformed(ActionEvent evt) {
        String url;
        assert (SwingUtilities.isEventDispatchThread());
        NewUrlPanel panel = new NewUrlPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(PluginPanel.class, (String)"AddUrl"));
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(descriptor);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION && (url = panel.getUrl()) != null) {
            this.pluginManager.addRepositories(new String[]{url}, this, null, true, new RepositoryListRefresher(this.repositoryList, true));
            this.newModified = true;
            this.repositoriesModified = true;
        }
    }

    private void proxyButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverButtonActionPerformed(ActionEvent evt) {
        Object[] urls;
        assert (SwingUtilities.isEventDispatchThread());
        RepositorySelectionPanel panel = new RepositorySelectionPanel();
        JList list = panel.getList();
        list.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos.List"));
        list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos.List.AccessibleContext.accessibleDescription"));
        list.setSelectionMode(2);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos"));
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(descriptor);
            dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginPanel.class, (String)"SelectRepos.AccessibleContext.accessibleDescription"));
            this.refreshRepositoryList(null, true, list, false);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION && (urls = list.getSelectedValues()) != null && urls.length > 0) {
            ArrayList<String> reps = new ArrayList<String>(urls.length);
            for (int i = 0; i < urls.length; ++i) {
                if (this.isMsg(urls[i])) continue;
                reps.add(urls[i].toString());
            }
            if (!reps.isEmpty()) {
                this.pluginManager.addRepositories(reps.toArray(new String[reps.size()]), this, null, true, new RepositoryListRefresher(this.repositoryList, true));
                this.newModified = true;
                this.repositoriesModified = true;
            }
        }
    }

    private boolean isMsg(Object object) {
        return MSG_WAIT.equals(object) || MSG_NO_NETWORK.equals(object) || MSG_FETCHING_LOCAL_REPOS.equals(object) || MSG_FETCHING_REMOTE_REPOS.equals(object) || MSG_FETCHING_LOCAL_PLUGINS.equals(object) || MSG_FETCHING_REMOTE_PLUGINS.equals(object);
    }

    private void searchNewTextActionPerformed(ActionEvent evt) {
        this.refreshPluginList(this.getPluginFilter(false), false, this.newList, false);
    }

    private void searchReposTextActionPerformed(ActionEvent evt) {
        this.refreshRepositoryList(this.getRepositoryFilter(true), false, this.repositoryList, true);
    }

    private void reloadReposButtonActionPerformed(ActionEvent evt) {
        this.refreshRepositories();
    }

    private void unregisterButtonActionPerformed(ActionEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] indices = this.repositoryList.getSelectedIndices();
        ArrayList<String> repositories = new ArrayList<String>();
        if (indices != null) {
            for (int index : indices) {
                assert (index >= 0);
                String o = this.repositoryList.getModel().getElementAt(index).toString();
                if (MSG_WAIT.equals(o)) continue;
                repositories.add(o);
            }
        }
        if (repositories.size() > 0) {
            RepositoryListRefresher completionTask = new RepositoryListRefresher(this.repositoryList, true);
            this.pluginManager.removeRepositories(repositories.toArray(new String[repositories.size()]), this, null, true, completionTask);
            this.repositoriesModified = true;
            this.newModified = true;
        }
    }

    private void repositoryPanelComponentShown(ComponentEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.repositoriesInitialized) {
            this.repositoriesInitialized = true;
            this.repositoryList.setSelectionMode(2);
            this.repositoryList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent ev) {
                    if (ev.getValueIsAdjusting()) {
                        return;
                    }
                    int index = PluginPanel.this.repositoryList.getSelectedIndex();
                    PluginPanel.this.unregisterButton.setEnabled(index != -1);
                }
            });
            this.repositoriesModified = true;
        }
        if (this.repositoriesModified) {
            this.refreshRepositories();
        }
    }

    private void newPanelComponentShown(ComponentEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.newInitialized) {
            this.newInitialized = true;
            this.newList.setSelectionMode(2);
            this.newList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.newList, new JButton[]{this.installButton}));
            this.newModified = true;
        }
        if (this.newModified) {
            this.refreshNew();
        }
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        Plugin plugin;
        assert (SwingUtilities.isEventDispatchThread());
        int[] indices = this.newList.getSelectedIndices();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (int index : indices) {
            Object o = this.newList.getModel().getElementAt(index);
            if (!(o instanceof Plugin)) continue;
            plugin = (Plugin)o;
            plugins.add(plugin);
        }
        if (plugins.size() > 0) {
            for (Plugin chosen : plugins) {
                InstallationSettingsPanel panel = new InstallationSettingsPanel(chosen);
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(PluginPanel.class, (String)"ChoosePluginSettings"));
                dd.setOptionType(2);
                dd.setModal(true);
                dd.setHelpCtx(new HelpCtx(InstallationSettingsPanel.class));
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (!result.equals(NotifyDescriptor.OK_OPTION)) continue;
                plugin = new Plugin(panel.getPluginName(), null);
                PluginListRefresher completionTask = new PluginListRefresher(this.newList, false);
                boolean changed = this.pluginManager.install(new Plugin[]{plugin}, this, null, panel.isSvnExternals(), panel.isSvnCheckout(), panel.getRevision(), true, completionTask);
                this.installedModified = this.installedModified || changed;
            }
        }
    }

    private void instSearchTextActionPerformed(ActionEvent evt) {
        this.refreshPluginList(this.getPluginFilter(true), false, this.installedList, true);
    }

    private void updateAllButtonActionPerformed(ActionEvent evt) {
        PluginListRefresher completionTask = new PluginListRefresher(this.installedList, true);
        this.pluginManager.update(null, null, null, this, true, completionTask);
        this.installedModified = true;
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] indices = this.installedList.getSelectedIndices();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (indices != null) {
            for (int index : indices) {
                assert (index >= 0);
                Object o = this.installedList.getModel().getElementAt(index);
                if (!(o instanceof Plugin)) continue;
                Plugin plugin = (Plugin)o;
                plugins.add(plugin);
            }
        }
        if (plugins.size() > 0) {
            PluginListRefresher completionTask = new PluginListRefresher(this.installedList, true);
            this.pluginManager.update(plugins.toArray(new Plugin[plugins.size()]), null, null, this, true, completionTask);
            this.installedModified = true;
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        int[] indices = this.installedList.getSelectedIndices();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (indices != null) {
            for (int index : indices) {
                assert (index >= 0);
                Object o = this.installedList.getModel().getElementAt(index);
                if (!(o instanceof Plugin)) continue;
                Plugin plugin = (Plugin)o;
                plugins.add(plugin);
            }
        }
        if (plugins.size() > 0) {
            PluginListRefresher completionTask = new PluginListRefresher(this.installedList, true);
            this.pluginManager.uninstall(plugins.toArray(new Plugin[plugins.size()]), null, this, true, completionTask);
            this.installedModified = true;
        }
    }

    private void reloadInstalledButtonActionPerformed(ActionEvent evt) {
        this.refreshInstalled();
    }

    private void installedPanelComponentShown(ComponentEvent evt) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.installedInitialized) {
            this.installedInitialized = true;
            this.installedList.setSelectionMode(2);
            this.installedList.getSelectionModel().addListSelectionListener(new MyListSelectionListener(this.installedList, new JButton[]{this.updateButton, this.uninstallButton}));
            this.installedModified = true;
        }
        if (this.installedModified) {
            this.refreshInstalled();
        }
    }

    private void refreshPluginList(final String filter, final boolean refresh, final JList list, final boolean local) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean showRefreshMessage = true;
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    List plugins;
                    final DefaultListModel<Object> model = new DefaultListModel<Object>();
                    ArrayList<String> lines = new ArrayList<String>(500);
                    if (local) {
                        if (refresh || PluginPanel.this.installedPlugins == null) {
                            PluginPanel.this.installedPlugins = PluginPanel.this.pluginManager.getInstalledPlugins(true, null, lines);
                        }
                        plugins = PluginPanel.this.installedPlugins;
                    } else {
                        if (refresh || PluginPanel.this.newPlugins == null) {
                            PluginPanel.this.newPlugins = PluginPanel.this.pluginManager.getAvailablePlugins(true, null, lines);
                        }
                        plugins = PluginPanel.this.newPlugins;
                    }
                    Pattern pattern = null;
                    String lcFilter = null;
                    if (filter != null && (filter.indexOf(42) != -1 || filter.indexOf(94) != -1 || filter.indexOf(36) != -1)) {
                        try {
                            pattern = Pattern.compile(filter, 2);
                        }
                        catch (PatternSyntaxException pse) {}
                    } else if (filter != null) {
                        lcFilter = filter.toLowerCase();
                    }
                    for (Plugin plugin : plugins) {
                        if (filter == null || filter.length() == 0) {
                            model.addElement(plugin);
                            continue;
                        }
                        if (pattern == null) {
                            if (lcFilter != null) {
                                String lcRepository;
                                String lcPlugin = plugin.getName().toLowerCase();
                                if (lcPlugin.indexOf(lcFilter) != -1) {
                                    model.addElement(plugin);
                                    continue;
                                }
                                if (plugin.getRepository() == null || (lcRepository = plugin.getRepository().toLowerCase()).indexOf(lcFilter) == -1) continue;
                                model.addElement(plugin);
                                continue;
                            }
                            model.addElement(plugin);
                            continue;
                        }
                        if (!pattern.matcher(plugin.getName()).find() && (plugin.getRepository() == null || !pattern.matcher(plugin.getRepository()).find())) continue;
                        model.addElement(plugin);
                    }
                    if (refresh && plugins.size() == 0) {
                        if (!local) {
                            model.addElement(MSG_NO_NETWORK);
                        }
                        for (String line : lines) {
                            model.addElement("<html><span color=\"red\">" + line + "</span></html>");
                        }
                    }
                    final int pluginsCount = plugins.size();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String tabTitle;
                            list.clearSelection();
                            list.setModel(model);
                            list.invalidate();
                            list.repaint();
                            if (pluginsCount > 0) {
                                list.setSelectedIndex(0);
                            }
                            int tabIndex = local ? 0 : 1;
                            String originalTabTitle = tabTitle = PluginPanel.this.pluginsTab.getTitleAt(tabIndex);
                            int index = tabTitle.lastIndexOf(40);
                            if (index != -1) {
                                tabTitle = tabTitle.substring(0, index);
                            }
                            if (!(tabTitle = tabTitle + "(" + pluginsCount + ")").equals(originalTabTitle)) {
                                PluginPanel.this.pluginsTab.setTitleAt(tabIndex, tabTitle);
                            }
                        }
                    });
                }
            }
        };
        if (refresh || local && this.installedPlugins == null || !local && this.newPlugins == null) {
            if (showRefreshMessage) {
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement(local ? MSG_FETCHING_LOCAL_PLUGINS : MSG_FETCHING_REMOTE_PLUGINS);
                list.setModel(model);
            }
            RequestProcessor.getDefault().post(runner, 50);
        } else {
            runner.run();
        }
    }

    private void refreshRepositoryList(final String filter, final boolean refresh, final JList list, final boolean local) {
        assert (SwingUtilities.isEventDispatchThread());
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    List repositories;
                    final DefaultListModel<String> model = new DefaultListModel<String>();
                    ArrayList lines = new ArrayList(500);
                    if (local) {
                        if (refresh || PluginPanel.this.activeRepositories == null) {
                            PluginPanel.this.activeRepositories = PluginPanel.this.pluginManager.getRepositories(local);
                        }
                        repositories = PluginPanel.this.activeRepositories;
                    } else {
                        repositories = PluginPanel.this.pluginManager.getRepositories(local);
                    }
                    Pattern pattern = null;
                    String lcFilter = null;
                    if (filter != null && (filter.indexOf(42) != -1 || filter.indexOf(94) != -1 || filter.indexOf(36) != -1)) {
                        try {
                            pattern = Pattern.compile(filter, 2);
                        }
                        catch (PatternSyntaxException pse) {}
                    } else if (filter != null) {
                        lcFilter = filter.toLowerCase();
                    }
                    Collections.sort(repositories);
                    for (String repository : repositories) {
                        if (filter == null || filter.length() == 0) {
                            model.addElement(repository);
                            continue;
                        }
                        if (pattern == null) {
                            if (lcFilter != null) {
                                String lcRepository = repository.toLowerCase();
                                if (lcRepository.indexOf(lcFilter) == -1) continue;
                                model.addElement(repository);
                                continue;
                            }
                            model.addElement(repository);
                            continue;
                        }
                        if (!pattern.matcher(repository).find()) continue;
                        model.addElement(repository);
                    }
                    if (refresh && repositories.size() == 0) {
                        model.addElement(MSG_NO_NETWORK);
                        for (String line : lines) {
                            model.addElement("<html><span color=\"red\">" + line + "</span></html>");
                        }
                    }
                    final int repositoryCount = repositories.size();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            list.clearSelection();
                            list.setModel(model);
                            list.invalidate();
                            list.repaint();
                            if (repositoryCount > 0) {
                                list.setSelectedIndex(0);
                            }
                        }
                    });
                }
            }
        };
        if (refresh || local && this.activeRepositories == null || !local) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            model.addElement(local ? MSG_FETCHING_LOCAL_REPOS : MSG_FETCHING_REMOTE_REPOS);
            list.setModel(model);
            RequestProcessor.getDefault().post(runner, 50);
        } else {
            runner.run();
        }
    }

    private String getRepositoryFilter(boolean local) {
        assert (SwingUtilities.isEventDispatchThread());
        String filter = null;
        if (local && (filter = this.searchReposText.getText().trim()).length() == 0) {
            filter = null;
        }
        return filter;
    }

    private String getPluginFilter(boolean local) {
        assert (SwingUtilities.isEventDispatchThread());
        String filter = null;
        JTextField tf = local ? this.instSearchText : this.searchNewText;
        filter = tf.getText().trim();
        if (filter.length() == 0) {
            filter = null;
        }
        return filter;
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private JButton[] buttons;
        private JList list;

        private MyListSelectionListener(JList list, JButton[] buttons) {
            this.list = list;
            this.buttons = buttons;
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            Object o;
            if (ev.getValueIsAdjusting()) {
                return;
            }
            int index = this.list.getSelectedIndex();
            if (index != -1 && (o = this.list.getModel().getElementAt(index)) instanceof Plugin) {
                for (JButton button : this.buttons) {
                    button.setEnabled(true);
                }
                return;
            }
            for (JButton button : this.buttons) {
                button.setEnabled(index != -1);
            }
        }
    }

    private class RepositoryListRefresher
    implements Runnable {
        private JList list;
        private boolean local;

        public RepositoryListRefresher(JList list, boolean local) {
            this.list = list;
            this.local = local;
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            PluginPanel.this.refreshRepositoryList(PluginPanel.this.getRepositoryFilter(this.local), true, this.list, this.local);
            if (this.list == PluginPanel.this.repositoryList) {
                PluginPanel.this.repositoriesModified = false;
            }
        }
    }

    private class PluginListRefresher
    implements Runnable {
        private JList list;
        private boolean local;

        public PluginListRefresher(JList list, boolean local) {
            this.list = list;
            this.local = local;
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            PluginPanel.this.refreshPluginList(PluginPanel.this.getPluginFilter(this.local), true, this.list, this.local);
            if (this.list == PluginPanel.this.newList) {
                PluginPanel.this.newModified = false;
            } else if (this.list == PluginPanel.this.installedList) {
                PluginPanel.this.pluginsModified = PluginPanel.this.pluginsModified || PluginPanel.this.installedModified;
                PluginPanel.this.installedModified = false;
            }
        }
    }

    private class FormListener
    implements ActionListener,
    ComponentListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == PluginPanel.this.instSearchText) {
                PluginPanel.this.instSearchTextActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.reloadInstalledButton) {
                PluginPanel.this.reloadInstalledButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.uninstallButton) {
                PluginPanel.this.uninstallButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.updateButton) {
                PluginPanel.this.updateButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.updateAllButton) {
                PluginPanel.this.updateAllButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.searchNewText) {
                PluginPanel.this.searchNewTextActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.reloadNewButton) {
                PluginPanel.this.reloadNewButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.installButton) {
                PluginPanel.this.installButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.searchReposText) {
                PluginPanel.this.searchReposTextActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.reloadReposButton) {
                PluginPanel.this.reloadReposButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.unregisterButton) {
                PluginPanel.this.unregisterButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.discoverButton) {
                PluginPanel.this.discoverButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.addUrlButton) {
                PluginPanel.this.addUrlButtonActionPerformed(evt);
            } else if (evt.getSource() == PluginPanel.this.proxyButton) {
                PluginPanel.this.proxyButtonActionPerformed(evt);
            }
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            if (evt.getSource() == PluginPanel.this.installedPanel) {
                PluginPanel.this.installedPanelComponentShown(evt);
            } else if (evt.getSource() == PluginPanel.this.newPanel) {
                PluginPanel.this.newPanelComponentShown(evt);
            } else if (evt.getSource() == PluginPanel.this.repositoryPanel) {
                PluginPanel.this.repositoryPanelComponentShown(evt);
            }
        }
    }
}

