/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.plugins;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.plugins.Plugin;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginAction;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginProgressPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PluginManager {
    private static final String PLUGIN_CUSTOMIZER = "plugin.rb";
    private RailsProject project;
    private List<Plugin> installed;
    private static List<Plugin> available;
    private static List<Plugin> cachedAvailable;

    public PluginManager(RailsProject project) {
        this.project = project;
    }

    private FileObject getPluginDir() {
        FileObject pluginDirPath = this.project.getProjectDirectory().getFileObject("vendor/plugins");
        return pluginDirPath;
    }

    public String getPluginProblem() {
        FileObject pluginDirPath = this.getPluginDir();
        if (pluginDirPath == null) {
            return NbBundle.getMessage(PluginAction.class, (String)"CannotFindPluginRepository");
        }
        File pluginDir = FileUtil.toFile((FileObject)pluginDirPath);
        if (!pluginDir.canWrite()) {
            return NbBundle.getMessage(PluginAction.class, (String)"PluginNotWritable");
        }
        return null;
    }

    public boolean isPluginInstalled(String pluginName) {
        FileObject dir = this.getPluginDir();
        return dir != null && dir.getFileObject(pluginName) != null;
    }

    public List<Plugin> getInstalledPlugins(boolean refresh, String sourceRepository, List<String> lines) {
        if (refresh || this.installed == null || this.installed.size() == 0) {
            this.installed = new ArrayList<Plugin>(40);
            this.refreshList(this.installed, sourceRepository, true, lines);
        }
        return this.installed;
    }

    public List<Plugin> getAvailablePlugins(boolean refresh, String sourceRepository, List<String> lines) {
        if (refresh || available == null || available.size() == 0) {
            available = new ArrayList<Plugin>(300);
            this.refreshList(available, sourceRepository, false, lines);
            if (available.size() > 1) {
                this.updateCachedList(lines);
            }
        }
        return available;
    }

    public boolean hasUptodateAvailableList() {
        return false;
    }

    public List<Plugin> getCachedAvailablePlugins() {
        return null;
    }

    private void refreshList(List<Plugin> list, String sourceRepository, boolean local, List<String> lines) {
        list.clear();
        ArrayList<String> argList = new ArrayList<String>();
        if (sourceRepository != null) {
            argList.add("-s");
            argList.add(sourceRepository);
        }
        if (local) {
            argList.add("--local");
        } else {
            argList.add("--remote");
        }
        String[] args = argList.toArray(new String[argList.size()]);
        boolean ok = this.pluginRunner("list", null, null, lines, args);
        if (ok) {
            this.parsePluginList(lines, list, local);
            Collections.sort(list);
        }
    }

    private void parsePluginList(List<String> lines, List<Plugin> pluginList, boolean local) {
        Plugin plugin = null;
        boolean listStarted = false;
        for (String line : lines) {
            char c;
            int i;
            if (line.trim().length() == 0 || line.startsWith("/") || line.startsWith("Discovering plugins in ")) continue;
            StringBuilder sb = new StringBuilder();
            int length = line.length();
            for (i = 0; i < length && !Character.isWhitespace(c = line.charAt(i)); ++i) {
                sb.append(c);
            }
            String name = sb.toString();
            while (i < length && !Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            while (i < length && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            String repository = null;
            if (i < length) {
                char c2;
                sb = new StringBuilder();
                while (i < length && !Character.isWhitespace(c2 = line.charAt(i))) {
                    sb.append(c2);
                    ++i;
                }
                if (sb.length() > 0) {
                    repository = sb.toString();
                }
            }
            plugin = new Plugin(name, repository);
            pluginList.add(plugin);
        }
    }

    private void asynchPluginRunner(final JComponent parent, String description, final String successMessage, final String failureMessage, final List<String> lines, final Runnable successCompletionTask, final String command, final String ... commandArgs) {
        final Cursor originalCursor = parent.getCursor();
        Cursor busy = Cursor.getPredefinedCursor(3);
        parent.setCursor(busy);
        final JButton closeButton = new JButton(NbBundle.getMessage(PluginManager.class, (String)"CTL_Close"));
        final JButton cancelButton = new JButton(NbBundle.getMessage(PluginManager.class, (String)"CTL_Cancel"));
        closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginManager.class, (String)"AD_Close"));
        Object[] options = new Object[]{closeButton, cancelButton};
        closeButton.setEnabled(false);
        final PluginProgressPanel progress = new PluginProgressPanel(NbBundle.getMessage(PluginManager.class, (String)"PluginPleaseWait"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)progress, description, true, options, (Object)closeButton, 0, new HelpCtx(PluginProgressPanel.class), null);
        descriptor.setModal(true);
        final Process[] processHolder = new Process[1];
        final Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                dlg.setVisible(false);
                dlg.dispose();
                parent.setCursor(originalCursor);
            }
        });
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean succeeded = PluginManager.this.pluginRunner(command, progress, processHolder, lines, commandArgs);
                    closeButton.setEnabled(true);
                    cancelButton.setEnabled(false);
                    progress.done(succeeded ? successMessage : failureMessage);
                    if (succeeded && successCompletionTask != null) {
                        successCompletionTask.run();
                    }
                }
                finally {
                    parent.setCursor(originalCursor);
                }
            }
        };
        RequestProcessor.getDefault().post(runner, 50);
        dlg.setVisible(true);
        if (descriptor.getValue() == DialogDescriptor.CANCEL_OPTION || descriptor.getValue() == cancelButton) {
            parent.setCursor(originalCursor);
            cancelButton.setEnabled(false);
            Process process = processHolder[0];
            if (process != null) {
                process.destroy();
                dlg.setVisible(false);
                dlg.dispose();
            }
        }
    }

    private List<String> getPluginCmd() {
        ArrayList<String> pluginCmd = new ArrayList<String>(2);
        if (RailsProjectUtil.getRailsVersion((Project)this.project).isRails3OrHigher()) {
            pluginCmd.add("script" + File.separator + "rails");
            pluginCmd.add("plugin");
        } else {
            pluginCmd.add("script" + File.separator + "plugin");
        }
        return pluginCmd;
    }

    private boolean pluginRunner(String command, PluginProgressPanel progressPanel, Process[] processHolder, List<String> lines, String ... commandArgs) {
        FileObject plugin;
        boolean succeeded;
        int exitCode;
        block21: {
            ArrayList<String> argList = new ArrayList<String>();
            RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
            File cmd = new File(platform.getInterpreter());
            if (!cmd.getName().startsWith("jruby") || ExecutionUtils.launchJRubyScript()) {
                argList.add(cmd.getPath());
            }
            argList.addAll(ExecutionUtils.getRubyArgs((RubyPlatform)platform));
            argList.add("-r" + PluginManager.getPluginCustomizer().getAbsolutePath());
            argList.addAll(this.getPluginCmd());
            argList.add(command);
            for (String arg : commandArgs) {
                argList.add(arg);
            }
            String[] args = argList.toArray(new String[argList.size()]);
            ProcessBuilder pb = new ProcessBuilder(args);
            File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            pb.directory(pwd);
            pb.redirectErrorStream(true);
            Util.adjustProxy((ProcessBuilder)pb);
            RubyExecutionDescriptor descriptor = new RubyExecutionDescriptor(platform, "plugin", pb.directory()).cmd(cmd);
            ExecutionUtils.setupProcessEnvironment(pb.environment(), (String)descriptor.getCmd().getParent(), (boolean)descriptor.getAppendJdkToPath());
            if (lines == null) {
                lines = new ArrayList<String>(40);
            }
            exitCode = -1;
            try {
                String message;
                String line;
                BufferedReader br;
                InputStreamReader isr;
                InputStream is;
                Process process;
                block20: {
                    process = pb.start();
                    if (processHolder != null) {
                        processHolder[0] = process;
                    }
                    is = process.getInputStream();
                    if (progressPanel != null) {
                        progressPanel.setProcessInput(process.getOutputStream());
                    }
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    try {
                        while ((line = br.readLine()) != null) {
                            if (progressPanel != null) {
                                progressPanel.appendOutput(line);
                            }
                            lines.add(line);
                        }
                    }
                    catch (IOException ioe) {
                        message = "*** Plugin Process Killed ***\n";
                        lines.add(message);
                        if (progressPanel == null) break block20;
                        progressPanel.appendOutput(message);
                    }
                }
                if ((exitCode = process.waitFor()) == 0) break block21;
                try {
                    is = process.getErrorStream();
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (progressPanel != null) {
                            progressPanel.appendOutput(line);
                        }
                        lines.add(line);
                    }
                }
                catch (IOException ioe) {
                    message = "*** Plugin Process Killed ***\n";
                    lines.add(message);
                    if (progressPanel != null) {
                        progressPanel.appendOutput(message);
                    }
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (InterruptedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        boolean bl = succeeded = exitCode == 0;
        if (succeeded && "remove".equals(command) && commandArgs != null && commandArgs[0] != null && (plugin = this.project.getProjectDirectory().getFileObject("vendor/plugins/" + commandArgs[0])) != null) {
            try {
                plugin.delete();
            }
            catch (IOException ex) {
                succeeded = false;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return succeeded;
    }

    public boolean install(Plugin[] plugins, JComponent parent, String sourceRepository, boolean svnExternals, boolean svnCheckout, String revision, boolean asynchronous, Runnable asyncCompletionTask) {
        ArrayList<String> argList = new ArrayList<String>();
        if (sourceRepository != null) {
            argList.add("-s");
            argList.add(sourceRepository);
        }
        for (Plugin plugin : plugins) {
            argList.add(plugin.getName());
        }
        if (svnExternals) {
            argList.add("--externals");
        } else if (svnCheckout) {
            argList.add("--checkout");
        }
        if (revision != null && (svnExternals || svnCheckout)) {
            argList.add("--revision");
            argList.add(revision);
        }
        argList.add("--force");
        String[] args = argList.toArray(new String[argList.size()]);
        String title = NbBundle.getMessage(PluginManager.class, (String)"Installation");
        String success = NbBundle.getMessage(PluginManager.class, (String)"InstallationOk");
        String failure = NbBundle.getMessage(PluginManager.class, (String)"InstallationFailed");
        String pluginCmd = "install";
        if (asynchronous) {
            this.asynchPluginRunner(parent, title, success, failure, null, asyncCompletionTask, pluginCmd, args);
            return false;
        }
        boolean ok = this.pluginRunner(pluginCmd, null, null, null, args);
        return ok;
    }

    public boolean uninstall(Plugin[] plugins, String sourceRepository, JComponent parent, boolean asynchronous, Runnable asyncCompletionTask) {
        ArrayList<String> argList = new ArrayList<String>();
        if (sourceRepository != null) {
            argList.add("-s");
            argList.add(sourceRepository);
        }
        int nameIndex = argList.size();
        argList.add("placeholder");
        String[] args = argList.toArray(new String[argList.size()]);
        String title = NbBundle.getMessage(PluginManager.class, (String)"Uninstallation");
        String success = NbBundle.getMessage(PluginManager.class, (String)"UninstallationOk");
        String failure = NbBundle.getMessage(PluginManager.class, (String)"UninstallationFailed");
        String pluginCmd = "remove";
        if (asynchronous) {
            for (Plugin plugin : plugins) {
                args[nameIndex] = plugin.getName();
                this.asynchPluginRunner(parent, title, success, failure, null, asyncCompletionTask, pluginCmd, args);
            }
            return false;
        }
        boolean ok = true;
        for (Plugin plugin : plugins) {
            args[nameIndex] = plugin.getName();
            if (this.pluginRunner(pluginCmd, null, null, null, args)) continue;
            ok = false;
        }
        return ok;
    }

    public boolean update(Plugin[] plugins, String revision, String sourceRepository, JComponent parent, boolean asynchronous, Runnable asyncCompletionTask) {
        ArrayList<String> argList = new ArrayList<String>();
        if (sourceRepository != null) {
            argList.add("-s");
            argList.add(sourceRepository);
        }
        assert (revision == null || revision.length() == 0 || plugins.length == 1);
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                argList.add(plugin.getName());
            }
        }
        if (revision != null) {
            argList.add("--revision");
            argList.add(revision);
        }
        String[] args = argList.toArray(new String[argList.size()]);
        String title = NbBundle.getMessage(PluginManager.class, (String)"Update");
        String success = NbBundle.getMessage(PluginManager.class, (String)"UpdateOk");
        String failure = NbBundle.getMessage(PluginManager.class, (String)"UpdateFailed");
        String pluginCmd = "update";
        if (asynchronous) {
            this.asynchPluginRunner(parent, title, success, failure, null, asyncCompletionTask, pluginCmd, args);
            return false;
        }
        boolean ok = this.pluginRunner(pluginCmd, null, null, null, args);
        return ok;
    }

    public boolean removeRepositories(String[] repositories, JComponent parent, ProgressHandle progressHandle, boolean asynchronous, Runnable asyncCompletionTask) {
        return this.modifyRepositories("unsource", repositories, parent, progressHandle, asynchronous, asyncCompletionTask);
    }

    public boolean addRepositories(String[] repositories, JComponent parent, ProgressHandle progressHandle, boolean asynchronous, Runnable asyncCompletionTask) {
        return this.modifyRepositories("source", repositories, parent, progressHandle, asynchronous, asyncCompletionTask);
    }

    public boolean modifyRepositories(String pluginCmd, String[] repositories, JComponent parent, ProgressHandle progressHandle, boolean asynchronous, Runnable asyncCompletionTask) {
        ArrayList<String> argList = new ArrayList<String>();
        for (String repository : repositories) {
            argList.add(repository);
        }
        String[] args = argList.toArray(new String[argList.size()]);
        String title = NbBundle.getMessage(PluginManager.class, (String)"ModifySource");
        String success = NbBundle.getMessage(PluginManager.class, (String)"ModifySourceOk");
        String failure = NbBundle.getMessage(PluginManager.class, (String)"ModifySourceFailed");
        if (asynchronous) {
            this.asynchPluginRunner(parent, title, success, failure, null, asyncCompletionTask, pluginCmd, args);
            return false;
        }
        boolean ok = this.pluginRunner(pluginCmd, null, null, null, args);
        return ok;
    }

    public List<String> getRepositories(boolean local) {
        return local ? this.getLocalRepositories() : this.getRemoteRepositories();
    }

    private List<String> getRemoteRepositories() {
        ArrayList<String> lines = new ArrayList<String>(150);
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("--list");
        String[] args = argList.toArray(new String[argList.size()]);
        boolean ok = this.pluginRunner("discover", null, null, lines, args);
        if (ok) {
            return lines;
        }
        return Collections.emptyList();
    }

    private List<String> getLocalRepositories() {
        ArrayList<String> lines = new ArrayList<String>(150);
        ArrayList argList = new ArrayList();
        String[] args = argList.toArray(new String[argList.size()]);
        boolean ok = this.pluginRunner("sources", null, null, lines, args);
        if (ok) {
            return lines;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Plugin> getCachedList() {
        Class<PluginManager> clazz = PluginManager.class;
        synchronized (PluginManager.class) {
            BufferedReader is = null;
            try {
                File cacheFile = PluginManager.getCacheFile();
                if (!cacheFile.exists()) {
                    List<Plugin> list = null;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return list;
                }
                ArrayList<String> lines = new ArrayList<String>(5000);
                is = new BufferedReader(new FileReader(PluginManager.getCacheFile()));
                while (true) {
                    String line;
                    if ((line = is.readLine()) == null) {
                        ArrayList<Plugin> list = new ArrayList<Plugin>();
                        this.parsePluginList(lines, list, false);
                        ArrayList<Plugin> arrayList = list;
                        // ** MonitorExit[clazz] (shouldn't be in output)
                        return arrayList;
                    }
                    lines.add(line);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                List<Plugin> list2 = null;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return list2;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe3) {
                        Exceptions.printStackTrace((Throwable)ioe3);
                    }
                }
            }
        }
    }

    private void updateCachedList(List<String> lines) {
    }

    private static File getCacheFile() {
        return new File(PluginManager.getCacheFolder(), "remotePlugins.txt");
    }

    private static File getCacheFolder() {
        String nbUserProp = System.getProperty("netbeans.user");
        assert (nbUserProp != null);
        File nbUserDir = new File(nbUserProp);
        File cacheFolder = FileUtil.normalizeFile((File)new File(nbUserDir, "var" + File.separator + "cache" + File.separatorChar));
        if (!cacheFolder.exists()) {
            boolean created = cacheFolder.mkdirs();
            assert (created) : "Cannot create cache folder";
        } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        return cacheFolder;
    }

    private static synchronized File getPluginCustomizer() {
        File pluginScript = InstalledFileLocator.getDefault().locate(PLUGIN_CUSTOMIZER, "org.netbeans.modules.ruby.railsproject", false);
        if (pluginScript == null) {
            throw new IllegalStateException("Could not locate plugin.rb");
        }
        return pluginScript;
    }
}

