/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.AssignableNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.SplatNode;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.AssignmentVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode headNode;
    private final Node argsNode;

    public MultipleAsgnNode(ISourcePosition position, ListNode headNode, Node argsNode) {
        super(position, NodeType.MULTIPLEASGNNODE);
        this.headNode = headNode;
        this.argsNode = argsNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public ListNode getHeadNode() {
        return this.headNode;
    }

    @Override
    public Arity getArity() {
        if (this.argsNode != null) {
            return Arity.required(this.headNode == null ? 0 : this.headNode.size());
        }
        return Arity.fixed(this.headNode.size());
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.headNode, this.argsNode, this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        switch (this.getValueNode().nodeId) {
            case ARRAYNODE: {
                ArrayNode iVisited2 = (ArrayNode)this.getValueNode();
                return ASTInterpreter.multipleAsgnArrayNode(runtime, context, this, iVisited2, self, aBlock);
            }
            case SPLATNODE: {
                SplatNode splatNode = (SplatNode)this.getValueNode();
                RubyArray rubyArray = RuntimeHelpers.splatValue(splatNode.getValue().interpret(runtime, context, self, aBlock));
                return AssignmentVisitor.multiAssign(runtime, context, self, this, rubyArray, false);
            }
        }
        IRubyObject value = this.getValueNode().interpret(runtime, context, self, aBlock);
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArray(runtime, value);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, this, (RubyArray)value, false);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        if (!(value instanceof RubyArray)) {
            value = ArgsUtil.convertToRubyArray(runtime, value, this.headNode != null);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, this, (RubyArray)value, checkArity);
    }
}

