/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ConstNode
extends Node
implements INameNode {
    private String name;

    public ConstNode(ISourcePosition position, String name) {
        super(position, NodeType.CONSTNODE);
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitConstNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public String toString() {
        return "ConstNode [" + this.name + "]";
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return context.getConstant(this.name);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return context.getConstantDefined(this.name) ? "constant" : null;
    }
}

